/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.common.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Locale;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimePart;
import net.savignano.snotify.atlassian.common.Constants;
import net.savignano.snotify.atlassian.common.security.key.PgpKeyRingSplitter;
import net.savignano.thirdparty.org.bouncycastle.bcpg.ArmoredOutputStream;
import net.savignano.thirdparty.org.bouncycastle.bcpg.BCPGOutputStream;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPCompressedDataGenerator;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPEncryptedDataGenerator;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPException;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPLiteralData;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPLiteralDataGenerator;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPrivateKey;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKey;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKeyRing;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPSecretKey;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPSecretKeyRing;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPSignature;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPSignatureGenerator;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPSignatureList;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPSignatureSubpacketGenerator;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPUtil;
import net.savignano.thirdparty.org.bouncycastle.openpgp.bc.BcPGPObjectFactory;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.bc.BcPBESecretKeyDecryptorBuilder;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.bc.BcPGPContentSignerBuilder;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.bc.BcPGPContentVerifierBuilderProvider;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.bc.BcPGPDataEncryptorBuilder;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.bc.BcPGPDigestCalculatorProvider;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.bc.BcPublicKeyKeyEncryptionMethodGenerator;
import org.apache.commons.io.input.ReaderInputStream;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PgpUtil {
    private static final Logger log = LoggerFactory.getLogger(PgpUtil.class);
    public static final String ERROR_MESSAGE_FOR_WRONG_PASSWORD = "checksum mismatch at 0 of 20";

    public static final PGPPrivateKey extractPrivateKey(PGPSecretKey key, char[] password) throws PGPException {
        return key.extractPrivateKey(new BcPBESecretKeyDecryptorBuilder(new BcPGPDigestCalculatorProvider()).build(password));
    }

    public static final PGPPublicKeyRing loadPublicKey(InputStream is) throws IOException {
        return new PGPPublicKeyRing(PgpUtil.getPgpStream(is, PgpKeyRingSplitter.EPgpKeyRingSplitterType.PUBLIC), (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
    }

    public static final PGPPublicKeyRingCollection loadPublicKeys(InputStream is) throws IOException, PGPException {
        return new PGPPublicKeyRingCollection(PgpUtil.getPgpStream(is, PgpKeyRingSplitter.EPgpKeyRingSplitterType.PUBLIC), (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
    }

    public static final PGPSecretKeyRing loadSecretKey(InputStream is) throws IOException, PGPException {
        return new PGPSecretKeyRing(PgpUtil.getPgpStream(is, PgpKeyRingSplitter.EPgpKeyRingSplitterType.PRIVATE), (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
    }

    public static final PGPSecretKeyRingCollection loadSecretKeys(InputStream is) throws IOException, PGPException {
        return new PGPSecretKeyRingCollection(PgpUtil.getPgpStream(is, PgpKeyRingSplitter.EPgpKeyRingSplitterType.PRIVATE), (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
    }

    private static final InputStream getPgpStream(InputStream is, PgpKeyRingSplitter.EPgpKeyRingSplitterType type) throws IOException {
        InputStream stream = is;
        if (!stream.markSupported()) {
            stream = new BufferedInputStream(stream);
        }
        byte[] lookFor = "-----BEGIN PGP".getBytes(Constants.UTF8_CHARSET);
        byte[] buffer = new byte[lookFor.length];
        stream.mark(buffer.length);
        int read = stream.read(buffer);
        stream.reset();
        if (read == buffer.length && Arrays.equals(lookFor, buffer)) {
            InputStreamReader reader = new InputStreamReader(stream, Constants.UTF8_CHARSET);
            stream = new ReaderInputStream((Reader)new PgpKeyRingSplitter(reader, type), Constants.UTF8_CHARSET);
        }
        return PGPUtil.getDecoderStream(stream);
    }

    public static final boolean isSupportedSymmetricKeyAlgorithm(int algorithm) {
        return algorithm > 0 && algorithm < 14 && algorithm != 5 && algorithm != 2;
    }

    public static final byte[] encrypt(byte[] bytes, PGPPublicKey publicKey, int algorithm, boolean acsiiArmored, boolean zip) throws IOException, PGPException {
        if (bytes == null) {
            return null;
        }
        if (publicKey == null) {
            throw new PGPException("No public key given to encrypt bytes.");
        }
        if (!PgpUtil.isSupportedSymmetricKeyAlgorithm(algorithm)) {
            throw new PGPException("Unsupported symmetric key algorithm for PGP encryption: " + PgpUtil.getSymmetricCipherName(algorithm) + " (" + algorithm + ")");
        }
        if (log.isDebugEnabled()) {
            log.debug("Encrypting for PGP key ID: {}", (Object)PgpUtil.getPrettyId(publicKey));
            log.debug("Symmetric key algorithm used: {} ({})", (Object)PgpUtil.getSymmetricCipherName(algorithm), (Object)algorithm);
            log.debug("ASCII Armored: {} / Zip: {}", (Object)acsiiArmored, (Object)zip);
        }
        return PgpUtil.encrypt(bytes, algorithm, acsiiArmored, zip, publicKey);
    }

    public static final byte[] encrypt(byte[] bytes, PGPPublicKey[] publicKeys, int algorithm, boolean acsiiArmored, boolean zip) throws IOException, PGPException {
        if (bytes == null) {
            return null;
        }
        if (publicKeys == null || publicKeys.length == 0) {
            throw new PGPException("No public key(s) given to encrypt bytes.");
        }
        if (!PgpUtil.isSupportedSymmetricKeyAlgorithm(algorithm)) {
            throw new PGPException("Unsupported symmetric key algorithm for PGP encryption: " + PgpUtil.getSymmetricCipherName(algorithm) + " (" + algorithm + ")");
        }
        if (log.isDebugEnabled()) {
            Object[] ids = new String[publicKeys.length];
            for (int i = 0; i < ids.length; ++i) {
                ids[i] = PgpUtil.getPrettyId(publicKeys[i]);
            }
            log.debug("Encrypting for PGP key ID(s): {}", (Object)StringUtils.join((Object[])ids, (String)";"));
            log.debug("Symmetric key algorithm used: {} ({})", (Object)PgpUtil.getSymmetricCipherName(algorithm), (Object)algorithm);
            log.debug("ASCII Armored: {} / Zip: {}", (Object)acsiiArmored, (Object)zip);
        }
        return PgpUtil.encrypt(bytes, algorithm, acsiiArmored, zip, publicKeys);
    }

    private static final byte[] encrypt(byte[] bytes, int algorithm, boolean acsiiArmored, boolean zip, PGPPublicKey ... publicKeys) throws IOException, PGPException {
        ByteArrayOutputStream byteOut;
        block51: {
            byteOut = new ByteArrayOutputStream();
            try (OutputStream out = acsiiArmored ? new ArmoredOutputStream(byteOut) : byteOut;){
                BcPGPDataEncryptorBuilder encBuilder = new BcPGPDataEncryptorBuilder(algorithm);
                encBuilder.setWithIntegrityPacket(true);
                PGPEncryptedDataGenerator encDataGen = new PGPEncryptedDataGenerator(encBuilder);
                for (PGPPublicKey publicKey : publicKeys) {
                    BcPublicKeyKeyEncryptionMethodGenerator encMethodGen = new BcPublicKeyKeyEncryptionMethodGenerator(publicKey);
                    encDataGen.addMethod(encMethodGen);
                }
                try (OutputStream encDataGenOut = encDataGen.open(out, new byte[65536]);){
                    if (zip) {
                        PGPCompressedDataGenerator comDataGen = new PGPCompressedDataGenerator(1);
                        OutputStream comDataOut = comDataGen.open(encDataGenOut);
                        PGPLiteralDataGenerator lDataGen = new PGPLiteralDataGenerator();
                        try (OutputStream lDataOut = lDataGen.open(comDataOut, 'b', "_CONSOLE", PGPLiteralData.NOW, new byte[1024]);){
                            lDataOut.write(bytes);
                        }
                        comDataGen.close();
                        break block51;
                    }
                    PGPLiteralDataGenerator lDataGen = new PGPLiteralDataGenerator();
                    try (OutputStream lDataOut = lDataGen.open(encDataGenOut, 'b', "_CONSOLE", PGPLiteralData.NOW, new byte[1024]);){
                        lDataOut.write(bytes);
                    }
                }
            }
        }
        return byteOut.toByteArray();
    }

    public static final byte[] decrypt(InputStream encrypted, PGPSecretKeyRingCollection pgpSecretKeyRingCollection, char[] keyPassword, boolean enforcePreferredSymmetricKey) throws IOException, PGPException {
        if (encrypted == null) {
            return null;
        }
        if (pgpSecretKeyRingCollection == null || pgpSecretKeyRingCollection.size() == 0) {
            throw new PGPException("No secret key(s) given to decrypt bytes.");
        }
        log.debug("Decrypting PGP message");
        return PgpUtil.decryptStream(encrypted, pgpSecretKeyRingCollection, keyPassword, enforcePreferredSymmetricKey);
    }

    /*
     * Exception decompiling
     */
    private static final byte[] decryptStream(InputStream encrypted, PGPSecretKeyRingCollection pgpSecretKeyRingCollection, char[] keyPassword, boolean enforcePreferredSymmetricKey) throws IOException, PGPException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static final byte[] sign(byte[] bytes, PGPSecretKey key, char[] password, int algorithm, boolean acsiiArmored) throws IOException, PGPException {
        if (log.isDebugEnabled()) {
            log.debug("Signing with PGP key ID: {}", (Object)PgpUtil.getPrettyId(key));
            log.debug("ASCII Armored: {}", (Object)acsiiArmored);
        }
        PGPPublicKey publicKey = key.getPublicKey();
        PGPPrivateKey privateKey = PgpUtil.extractPrivateKey(key, password);
        BcPGPContentSignerBuilder builder = new BcPGPContentSignerBuilder(publicKey.getAlgorithm(), algorithm);
        PGPSignatureGenerator signatureGenerator = new PGPSignatureGenerator(builder);
        signatureGenerator.init(1, privateKey);
        String userId = publicKey.getUserIDs().next();
        PGPSignatureSubpacketGenerator subGenerator = new PGPSignatureSubpacketGenerator();
        subGenerator.setSignerUserID(false, userId);
        signatureGenerator.setHashedSubpackets(subGenerator.generate());
        for (byte b : bytes) {
            signatureGenerator.update(b);
        }
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        try (BCPGOutputStream sigOut = new BCPGOutputStream(acsiiArmored ? new ArmoredOutputStream(bOut) : bOut);){
            signatureGenerator.generate().encode(sigOut);
        }
        return bOut.toByteArray();
    }

    public static final boolean verify(byte[] contentBytes, byte[] signatureBytes, PGPPublicKey publicKey) throws IOException, PGPException {
        log.debug("Verifying signature with key ID: {}", (Object)PgpUtil.getPrettyId(publicKey));
        try (InputStream is = PGPUtil.getDecoderStream(new ByteArrayInputStream(signatureBytes));){
            BcPGPObjectFactory factory = new BcPGPObjectFactory(is);
            PGPSignatureList sigList = (PGPSignatureList)factory.nextObject();
            PGPSignature sig = sigList.get(0);
            if (sig.getKeyAlgorithm() != publicKey.getAlgorithm()) {
                log.info("Verifying signature failed, as public key's algorithm is not the same as algorithm of signature. Signature / Key: {} / {}", (Object)sig.getKeyAlgorithm(), (Object)publicKey.getAlgorithm());
                boolean bl = false;
                return bl;
            }
            sig.init(new BcPGPContentVerifierBuilderProvider(), publicKey);
            for (byte b : contentBytes) {
                sig.update(b);
            }
            boolean bl = sig.verify();
            return bl;
        }
    }

    public static final int[] getPreferredSymmetricKeyAlgorithms(PGPPublicKeyRing ring) {
        if (ring == null) {
            return new int[0];
        }
        return PgpUtil.getPreferredSymmetricKeyAlgorithms(ring.getPublicKey());
    }

    public static final int[] getPreferredSymmetricKeyAlgorithms(PGPPublicKey key) {
        if (key == null) {
            return new int[0];
        }
        PGPSignature signature = PgpUtil.getMatchingSignature(key);
        if (signature != null) {
            PGPSignatureSubpacketVector subPacket = signature.getHashedSubPackets();
            if (subPacket != null) {
                int[] preferredSymmetricAlgorithms = subPacket.getPreferredSymmetricAlgorithms();
                if (preferredSymmetricAlgorithms != null) {
                    log.debug("Preferred symmetric algorithms: {}", (Object)Arrays.toString(preferredSymmetricAlgorithms));
                    return preferredSymmetricAlgorithms;
                }
                log.debug("No preferred symmetric algorithms encountered.");
            } else {
                log.debug("No hashed sup packet encountered.");
            }
        }
        log.warn("No preferred symmetric key algorithms found for key with ID: {}", (Object)PgpUtil.getPrettyId(key));
        return new int[0];
    }

    private static PGPSignature getMatchingSignature(PGPPublicKey key) {
        long keyId = key.getKeyID();
        for (int certType : new int[]{19, 18, 17, 16}) {
            Iterator signatures = key.getSignaturesOfType(certType);
            while (signatures.hasNext()) {
                PGPSignature signature = (PGPSignature)signatures.next();
                if (keyId != signature.getKeyID()) continue;
                return signature;
            }
        }
        return null;
    }

    public static final PGPPublicKeyRing getKeysForEmail(PGPPublicKeyRingCollection coll, String email) {
        log.debug("Looking up key ring for email <{}>.", (Object)email);
        if (coll == null || email == null) {
            return null;
        }
        for (PGPPublicKeyRing ring : coll) {
            PGPPublicKey key = ring.getPublicKey();
            if (key == null || !key.isMasterKey()) {
                log.warn("Passed key ring collection contains a ring without a corresponding master key. Maybe key ring is corrupt.");
                continue;
            }
            if (!PgpUtil.isKeyForEmail(key, email)) continue;
            log.debug("Key with ID {} matches email.", (Object)PgpUtil.getPrettyId(key));
            return ring;
        }
        log.debug("Key ring for email <{}> was not found.");
        return null;
    }

    public static final PGPSecretKeyRing getKeysForEmail(PGPSecretKeyRingCollection coll, String email) {
        log.debug("Looking up key ring for email <{}>.", (Object)email);
        if (coll == null || email == null) {
            return null;
        }
        for (PGPSecretKeyRing ring : coll) {
            PGPSecretKey key = ring.getSecretKey();
            if (key == null || !key.isMasterKey()) {
                log.warn("Passed key ring collection contains a ring without a corresponding master key. Maybe key ring is corrupt.");
                continue;
            }
            if (!PgpUtil.isKeyForEmail(key, email)) continue;
            log.debug("Key with ID {} matches email.", (Object)PgpUtil.getPrettyId(key));
            return ring;
        }
        log.debug("Key ring for email <{}> was not found.", (Object)email);
        return null;
    }

    public static final boolean isKeyForEmail(PGPPublicKey key, String email) {
        log.debug("Checking whether key with ID {} is valid for email <{}>.", (Object)PgpUtil.getPrettyId(key), (Object)email);
        if (key == null || email == null) {
            log.debug("Key is not valid.");
            return false;
        }
        return PgpUtil.isKeyForEmail(key.getUserIDs(), email);
    }

    public static final boolean isKeyForEmail(PGPSecretKey key, String email) {
        log.debug("Checking whether key with ID {} is valid for email <{}>.", (Object)PgpUtil.getPrettyId(key), (Object)email);
        if (key == null || email == null) {
            log.debug("Key is not valid.");
            return false;
        }
        return PgpUtil.isKeyForEmail(key.getUserIDs(), email);
    }

    private static final boolean isKeyForEmail(Iterator<String> iter, String email) {
        String lcEmail = email.toLowerCase(Locale.ROOT);
        while (iter.hasNext()) {
            String userId = iter.next().toLowerCase(Locale.ROOT);
            log.trace("Checking user ID: {}", (Object)userId);
            if (!userId.contains(lcEmail)) continue;
            log.debug("Key is valid.");
            return true;
        }
        log.debug("Key is not valid.");
        return false;
    }

    public static final String getPrettyId(PGPPublicKey key) {
        if (key == null) {
            return null;
        }
        return PgpUtil.getPrettyId(key.getKeyID());
    }

    public static final String getPrettyId(PGPSecretKey key) {
        if (key == null) {
            return null;
        }
        return PgpUtil.getPrettyId(key.getKeyID());
    }

    public static final String getPrettyId(long id) {
        return Long.toHexString(id).toUpperCase(Locale.ROOT);
    }

    public static final boolean isMessageEncrypted(Message message) {
        if (!(message instanceof MimeMessage)) {
            log.debug("Message is not a MIME message, so can't be PGP encrypted. Encountered message class: {}", message.getClass());
            return false;
        }
        try {
            return PgpUtil.isEncrypted(message);
        }
        catch (IOException | MessagingException e) {
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private static final boolean isEncrypted(Part part) throws MessagingException, IOException {
        if (part.isMimeType("application/pgp-encrypted")) {
            return true;
        }
        Object content = part.getContent();
        if (content instanceof Multipart) {
            return PgpUtil.isEncrypted((Multipart)content);
        }
        if (content instanceof Part) {
            return PgpUtil.isEncrypted((Part)content);
        }
        return false;
    }

    private static final boolean isEncrypted(Multipart part) throws MessagingException, IOException {
        for (int i = 0; i < part.getCount(); ++i) {
            if (!PgpUtil.isEncrypted(part.getBodyPart(i))) continue;
            return true;
        }
        return false;
    }

    public static final boolean isMessageSigned(Message message) {
        if (!(message instanceof MimeMessage)) {
            log.debug("Message is not a MIME message, so can't be PGP signed. Encountered message class: {}", message.getClass());
            return false;
        }
        return PgpUtil.isSigned((MimePart)((Object)message));
    }

    private static final boolean isSigned(MimePart part) {
        try {
            ContentType type = new ContentType(part.getContentType());
            if (type.match("multipart/signed")) {
                String protocol = type.getParameter("protocol");
                return protocol != null && protocol.equalsIgnoreCase("application/pgp-signature");
            }
        }
        catch (MessagingException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    public static final String getSymmetricCipherName(int algorithm) {
        switch (algorithm) {
            case 0: {
                return "No Cipher";
            }
            case 1: {
                return "IDEA";
            }
            case 2: {
                return "Triple DES";
            }
            case 3: {
                return "CAST5";
            }
            case 4: {
                return "Blowfish";
            }
            case 5: {
                return "SAFER";
            }
            case 6: {
                return "DES";
            }
            case 7: {
                return "AES 128";
            }
            case 8: {
                return "AES 192";
            }
            case 9: {
                return "AES 256";
            }
            case 10: {
                return "Twofish";
            }
            case 11: {
                return "Camellia 128";
            }
            case 12: {
                return "Camellia 192";
            }
            case 13: {
                return "Camellia 256";
            }
        }
        return "Unknown (" + algorithm + ")";
    }

    public static String getHashName(int algorithm) {
        switch (algorithm) {
            case 2: {
                return "SHA1";
            }
            case 5: {
                return "MD2";
            }
            case 1: {
                return "MD5";
            }
            case 3: {
                return "RIPEMD160";
            }
            case 8: {
                return "SHA256";
            }
            case 9: {
                return "SHA384";
            }
            case 10: {
                return "SHA512";
            }
            case 11: {
                return "SHA224";
            }
            case 6: {
                return "TIGER";
            }
        }
        return "Unknown (" + algorithm + ")";
    }

    public static String getCompressionName(int algorithm) {
        switch (algorithm) {
            case 0: {
                return "Uncompressed";
            }
            case 1: {
                return "ZIP";
            }
            case 2: {
                return "ZLIB";
            }
            case 3: {
                return "BZIP2";
            }
        }
        return "Unknown (" + algorithm + ")";
    }
}

