/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.gui.keysource.verification;

import java.util.ArrayList;
import java.util.List;
import net.savignano.snotify.atlassian.common.ISnotifyI18n;
import net.savignano.snotify.atlassian.common.security.key.ISnotifyKey;
import net.savignano.snotify.atlassian.gui.keysource.verification.IKeySourceVerification;
import net.savignano.snotify.atlassian.gui.keysource.verification.VerificationStatus;
import net.savignano.snotify.atlassian.gui.keysource.verification.VerificationStatusBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AKeySourceVerification
implements IKeySourceVerification {
    private static final Logger log = LoggerFactory.getLogger(AKeySourceVerification.class);
    private final VerificationStatusBuilder builder;
    private final List<VerificationStatus> statusList = new ArrayList<VerificationStatus>();
    private boolean reportError = true;
    private boolean reportKey = true;

    public AKeySourceVerification(ISnotifyI18n i18n) {
        if (i18n == null) {
            throw new IllegalArgumentException("I18n must not be null.");
        }
        this.builder = new VerificationStatusBuilder(i18n);
    }

    @Override
    public List<VerificationStatus> verify() {
        try {
            this.doVerify();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            this.handleError(e);
        }
        return this.getStatusList();
    }

    protected abstract void doVerify() throws Exception;

    protected void handleError(Exception e) {
        if (this.isReportError()) {
            this.getBuilder().error();
            this.getBuilder().subTitle("net.savignano.snotify.verification.exception.title", new Object[0]);
            this.getBuilder().message("net.savignano.snotify.verification.exception.message", e.getClass().getSimpleName(), e.getMessage());
            this.build();
        }
    }

    protected void verifyKey(ISnotifyKey<?> key) {
        if (this.isReportKey()) {
            log.debug("Verifying key: {}", key);
            this.getBuilder().subTitle("net.savignano.snotify.key-verification.title", new Object[0]);
            if (key == null) {
                this.getBuilder().error();
                this.getBuilder().message("net.savignano.snotify.key-verification.noKey.message", new Object[0]);
            } else if (key.isValid()) {
                this.getBuilder().success();
                this.getBuilder().message("net.savignano.snotify.key-verification.success." + key.getCryptography().name() + ".message", new Object[0]);
            } else {
                this.getBuilder().error();
                this.getBuilder().message("net.savignano.snotify.key-verification.failure." + key.getCryptography().name() + ".message", this.getBuilder().getI18n().getText("net.savignano.snotify.verification." + key.getKeyPurpose().name()));
            }
            this.build();
        }
    }

    protected void build() {
        this.getStatusList().add(this.getBuilder().build());
    }

    protected ISnotifyI18n getI18n() {
        return this.getBuilder().getI18n();
    }

    protected VerificationStatusBuilder getBuilder() {
        return this.builder;
    }

    protected List<VerificationStatus> getStatusList() {
        return this.statusList;
    }

    public boolean isReportError() {
        return this.reportError;
    }

    public void setReportError(boolean reportError) {
        this.reportError = reportError;
    }

    public boolean isReportKey() {
        return this.reportKey;
    }

    public void setReportKey(boolean reportKey) {
        this.reportKey = reportKey;
    }
}

