/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.gui.keysource.verification.pgp;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Locale;
import net.savignano.snotify.atlassian.common.ISnotifyI18n;
import net.savignano.snotify.atlassian.gui.keysource.verification.AKeySourceVerification;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PgpKeyServerVerification
extends AKeySourceVerification {
    private static final String VERIFY_KEYSERVER_FILE_PART = "/pks/lookup?op=index&options=mr&exact=on&search=";
    private static final String HEADER_FIELD_LOCATION = "Location";
    private static final Logger log = LoggerFactory.getLogger(PgpKeyServerVerification.class);
    private final String location;
    private String email;
    private String searchEmail;

    public PgpKeyServerVerification(String location, ISnotifyI18n i18n) {
        super(i18n);
        this.location = location;
        if (location == null) {
            throw new IllegalArgumentException("Location must not be null.");
        }
        this.getBuilder().title("net.savignano.snotify.pgp-keyserver-verification.title", new Object[0]);
    }

    @Override
    protected void doVerify() throws Exception {
        this.emailPresent();
    }

    private void emailPresent() {
        if (StringUtils.isBlank((String)this.email)) {
            this.getBuilder().warning();
            this.getBuilder().subTitle("net.savignano.snotify.pgp-keyserver-verification.emailPresent.failure.title", new Object[0]);
            this.getBuilder().message("net.savignano.snotify.pgp-keyserver-verification.emailPresent.failure.message", this.location);
            this.build();
        } else {
            this.validateKeyServerUrl();
        }
    }

    private void validateKeyServerUrl() {
        log.debug("Verifying PGP key server location: {}", (Object)this.location);
        try {
            URL url = this.createKeyServerUrl(this.location);
            if (StringUtils.isNotEmpty((String)url.getHost())) {
                this.getBuilder().success();
                this.getBuilder().subTitle("net.savignano.snotify.pgp-keyserver-verification.validUrl.success.title", new Object[0]);
                this.getBuilder().message("net.savignano.snotify.pgp-keyserver-verification.validUrl.success.message", this.location);
                this.build();
                this.checkConnection(url);
            } else {
                this.getBuilder().error();
                this.getBuilder().subTitle("net.savignano.snotify.pgp-keyserver-verification.validUrl.missingHost.title", new Object[0]);
                this.getBuilder().message("net.savignano.snotify.pgp-keyserver-verification.validUrl.missingHost.message", this.location);
                this.build();
            }
        }
        catch (Exception e) {
            log.debug("Key server location is not a valid URL: " + this.location, (Throwable)e);
            this.getBuilder().error();
            this.getBuilder().subTitle("net.savignano.snotify.pgp-keyserver-verification.validUrl.exception.title", new Object[0]);
            this.getBuilder().message("net.savignano.snotify.pgp-keyserver-verification.validUrl.exception.message", this.location, e.getClass().getSimpleName(), e.getLocalizedMessage());
            this.build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkConnection(URL url) {
        log.debug("Verification of PGP key server. Used URL: {}", (Object)url);
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)url.openConnection();
            connection.setConnectTimeout(10000);
            connection.setReadTimeout(15000);
            connection.connect();
            int responseCode = connection.getResponseCode();
            String responseMessage = connection.getResponseMessage();
            log.debug("Response code for key server {} : {} ({})", new Object[]{this.location, responseCode, responseMessage});
            if (responseCode == 200) {
                this.getBuilder().success();
                this.getBuilder().subTitle("net.savignano.snotify.pgp-keyserver-verification.connect.success.title", new Object[0]);
                this.getBuilder().message("net.savignano.snotify.pgp-keyserver-verification.connect.success.message", url);
                this.build();
                this.checkResponseForEmail(connection);
            } else if (responseCode >= 300 && responseCode < 400 && connection.getHeaderField(HEADER_FIELD_LOCATION) != null) {
                String newLocation = connection.getHeaderField(HEADER_FIELD_LOCATION);
                log.debug("Response code {} received. Redirect to new location: {}", (Object)responseCode, (Object)newLocation);
                this.getBuilder().info();
                this.getBuilder().subTitle("net.savignano.snotify.pgp-keyserver-verification.connect.redirect.title", new Object[0]);
                this.getBuilder().message("net.savignano.snotify.pgp-keyserver-verification.connect.redirect.message", newLocation);
                this.build();
                this.checkConnection(new URL(newLocation));
            } else if (responseCode == 404) {
                this.getBuilder().success();
                this.getBuilder().subTitle("net.savignano.snotify.pgp-keyserver-verification.connect.success.title", new Object[0]);
                this.getBuilder().message("net.savignano.snotify.pgp-keyserver-verification.connect.success.message", url);
                this.build();
                this.getBuilder().warning();
                this.getBuilder().subTitle("net.savignano.snotify.pgp-keyserver-verification.connect.notfound.title", new Object[0]);
                this.getBuilder().message("net.savignano.snotify.pgp-keyserver-verification.connect.notfound.message", this.email);
                this.build();
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("Headers: {}", connection.getHeaderFields());
                }
                this.getBuilder().error();
                this.getBuilder().subTitle("net.savignano.snotify.pgp-keyserver-verification.connect.failure.title", new Object[0]);
                this.getBuilder().message("net.savignano.snotify.pgp-keyserver-verification.connect.failure.message", url, responseCode, responseMessage);
                this.build();
            }
        }
        catch (ClassCastException e) {
            log.debug("\"" + url + "\" isn't a HTTP-connection.", (Throwable)e);
            this.getBuilder().error();
            this.getBuilder().subTitle("net.savignano.snotify.pgp-keyserver-verification.connect.nothttp.title", new Object[0]);
            this.getBuilder().message("net.savignano.snotify.pgp-keyserver-verification.connect.nothttp.message", url);
            this.build();
        }
        catch (Exception e) {
            log.debug("Could not connect to \"" + url + "\".", (Throwable)e);
            this.getBuilder().error();
            this.getBuilder().subTitle("net.savignano.snotify.pgp-keyserver-verification.connect.exception.title", new Object[0]);
            this.getBuilder().message("net.savignano.snotify.pgp-keyserver-verification.connect.exception.message", url, e.getClass().getSimpleName(), e.getLocalizedMessage());
            this.build();
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    private void checkResponseForEmail(HttpURLConnection connection) {
        boolean emailFound;
        Exception e;
        boolean contentCorrect;
        boolean contentTypeCorrect;
        String contentType;
        block35: {
            log.debug("Checking server response for email <{}>.", (Object)this.email);
            contentType = null;
            contentTypeCorrect = false;
            contentCorrect = false;
            e = null;
            emailFound = false;
            try (InputStream is = connection.getInputStream();){
                contentType = connection.getContentType();
                log.debug("Received content type: {}", (Object)contentCorrect);
                if (contentType == null || !contentType.startsWith("text/plain")) break block35;
                contentTypeCorrect = true;
                String encoding = connection.getContentEncoding();
                try (LineIterator lineIterator = IOUtils.lineIterator((InputStream)is, (String)(encoding != null ? encoding : "UTF-8"));){
                    while (lineIterator.hasNext()) {
                        String line = URLDecoder.decode(lineIterator.nextLine(), "UTF-8").toLowerCase(Locale.ROOT);
                        log.trace(line);
                        if (!line.startsWith("uid:") && !line.startsWith("pub:")) continue;
                        contentCorrect = true;
                        if (!line.contains(this.searchEmail)) continue;
                        emailFound = true;
                        break;
                    }
                }
            }
            catch (Exception e1) {
                e = e1;
                log.debug("Error reading server response from: " + connection.getURL(), (Throwable)e);
            }
        }
        log.debug("Email <{}> found on key server: {}", (Object)this.email, (Object)emailFound);
        if (e != null) {
            this.getBuilder().error();
            this.getBuilder().subTitle("net.savignano.snotify.pgp-keyserver-verification.checkEmail.exception.title", new Object[0]);
            this.getBuilder().message("net.savignano.snotify.pgp-keyserver-verification.checkEmail.exception.message", this.email, e.getClass().getSimpleName(), e.getLocalizedMessage());
        } else if (!contentTypeCorrect) {
            this.getBuilder().error();
            this.getBuilder().subTitle("net.savignano.snotify.pgp-keyserver-verification.checkEmail.wrongContentType.title", new Object[0]);
            this.getBuilder().message("net.savignano.snotify.pgp-keyserver-verification.checkEmail.wrongContentType.message", contentType);
        } else if (!contentCorrect) {
            this.getBuilder().error();
            this.getBuilder().subTitle("net.savignano.snotify.pgp-keyserver-verification.checkEmail.wrongContent.title", new Object[0]);
            this.getBuilder().message("net.savignano.snotify.pgp-keyserver-verification.checkEmail.wrongContent.message", new Object[0]);
        } else if (emailFound) {
            this.getBuilder().success();
            this.getBuilder().subTitle("net.savignano.snotify.pgp-keyserver-verification.checkEmail.success.title", new Object[0]);
            this.getBuilder().message("net.savignano.snotify.pgp-keyserver-verification.checkEmail.success.message", this.email);
        } else {
            this.getBuilder().warning();
            this.getBuilder().subTitle("net.savignano.snotify.pgp-keyserver-verification.checkEmail.failure.title", new Object[0]);
            this.getBuilder().message("net.savignano.snotify.pgp-keyserver-verification.checkEmail.failure.message", this.email);
        }
        this.build();
    }

    private URL createKeyServerUrl(String base) throws MalformedURLException {
        String file;
        URL url;
        boolean hkpFound = base.startsWith("hkp");
        if (hkpFound) {
            hkpFound = true;
            url = new URL("http" + base.substring(3));
        } else {
            url = new URL(base);
        }
        try {
            file = VERIFY_KEYSERVER_FILE_PART + URLEncoder.encode(this.searchEmail, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.debug(e.getMessage(), (Throwable)e);
            file = VERIFY_KEYSERVER_FILE_PART + this.searchEmail;
        }
        if (hkpFound && url.getPort() == -1) {
            int port = url.getProtocol().equals("http") ? 11371 : 443;
            url = new URL(url.getProtocol(), url.getHost(), port, file);
        } else {
            url = new URL(url.getProtocol(), url.getHost(), url.getPort(), file);
        }
        return url;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
        this.searchEmail = email == null ? null : '<' + email.toLowerCase(Locale.ROOT) + '>';
    }
}

