/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.x509;

import java.io.IOException;
import java.security.Principal;
import java.security.cert.CertSelector;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import javax.security.auth.x500.X500Principal;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Encodable;
import net.savignano.thirdparty.org.bouncycastle.asn1.DERSequence;
import net.savignano.thirdparty.org.bouncycastle.asn1.x509.AttCertIssuer;
import net.savignano.thirdparty.org.bouncycastle.asn1.x509.GeneralName;
import net.savignano.thirdparty.org.bouncycastle.asn1.x509.GeneralNames;
import net.savignano.thirdparty.org.bouncycastle.asn1.x509.V2Form;
import net.savignano.thirdparty.org.bouncycastle.jce.X509Principal;
import net.savignano.thirdparty.org.bouncycastle.util.Selector;

public class AttributeCertificateIssuer
implements CertSelector,
Selector {
    final ASN1Encodable form;

    public AttributeCertificateIssuer(AttCertIssuer issuer) {
        this.form = issuer.getIssuer();
    }

    public AttributeCertificateIssuer(X500Principal principal) throws IOException {
        this(new X509Principal(principal.getEncoded()));
    }

    public AttributeCertificateIssuer(X509Principal principal) {
        this.form = new V2Form(GeneralNames.getInstance(new DERSequence(new GeneralName(principal))));
    }

    private Object[] getNames() {
        GeneralNames name = this.form instanceof V2Form ? ((V2Form)this.form).getIssuerName() : (GeneralNames)this.form;
        GeneralName[] names = name.getNames();
        ArrayList<X500Principal> l = new ArrayList<X500Principal>(names.length);
        for (int i = 0; i != names.length; ++i) {
            if (names[i].getTagNo() != 4) continue;
            try {
                l.add(new X500Principal(names[i].getName().toASN1Primitive().getEncoded()));
                continue;
            }
            catch (IOException e) {
                throw new RuntimeException("badly formed Name object");
            }
        }
        return l.toArray(new Object[l.size()]);
    }

    public Principal[] getPrincipals() {
        Object[] p = this.getNames();
        ArrayList<Object> l = new ArrayList<Object>();
        for (int i = 0; i != p.length; ++i) {
            if (!(p[i] instanceof Principal)) continue;
            l.add(p[i]);
        }
        return l.toArray(new Principal[l.size()]);
    }

    private boolean matchesDN(X500Principal subject, GeneralNames targets) {
        GeneralName[] names = targets.getNames();
        for (int i = 0; i != names.length; ++i) {
            GeneralName gn = names[i];
            if (gn.getTagNo() != 4) continue;
            try {
                if (!new X500Principal(gn.getName().toASN1Primitive().getEncoded()).equals(subject)) continue;
                return true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    public Object clone() {
        return new AttributeCertificateIssuer(AttCertIssuer.getInstance(this.form));
    }

    public boolean match(Certificate cert) {
        if (!(cert instanceof X509Certificate)) {
            return false;
        }
        X509Certificate x509Cert = (X509Certificate)cert;
        if (this.form instanceof V2Form) {
            V2Form issuer = (V2Form)this.form;
            if (issuer.getBaseCertificateID() != null) {
                return issuer.getBaseCertificateID().getSerial().hasValue(x509Cert.getSerialNumber()) && this.matchesDN(x509Cert.getIssuerX500Principal(), issuer.getBaseCertificateID().getIssuer());
            }
            GeneralNames name = issuer.getIssuerName();
            if (this.matchesDN(x509Cert.getSubjectX500Principal(), name)) {
                return true;
            }
        } else {
            GeneralNames name = (GeneralNames)this.form;
            if (this.matchesDN(x509Cert.getSubjectX500Principal(), name)) {
                return true;
            }
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AttributeCertificateIssuer)) {
            return false;
        }
        AttributeCertificateIssuer other = (AttributeCertificateIssuer)obj;
        return this.form.equals(other.form);
    }

    public int hashCode() {
        return this.form.hashCode();
    }

    public boolean match(Object obj) {
        if (!(obj instanceof X509Certificate)) {
            return false;
        }
        return this.match((Certificate)obj);
    }
}

