/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.common.security.access.pgp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import net.savignano.snotify.atlassian.common.Constants;
import net.savignano.snotify.atlassian.common.connector.LdapConnector;
import net.savignano.snotify.atlassian.common.enums.ECryptographyType;
import net.savignano.snotify.atlassian.common.enums.EKeySource;
import net.savignano.snotify.atlassian.common.enums.EKeyValidity;
import net.savignano.snotify.atlassian.common.info.InfoData;
import net.savignano.snotify.atlassian.common.security.access.AKeyLoader;
import net.savignano.snotify.atlassian.common.security.key.publicly.SnotifyPgpPublicKey;
import net.savignano.snotify.atlassian.common.util.PgpUtil;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PgpLdapLoader
extends AKeyLoader<SnotifyPgpPublicKey> {
    private static final Logger log = LoggerFactory.getLogger(PgpLdapLoader.class);
    public static final int INFO_NO_EMAIL = 200;
    public static final int INFO_LDAP_CONNECTED = 201;
    public static final int INFO_LDAP_DISCONNECTED = 202;
    public static final int INFO_LDAP_CONNECTION_ERROR = 203;
    public static final int INFO_SERVER_INFO = 204;
    public static final int INFO_SERVER_INFO_NOT_AVAILABLE = 205;
    public static final int INFO_EMAIL_FOUND = 206;
    public static final int INFO_EMAIL_NOT_FOUND = 207;
    private static final String PGP_KEY_SERVER_DN = "cn=PGPServerInfo";
    private static final String PGP_KEY_DN_FIELD = "pgpBaseKeySpaceDN";
    private static final String PGP_SOFTWARE_FIELD = "pgpSoftware";
    private static final String PGP_USER_ID_FIELD = "pgpUserId";
    private static final String PGP_KEY_FIELD = "pgpKey";
    private static final String PGP_KEY_LEGACY_FIELD = "pgpKeyV2";
    private static final String PGP_DISABLED_FIELD = "pgpDisabled";
    private static final String PGP_REVOKED_FIELD = "pgpRevoked";
    private final LdapConnector connector;
    private String email;

    public PgpLdapLoader(LdapConnector connector) {
        this(connector, null);
    }

    public PgpLdapLoader(LdapConnector connector, String email) {
        this.connector = connector;
        this.email = email;
        if (connector == null) {
            throw new IllegalArgumentException("LDAP connector must not be null.");
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected SnotifyPgpPublicKey loadInternalKey() throws Exception {
        if (this.getEmail() == null) {
            PgpLdapLoader.log.warn("No email given to look up PGP key for in LDAP.");
            this.getInfoDataManager().send(new InfoData(200, new Object[0]));
            return this.getValidityKey(EKeyValidity.ERROR);
        }
        PgpLdapLoader.log.info("Looking up PGP key for email <{}> in LDAP.", (Object)this.getEmail());
        try {
            PgpLdapLoader.log.debug("Connecting to LDAP server: {}", (Object)this.connector.getLdapUrl());
            this.connector.connect(this.createEnvironment());
            ** GOTO lbl24
        }
        catch (Exception e) {
            PgpLdapLoader.log.error("Could not connect to ldap at " + this.connector.getLdapUrl() + " because of exception. Error message: " + e.getMessage(), (Throwable)e);
            this.getInfoDataManager().send(new InfoData(203, new Object[]{this.connector.getLdapUrl(), e}));
            var2_3 = this.getValidityKey(EKeyValidity.ERROR);
            PgpLdapLoader.log.debug("Disconnecting from LDAP server.");
            this.getInfoDataManager().send(new InfoData(202, new Object[]{this.connector.getLdapUrl()}));
            this.connector.disconnect();
            return var2_3;
        }
        {
            catch (Throwable var5_8) {
                PgpLdapLoader.log.debug("Disconnecting from LDAP server.");
                this.getInfoDataManager().send(new InfoData(202, new Object[]{this.connector.getLdapUrl()}));
                this.connector.disconnect();
                throw var5_8;
            }
lbl24:
            // 1 sources

            this.getInfoDataManager().send(new InfoData(201, new Object[]{this.connector.getLdapUrl()}));
            context = this.connector.getContext();
            try {
                attributes = this.getKeyAttributes(context);
                key = this.getKey(attributes);
                PgpLdapLoader.log.info("Key for <{}> in LDAP: {}", (Object)this.getEmail(), (Object)key);
                var4_7 = key;
            }
            catch (NamingException e) {}
            {
                throw new Exception("Error retrieving PGP key for email " + this.getEmail() + " in LDAP. Error message: " + e.getMessage(), e);
            }
            PgpLdapLoader.log.debug("Disconnecting from LDAP server.");
            this.getInfoDataManager().send(new InfoData(202, new Object[]{this.connector.getLdapUrl()}));
            this.connector.disconnect();
            return var4_7;
        }
    }

    private Hashtable<String, String> createEnvironment() {
        return new Hashtable<String, String>();
    }

    private List<Attribute> getKeyAttributes(DirContext context) throws NamingException {
        String pgpKeyDn = this.getPgpKeyDn(context);
        SearchControls searchControl = new SearchControls(2, 0L, 10000, new String[]{PGP_KEY_FIELD, PGP_KEY_LEGACY_FIELD, PGP_DISABLED_FIELD}, false, false);
        String filter = "(&(pgpUserId=*<" + this.getEmail() + ">)(" + PGP_DISABLED_FIELD + "=0)(" + PGP_REVOKED_FIELD + "=0))";
        log.debug("Used filter: {}", (Object)filter);
        ArrayList<Attribute> keyAttributes = new ArrayList<Attribute>();
        NamingEnumeration<SearchResult> results = context.search(pgpKeyDn, filter, searchControl);
        while (results.hasMore()) {
            SearchResult result = results.next();
            log.debug("Found PGP key at: {}", (Object)result.getName());
            NamingEnumeration<? extends Attribute> attrs = result.getAttributes().getAll();
            while (attrs.hasMore()) {
                keyAttributes.add(attrs.next());
            }
        }
        log.debug("{} PGP key(s) found", (Object)keyAttributes.size());
        this.getInfoDataManager().send(new InfoData(keyAttributes.isEmpty() ? 207 : 206, this.getEmail()));
        return keyAttributes;
    }

    private String getPgpKeyDn(DirContext context) throws NamingException {
        List<String> baseDns = this.getBaseDns(context);
        List<String> keyServerInfoDns = this.getKeyServerInfoDns(baseDns);
        log.debug("Looking up PGP server info in LDAP.");
        for (String keyServerInfoDn : keyServerInfoDns) {
            Attributes attrs;
            log.debug("Looking up PGP server info at: {}", (Object)keyServerInfoDn);
            try {
                attrs = context.getAttributes(keyServerInfoDn, new String[]{PGP_KEY_DN_FIELD, PGP_SOFTWARE_FIELD});
            }
            catch (NameNotFoundException e) {
                log.debug("Pgp server info not found at: " + keyServerInfoDn, (Throwable)e);
                continue;
            }
            log.debug("PGP server info found at: {}", (Object)keyServerInfoDn);
            String serverInfo = (String)attrs.get(PGP_SOFTWARE_FIELD).get();
            log.info("PGP key server software: {}", (Object)serverInfo);
            this.getInfoDataManager().send(new InfoData(204, serverInfo));
            String pgpKeyDn = (String)attrs.get(PGP_KEY_DN_FIELD).get();
            log.debug("DN to search PGP keys in: {}", (Object)pgpKeyDn);
            return pgpKeyDn;
        }
        this.getInfoDataManager().send(new InfoData(205, new Object[0]));
        throw new NamingException("No PGP Server Info found. LDAP does probably not support PGP keys.");
    }

    private List<String> getBaseDns(DirContext context) throws NamingException {
        log.debug("Looking up naming contexts in LDAP.");
        Attributes attrs = context.getAttributes("", new String[]{"namingContexts"});
        Attribute attr = attrs.get("namingContexts");
        ArrayList<String> baseDns = new ArrayList<String>(attr.size());
        for (int i = 0; i < attr.size(); ++i) {
            String baseDn = (String)attr.get(i);
            log.trace("Base DN: {}", (Object)baseDn);
            baseDns.add(baseDn);
        }
        return baseDns;
    }

    private List<String> getKeyServerInfoDns(List<String> baseDns) {
        if (baseDns.contains(PGP_KEY_SERVER_DN)) {
            return Collections.singletonList(PGP_KEY_SERVER_DN);
        }
        ArrayList<String> keyServerInfoDns = new ArrayList<String>(baseDns.size());
        for (String baseDn : baseDns) {
            keyServerInfoDns.add("cn=PGPServerInfo," + baseDn);
        }
        return keyServerInfoDns;
    }

    private SnotifyPgpPublicKey getKey(List<Attribute> attributes) {
        SnotifyPgpPublicKey bestKey = null;
        for (Attribute attribute : attributes) {
            SnotifyPgpPublicKey key = this.getKey(attribute);
            if (key.getKeyValidity() == EKeyValidity.VALID) {
                bestKey = key;
                break;
            }
            if (bestKey == null) {
                bestKey = key;
                continue;
            }
            if (key.getKeyValidity().ordinal() >= bestKey.getKeyValidity().ordinal()) continue;
            bestKey = key;
        }
        if (bestKey == null) {
            bestKey = this.getValidityKey(EKeyValidity.NOT_FOUND);
        }
        return bestKey;
    }

    private SnotifyPgpPublicKey getKey(Attribute attribute) {
        String keyString;
        try {
            keyString = (String)attribute.get();
        }
        catch (NamingException e) {
            log.error("Could not read PGP key. Error message: " + e.getMessage(), (Throwable)e);
            return this.getValidityKey(EKeyValidity.ERROR);
        }
        try {
            PGPPublicKeyRing keyRing = PgpUtil.loadPublicKey(new ByteArrayInputStream(keyString.getBytes(Constants.UTF8_CHARSET)));
            SnotifyPgpPublicKey key = new SnotifyPgpPublicKey(keyRing, this.getEmail());
            key.setKeySource(this.getKeySource());
            return key;
        }
        catch (IOException e) {
            log.error("Could not load PGP key. Error message: " + e.getMessage(), (Throwable)e);
            return this.getValidityKey(EKeyValidity.ERROR);
        }
    }

    @Override
    public EKeySource getKeySource() {
        return EKeySource.LDAP;
    }

    @Override
    public ECryptographyType getCryptography() {
        return ECryptographyType.PGP;
    }

    @Override
    protected SnotifyPgpPublicKey getValidityKey(EKeyValidity validity) {
        return new SnotifyPgpPublicKey(validity, this.getKeySource());
    }

    public LdapConnector getConnector() {
        return this.connector;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String toString() {
        return "PgpVksLdapLoader [connector=" + this.connector + ", email=" + this.email + "]";
    }
}

