/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.gui.keysource.verification.pgp;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.LinkedHashSet;
import java.util.Set;
import net.savignano.snotify.atlassian.common.ISnotifyI18n;
import net.savignano.snotify.atlassian.common.security.key.secret.SnotifyPgpSignKey;
import net.savignano.snotify.atlassian.common.util.PgpUtil;
import net.savignano.snotify.atlassian.gui.keysource.verification.AKeySourceVerification;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPrivateKey;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPSecretKey;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPSecretKeyRing;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.bc.BcPBESecretKeyDecryptorBuilder;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.bc.BcPGPDigestCalculatorProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PgpPrivateKeyStoreVerification
extends AKeySourceVerification {
    private static final Logger log = LoggerFactory.getLogger(PgpPrivateKeyStoreVerification.class);
    private final String location;
    private final Set<String> emails = new LinkedHashSet<String>();
    private char[] password;

    public PgpPrivateKeyStoreVerification(String location, ISnotifyI18n i18n) {
        super(i18n);
        if (location == null) {
            throw new IllegalArgumentException("Location must not be null.");
        }
        this.location = location;
        this.getBuilder().title("net.savignano.snotify.pgp-private-keystore-verification.title", new Object[0]);
    }

    @Override
    protected void doVerify() throws Exception {
        this.canReadLocation();
    }

    private void canReadLocation() {
        Exception e = null;
        boolean canRead = false;
        try {
            canRead = new File(this.location).canRead();
            log.debug("Can access key store at location {}: {}", (Object)this.location, (Object)canRead);
        }
        catch (Exception e1) {
            e = e1;
            log.debug("Can not access key store location: " + this.location, (Throwable)e);
        }
        if (canRead) {
            this.getBuilder().success();
            this.getBuilder().subTitle("net.savignano.snotify.pgp-keystore-verification.canRead.success.title", new Object[0]);
            this.getBuilder().message("net.savignano.snotify.pgp-keystore-verification.canRead.success.message", this.location);
            this.build();
            this.loadKeyStore();
        } else if (e != null) {
            this.getBuilder().error();
            this.getBuilder().subTitle("net.savignano.snotify.pgp-keystore-verification.canRead.exception.title", new Object[0]);
            this.getBuilder().message("net.savignano.snotify.pgp-keystore-verification.canRead.exception.message", this.location, e.getClass().getSimpleName(), e.getLocalizedMessage());
            this.build();
        } else {
            this.getBuilder().error();
            this.getBuilder().subTitle("net.savignano.snotify.pgp-keystore-verification.canRead.failure.title", new Object[0]);
            this.getBuilder().message("net.savignano.snotify.pgp-keystore-verification.canRead.failure.message", this.location);
            this.build();
        }
    }

    private void loadKeyStore() {
        Exception e = null;
        PGPSecretKeyRingCollection ks = null;
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(this.location));){
            ks = PgpUtil.loadSecretKeys(is);
            log.debug("Could load key store from location: {}", (Object)this.location);
        }
        catch (Exception e1) {
            e = e1;
            log.debug("Could not load key store from location: " + this.location, (Throwable)e);
        }
        if (e == null) {
            this.getBuilder().success();
            this.getBuilder().subTitle("net.savignano.snotify.pgp-keystore-verification.loadKeyStore.success.title", new Object[0]);
            this.getBuilder().message("net.savignano.snotify.pgp-keystore-verification.loadKeyStore.success.message", new Object[0]);
            this.build();
            this.checkEmail(ks);
        } else {
            this.getBuilder().error();
            this.getBuilder().subTitle("net.savignano.snotify.pgp-keystore-verification.loadKeyStore.exception.title", new Object[0]);
            this.getBuilder().message("net.savignano.snotify.pgp-keystore-verification.loadKeyStore.exception.message", e.getClass().getSimpleName(), e.getLocalizedMessage());
            this.build();
        }
    }

    private void checkEmail(PGPSecretKeyRingCollection keyStore) {
        if (keyStore == null) {
            return;
        }
        if (this.getEmails().isEmpty()) {
            log.debug("No email address was given, so can't check if a key was found for it.");
            this.getBuilder().info();
            this.getBuilder().subTitle("net.savignano.snotify.pgp-keystore-verification.checkEmail.noServer.title", new Object[0]);
            this.getBuilder().message("net.savignano.snotify.pgp-keystore-verification.checkEmail.noServer.message", new Object[0]);
            this.build();
            return;
        }
        for (String email : this.getEmails()) {
            PGPSecretKeyRing ring = PgpUtil.getKeysForEmail(keyStore, email);
            if (ring != null) {
                log.debug("Key for email <{}> was found in key store.", (Object)email);
                this.getBuilder().success();
                this.getBuilder().subTitle("net.savignano.snotify.pgp-keystore-verification.checkEmail.success.title", new Object[0]);
                this.getBuilder().message("net.savignano.snotify.pgp-keystore-verification.checkEmail.success.message", email);
                this.build();
                this.checkPassword(ring);
                continue;
            }
            log.debug("No key for email <{}> was found in key store.", (Object)email);
            this.getBuilder().warning();
            this.getBuilder().subTitle("net.savignano.snotify.pgp-keystore-verification.checkEmail.failure.title", new Object[0]);
            this.getBuilder().message("net.savignano.snotify.pgp-keystore-verification.checkEmail.failure.message", email);
            this.build();
        }
    }

    private void checkPassword(PGPSecretKeyRing ring) {
        if (this.getPassword() == null) {
            log.debug("No password was given, so can't check if password is correct.");
            this.getBuilder().info();
            this.getBuilder().subTitle("net.savignano.snotify.pgp-keystore-verification.checkPassword.noPassword.title", new Object[0]);
            this.getBuilder().message("net.savignano.snotify.pgp-keystore-verification.checkPassword.noPassword.message", new Object[0]);
            this.build();
            return;
        }
        PGPSecretKey key = ring.getSecretKey();
        try {
            PGPPrivateKey privateKey = key.extractPrivateKey(new BcPBESecretKeyDecryptorBuilder(new BcPGPDigestCalculatorProvider()).build(this.getPassword()));
            log.debug("Key with ID {} could be extraced with given password.", (Object)PgpUtil.getPrettyId(privateKey.getKeyID()));
            this.getBuilder().success();
            this.getBuilder().subTitle("net.savignano.snotify.pgp-keystore-verification.checkPassword.success.title", new Object[0]);
            this.getBuilder().message("net.savignano.snotify.pgp-keystore-verification.checkPassword.success.message", PgpUtil.getPrettyId(key));
            this.build();
            this.verifyKey(new SnotifyPgpSignKey(ring, this.getPassword()));
        }
        catch (Exception e) {
            log.debug("Could not open key key with given password.", (Throwable)e);
            this.getBuilder().error();
            this.getBuilder().subTitle("net.savignano.snotify.pgp-keystore-verification.checkPassword.failure.title", new Object[0]);
            this.getBuilder().message("net.savignano.snotify.pgp-keystore-verification.checkPassword.failure.message", PgpUtil.getPrettyId(key));
            this.build();
        }
    }

    public Set<String> getEmails() {
        return this.emails;
    }

    public char[] getPassword() {
        return this.password;
    }

    public void setPassword(char[] password) {
        this.password = password;
    }
}

