/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.confluence.gui.action;

import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.mail.server.MailServerManager;
import com.atlassian.mail.server.SMTPMailServer;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.velocity.htmlsafe.HtmlSafe;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import net.savignano.snotify.atlassian.common.ASnotifyAppProperties;
import net.savignano.snotify.atlassian.common.EProperty;
import net.savignano.snotify.atlassian.common.ISnotifyI18n;
import net.savignano.snotify.atlassian.common.enums.ECryptographyType;
import net.savignano.snotify.atlassian.common.enums.EEncryptionTypePriority;
import net.savignano.snotify.atlassian.common.util.SecurityUtil;
import net.savignano.snotify.atlassian.gui.keysource.verification.VerificationStatus;
import net.savignano.snotify.atlassian.gui.keysource.verification.pgp.PgpPrivateKeyStoreVerification;
import net.savignano.snotify.atlassian.gui.keysource.verification.smime.SmimeKeyStoreVerification;
import net.savignano.snotify.confluence.gui.action.SnotifyAdminSettingsAction;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnotifyPrivateKeystoreSettingsAction
extends SnotifyAdminSettingsAction {
    private static final long serialVersionUID = 6798270464796403431L;
    private static final String SMIME_PRIVATE_KEYSTORE_LOCATION_PARAM = "smimePrivateKeystoreLocation";
    private static final String SMIME_PRIVATE_KEYSTORE_PASSWORD_PARAM = "smimePrivateKeystorePassword";
    private static final String SMIME_PRIVATE_KEYSTORE_PASSWORD_CHECK_PARAM = "smimePrivateKeystorePasswordCheck";
    private static final String PGP_PRIVATE_KEYSTORE_LOCATION_PARAM = "pgpPrivateKeystoreLocation";
    private static final String PGP_PRIVATE_KEY_PASSWORD_PARAM = "pgpPrivateKeyPassword";
    private static final String PGP_PRIVATE_KEY_PASSWORD_CHECK_PARAM = "pgpPrivateKeyPasswordCheck";
    private static final String VERIFY_PGP_BUTTON_PARAM = "Test settings pgp";
    private static final String VERIFY_SMIME_BUTTON_PARAM = "Test settings smime";
    private static final String CLEAR_CACHE_PGP_BUTTON_PARAM = "Clear Cache pgp";
    private static final String CLEAR_CACHE_SMIME_PARAM = "Clear Cache smime";
    private static final String SUBMIT_PGP_BUTTON_PARAM = "Update pgp";
    private static final String SUBMIT_SMIME_BUTTON_PARAM = "Update smime";
    private static final Logger log = LoggerFactory.getLogger(SnotifyPrivateKeystoreSettingsAction.class);
    private String pgpPrivateKeystoreLocation;
    private String smimePrivateKeystoreLocation;
    private String verifyMessage;
    private boolean expireKeys;
    private String pgpPrivateKeyPassword;
    private String smimePrivateKeystorePassword;
    private EEncryptionTypePriority typePriority;
    private ECryptographyType lastSubmit;
    private String mailServerEmail;

    public String doInput() {
        if (!this.hasAdminRights()) {
            ConfluenceUser user = this.getAuthenticatedUser();
            log.warn("Unauthorized access to view global S/Notify values from user: {}", (Object)(user != null ? user.getFullName() : "<Unknown User>"));
            return "error";
        }
        if (this.smimePrivateKeystoreLocation == null) {
            this.readProps();
        }
        return "input";
    }

    public String doSubmit() {
        HttpServletRequest request = this.getCurrentRequest();
        if (!"POST".equals(request.getMethod())) {
            log.debug("Access to submit method redirected to input method, as request method wasn't 'POST'. Used method: " + request.getMethod());
            return this.doInput();
        }
        if (!this.hasAdminRights()) {
            ConfluenceUser user = this.getAuthenticatedUser();
            log.warn("Unauthorized access to submit private S/Notify values from user: {}", (Object)(user != null ? user.getFullName() : "<Unknown User>"));
            return "error";
        }
        this.readParams();
        if (request.getParameter(SUBMIT_PGP_BUTTON_PARAM) != null) {
            this.lastSubmit = ECryptographyType.PGP;
            return this.storeSettings();
        }
        if (request.getParameter(SUBMIT_SMIME_BUTTON_PARAM) != null) {
            this.lastSubmit = ECryptographyType.SMIME;
            return this.storeSettings();
        }
        if (request.getParameter(VERIFY_PGP_BUTTON_PARAM) != null) {
            this.lastSubmit = ECryptographyType.PGP;
            return this.verifySettings();
        }
        if (request.getParameter(VERIFY_SMIME_BUTTON_PARAM) != null) {
            this.lastSubmit = ECryptographyType.SMIME;
            return this.verifySettings();
        }
        if (request.getParameter(CLEAR_CACHE_PGP_BUTTON_PARAM) != null) {
            this.lastSubmit = ECryptographyType.PGP;
            return this.clearCache();
        }
        if (request.getParameter(CLEAR_CACHE_SMIME_PARAM) != null) {
            this.lastSubmit = ECryptographyType.SMIME;
            return this.clearCache();
        }
        log.error("Unknown submit option used.");
        return "input";
    }

    private String storeSettings() {
        this.storeProps();
        this.readProps();
        this.setShowUpdated(true);
        return "success";
    }

    private String verifySettings() {
        ArrayList<VerificationStatus> statusList = new ArrayList<VerificationStatus>();
        if (this.smimePrivateKeystoreLocation != null && !this.smimePrivateKeystoreLocation.isEmpty()) {
            statusList.addAll(this.verifySmimePrivateKeystore());
        }
        if (this.pgpPrivateKeystoreLocation != null && !this.pgpPrivateKeystoreLocation.isEmpty()) {
            statusList.addAll(this.verifyPgpPrivateKeystore());
        }
        StringBuilder builder = new StringBuilder(512 * statusList.size());
        for (VerificationStatus status : statusList) {
            builder.append(status.getHtmlStatus());
        }
        this.verifyMessage = builder.toString();
        return "input";
    }

    private List<VerificationStatus> verifySmimePrivateKeystore() {
        log.info("Verifying S/MIME private key store at location: {}", (Object)this.smimePrivateKeystoreLocation);
        ISnotifyI18n i18n = this.getSnotifyI18n();
        SmimeKeyStoreVerification verification = new SmimeKeyStoreVerification(this.smimePrivateKeystoreLocation, "PKCS12", i18n);
        verification.getEmails().addAll(this.getEmails());
        try {
            char[] decoded = SecurityUtil.decodeCharsBase64Aes(this.smimePrivateKeystorePassword);
            verification.setKeyStorePassword(decoded);
            verification.setKeyPassword(decoded);
        }
        catch (GeneralSecurityException e) {
            log.error("Could not set password for S/MIME key store verification. Error message: " + e.getMessage(), (Throwable)e);
        }
        verification.setEnablePrivateKeyCheck(true);
        return verification.verify();
    }

    private List<VerificationStatus> verifyPgpPrivateKeystore() {
        log.info("Verifying PGP private key store at location: {}", (Object)this.pgpPrivateKeystoreLocation);
        ISnotifyI18n i18n = this.getSnotifyI18n();
        PgpPrivateKeyStoreVerification verification = new PgpPrivateKeyStoreVerification(this.pgpPrivateKeystoreLocation, i18n);
        verification.getEmails().addAll(this.getEmails());
        try {
            verification.setPassword(SecurityUtil.decodeCharsBase64Aes(this.pgpPrivateKeyPassword));
        }
        catch (GeneralSecurityException e) {
            log.error("Could not set password for PGP key store verification. Error message: " + e.getMessage(), (Throwable)e);
        }
        return verification.verify();
    }

    private String clearCache() {
        this.storeClearCache();
        this.expireKeys = true;
        return "input";
    }

    private void storeClearCache() {
        this.getAppProps().setLong(EProperty.EXPIRE_KEYS_PRIVATE_TIMESTAMP, System.currentTimeMillis());
    }

    private EEncryptionTypePriority getTypePriority() {
        if (this.typePriority == null) {
            this.typePriority = this.getAppProps().getEnum(EProperty.ENCRYPTION_TYPE_PRIORITY, EEncryptionTypePriority.class);
        }
        return this.typePriority;
    }

    private List<String> getEmails() {
        ArrayList<String> emails = new ArrayList<String>();
        String email = this.getMailServerEmail();
        if (email != null) {
            emails.add(email);
        }
        return emails;
    }

    private String getMailServerEmail() {
        if (this.mailServerEmail == null) {
            SMTPMailServer mailServer = ((MailServerManager)ComponentLocator.getComponent(MailServerManager.class)).getDefaultSMTPMailServer();
            if (mailServer != null) {
                this.mailServerEmail = mailServer.getDefaultFrom();
                log.debug("Mail addressed used by default mail server: <{}>", (Object)this.mailServerEmail);
            } else {
                log.debug("No outgoing mail server registered. Could not determine sending address.");
            }
        }
        return this.mailServerEmail;
    }

    public boolean isSmimeSelected() {
        if (this.lastSubmit == ECryptographyType.SMIME) {
            return true;
        }
        if (this.lastSubmit == ECryptographyType.PGP) {
            return false;
        }
        switch (this.getTypePriority()) {
            case SMIME_ONLY: 
            case SMIME_PREFERED: {
                return true;
            }
            case PGP_ONLY: 
            case PGP_PREFERED: {
                return false;
            }
        }
        log.error("Type priority not yet implemented: {}", (Object)this.getTypePriority());
        return false;
    }

    public boolean isPgpSelected() {
        if (this.lastSubmit == ECryptographyType.PGP) {
            return true;
        }
        if (this.lastSubmit == ECryptographyType.SMIME) {
            return false;
        }
        switch (this.getTypePriority()) {
            case SMIME_ONLY: 
            case SMIME_PREFERED: {
                return false;
            }
            case PGP_ONLY: 
            case PGP_PREFERED: {
                return true;
            }
        }
        log.error("Type priority not yet implemented: {}", (Object)this.getTypePriority());
        return false;
    }

    public boolean isShowExpireCacheInfo() {
        return this.expireKeys;
    }

    public boolean isShowLeavingPageWarning() {
        return this.verifyMessage != null;
    }

    @HtmlSafe
    public String getVerificationMessage() {
        return this.verifyMessage == null ? "" : this.verifyMessage;
    }

    public String getPgpPrivateKeystoreLocation() {
        return this.pgpPrivateKeystoreLocation == null ? "" : this.pgpPrivateKeystoreLocation;
    }

    public String getPgpPrivateKeyPassword() {
        char[] password;
        if (this.pgpPrivateKeyPassword == null) {
            return "";
        }
        try {
            password = SecurityUtil.decodeCharsBase64Aes(this.pgpPrivateKeyPassword);
        }
        catch (GeneralSecurityException e) {
            log.error("Could not display PGP password. Error message: " + e.getMessage(), (Throwable)e);
            return "";
        }
        for (int i = 0; i < password.length; ++i) {
            password[i] = 42;
        }
        return new String(password);
    }

    public String getPgpPrivateKeyPasswordCheck() {
        return this.pgpPrivateKeyPassword == null ? "" : this.pgpPrivateKeyPassword;
    }

    public String getSmimePrivateKeystoreLocation() {
        return this.smimePrivateKeystoreLocation == null ? "" : this.smimePrivateKeystoreLocation;
    }

    public String getSmimePrivateKeystorePassword() {
        char[] password;
        if (this.smimePrivateKeystorePassword == null) {
            return "";
        }
        try {
            password = SecurityUtil.decodeCharsBase64Aes(this.smimePrivateKeystorePassword);
        }
        catch (GeneralSecurityException e) {
            log.error("Could not display S/MIME password. Error message: " + e.getMessage(), (Throwable)e);
            return "";
        }
        for (int i = 0; i < password.length; ++i) {
            password[i] = 42;
        }
        return new String(password);
    }

    public String getSmimePrivateKeystorePasswordCheck() {
        return this.smimePrivateKeystorePassword == null ? "" : this.smimePrivateKeystorePassword;
    }

    private boolean isDummyPassword(String password) {
        for (int i = 0; i < password.length(); ++i) {
            if (password.charAt(i) == '*') continue;
            return false;
        }
        return true;
    }

    private void readParams() {
        this.pgpPrivateKeystoreLocation = this.getCurrentRequest().getParameter(PGP_PRIVATE_KEYSTORE_LOCATION_PARAM);
        this.pgpPrivateKeyPassword = this.getCurrentRequest().getParameter(PGP_PRIVATE_KEY_PASSWORD_PARAM);
        if (StringUtils.isBlank((String)this.pgpPrivateKeyPassword)) {
            this.pgpPrivateKeyPassword = null;
        } else if (this.isDummyPassword(this.pgpPrivateKeyPassword)) {
            this.pgpPrivateKeyPassword = this.getCurrentRequest().getParameter(PGP_PRIVATE_KEY_PASSWORD_CHECK_PARAM);
        } else {
            try {
                this.pgpPrivateKeyPassword = SecurityUtil.encode(this.pgpPrivateKeyPassword);
            }
            catch (GeneralSecurityException e) {
                log.error("Could not obfuscate entered PGP password. Error message: " + e.getMessage(), (Throwable)e);
            }
        }
        this.smimePrivateKeystoreLocation = this.getCurrentRequest().getParameter(SMIME_PRIVATE_KEYSTORE_LOCATION_PARAM);
        this.smimePrivateKeystorePassword = this.getCurrentRequest().getParameter(SMIME_PRIVATE_KEYSTORE_PASSWORD_PARAM);
        if (StringUtils.isBlank((String)this.smimePrivateKeystorePassword)) {
            this.smimePrivateKeystorePassword = null;
        } else if (this.isDummyPassword(this.smimePrivateKeystorePassword)) {
            this.smimePrivateKeystorePassword = this.getCurrentRequest().getParameter(SMIME_PRIVATE_KEYSTORE_PASSWORD_CHECK_PARAM);
        } else {
            try {
                this.smimePrivateKeystorePassword = SecurityUtil.encode(this.smimePrivateKeystorePassword);
            }
            catch (GeneralSecurityException e) {
                log.error("Could not obfuscate entered S/MIME password. Error message: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    private void storeProps() {
        if (this.isLocationChanged()) {
            this.storeClearCache();
        }
        this.getAppProps().setString(EProperty.PRIVATE_PGP_KEYSTORE_LOCATION, this.pgpPrivateKeystoreLocation);
        try {
            this.getAppProps().setPassword(EProperty.PRIVATE_PGP_KEY_PASSWORD, SecurityUtil.decodeCharsBase64Aes(this.pgpPrivateKeyPassword));
        }
        catch (GeneralSecurityException e) {
            log.error("Could not store PGP password. Error message: " + e.getMessage(), (Throwable)e);
        }
        this.getAppProps().setString(EProperty.PRIVATE_SMIME_KEYSTORE_LOCATION, this.smimePrivateKeystoreLocation);
        try {
            this.getAppProps().setPassword(EProperty.PRIVATE_SMIME_KEY_PASSWORD, SecurityUtil.decodeCharsBase64Aes(this.smimePrivateKeystorePassword));
        }
        catch (GeneralSecurityException e) {
            log.error("Could not store S/MIME password. Error message: " + e.getMessage(), (Throwable)e);
        }
    }

    private void readProps() {
        this.pgpPrivateKeystoreLocation = this.getAppProps().getString(EProperty.PRIVATE_PGP_KEYSTORE_LOCATION);
        this.smimePrivateKeystoreLocation = this.getAppProps().getString(EProperty.PRIVATE_SMIME_KEYSTORE_LOCATION);
        this.pgpPrivateKeyPassword = ((ASnotifyAppProperties)this.getAppProps()).getAsString(EProperty.PRIVATE_PGP_KEY_PASSWORD);
        this.smimePrivateKeystorePassword = ((ASnotifyAppProperties)this.getAppProps()).getAsString(EProperty.PRIVATE_SMIME_KEY_PASSWORD);
    }

    private boolean isLocationChanged() {
        String oldSmimeKeystoreLocation = this.getAppProps().getString(EProperty.PRIVATE_SMIME_KEYSTORE_LOCATION);
        if (!StringUtils.equalsIgnoreCase((String)StringUtils.stripToNull((String)oldSmimeKeystoreLocation), (String)StringUtils.stripToNull((String)this.smimePrivateKeystoreLocation))) {
            return true;
        }
        String oldPgpKeystoreLocation = this.getAppProps().getString(EProperty.PRIVATE_PGP_KEYSTORE_LOCATION);
        return !StringUtils.equalsIgnoreCase((String)StringUtils.stripToNull((String)oldPgpKeystoreLocation), (String)StringUtils.stripToNull((String)this.pgpPrivateKeystoreLocation));
    }
}

