/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.gui.keysource.verification.pgp;

import java.util.function.Consumer;
import net.savignano.snotify.atlassian.common.ISnotifyI18n;
import net.savignano.snotify.atlassian.common.info.InfoData;
import net.savignano.snotify.atlassian.common.security.access.pgp.PgpLdapLoader;
import net.savignano.snotify.atlassian.common.security.key.ISnotifyKey;
import net.savignano.snotify.atlassian.gui.keysource.verification.AKeySourceVerification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PgpLdapVerification
extends AKeySourceVerification {
    private static final Logger log = LoggerFactory.getLogger(PgpLdapVerification.class);
    private final PgpLdapLoader loader;

    public PgpLdapVerification(PgpLdapLoader loader, ISnotifyI18n i18n) {
        super(i18n);
        this.loader = loader;
        if (loader == null) {
            throw new IllegalArgumentException("Loader must not be null.");
        }
        this.getBuilder().title("net.savignano.snotify.pgp-ldap-verification.title", new Object[0]);
        this.setReportKey(false);
    }

    @Override
    protected void doVerify() throws Exception {
        Consumer<InfoData> consumer = this::handleInfoData;
        this.loader.getInfoDataManager().register(consumer);
        this.loader.loadKey();
        this.loader.getInfoDataManager().unregister(consumer);
    }

    private void handleInfoData(InfoData data) {
        switch (data.infoType) {
            case 102: {
                this.handleError((Exception)data.additionalData[0]);
                break;
            }
            case 100: {
                this.verifyKey((ISnotifyKey)data.additionalData[0]);
                break;
            }
            case 200: {
                this.userNotPresent();
                break;
            }
            case 201: {
                this.connectionSuccess((String)data.additionalData[0]);
                break;
            }
            case 202: {
                break;
            }
            case 203: {
                this.connectionError((String)data.additionalData[0], (Exception)data.additionalData[1]);
                break;
            }
            case 204: {
                this.userFound((String)data.additionalData[0]);
                break;
            }
            case 205: {
                this.userNotFound((String)data.additionalData[0]);
                break;
            }
            default: {
                log.debug("Unhandled info data of type: {}", (Object)data.infoType);
            }
        }
    }

    private void userNotPresent() {
        this.getBuilder().info();
        this.getBuilder().subTitle("net.savignano.snotify.pgp-ldap-verification.findUser.noUser.title", new Object[0]);
        this.getBuilder().message("net.savignano.snotify.pgp-ldap-verification.findUser.noUser.message", new Object[0]);
        this.build();
    }

    private void connectionSuccess(String location) {
        this.getBuilder().success();
        this.getBuilder().subTitle("net.savignano.snotify.pgp-ldap-verification.canConnect.success.title", new Object[0]);
        this.getBuilder().message("net.savignano.snotify.pgp-ldap-verification.canConnect.success.message", location);
        this.build();
    }

    private void connectionError(String location, Exception exception) {
        this.getBuilder().error();
        this.getBuilder().subTitle("net.savignano.snotify.pgp-ldap-verification.canConnect.exception.title", new Object[0]);
        this.getBuilder().message("net.savignano.snotify.pgp-ldap-verification.canConnect.exception.message", location, exception.getClass().getSimpleName(), exception.getLocalizedMessage());
        this.build();
    }

    private void userFound(String userName) {
        this.setReportKey(true);
        this.getBuilder().success();
        this.getBuilder().subTitle("net.savignano.snotify.pgp-ldap-verification.findUser.success.title", new Object[0]);
        this.getBuilder().message("net.savignano.snotify.pgp-ldap-verification.findUser.success.message", userName);
        this.build();
    }

    private void userNotFound(String userName) {
        this.setReportError(false);
        this.getBuilder().error();
        this.getBuilder().subTitle("net.savignano.snotify.pgp-ldap-verification.findUser.failure.title", new Object[0]);
        this.getBuilder().message("net.savignano.snotify.pgp-ldap-verification.findUser.failure.message", userName);
        this.build();
    }

    public PgpLdapLoader getLoader() {
        return this.loader;
    }
}

