/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.gui.keysource.verification.smime;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.LinkedHashSet;
import java.util.Set;
import net.savignano.snotify.atlassian.common.ISnotifyI18n;
import net.savignano.snotify.atlassian.common.security.key.publicly.SnotifySmimePublicKey;
import net.savignano.snotify.atlassian.common.util.SmimeUtil;
import net.savignano.snotify.atlassian.gui.keysource.verification.AKeySourceVerification;
import net.savignano.snotify.atlassian.gui.keysource.verification.EVerificationStatus;
import net.savignano.thirdparty.org.bouncycastle.cert.X509CertificateHolder;
import net.savignano.thirdparty.org.bouncycastle.cms.CMSSignedData;
import net.savignano.thirdparty.org.bouncycastle.util.Store;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmimeP7bVerification
extends AKeySourceVerification {
    private static final Logger log = LoggerFactory.getLogger(SmimeP7bVerification.class);
    private final String location;
    private final Set<String> emails = new LinkedHashSet<String>();

    public SmimeP7bVerification(String location, ISnotifyI18n i18n) {
        super(i18n);
        if (location == null) {
            throw new IllegalArgumentException("Location must not be null.");
        }
        this.location = location;
        this.getBuilder().title("net.savignano.snotify.smime-p7b-verification.title", new Object[0]);
    }

    @Override
    protected void doVerify() throws Exception {
        this.canReadLocation();
    }

    private void canReadLocation() {
        SecurityException e = null;
        boolean canRead = false;
        try {
            canRead = new File(this.location).canRead();
            log.debug("Can access key store at location {}: {}", (Object)this.location, (Object)canRead);
        }
        catch (SecurityException e1) {
            e = e1;
            log.debug("Can not access key store location: " + this.location, (Throwable)e);
        }
        if (canRead) {
            this.getBuilder().status(EVerificationStatus.SUCCESS);
            this.getBuilder().subTitle("net.savignano.snotify.smime-p7b-verification.canRead.success.title", new Object[0]);
            this.getBuilder().message("net.savignano.snotify.smime-p7b-verification.canRead.success.message", this.location);
            this.build();
            this.loadKeyStore();
        } else if (e != null) {
            this.getBuilder().status(EVerificationStatus.ERROR);
            this.getBuilder().subTitle("net.savignano.snotify.smime-p7b-verification.canRead.exception.title", new Object[0]);
            this.getBuilder().message("net.savignano.snotify.smime-p7b-verification.canRead.exception.message", this.location, e.getClass().getSimpleName(), e.getLocalizedMessage());
            this.build();
        } else {
            this.getBuilder().status(EVerificationStatus.ERROR);
            this.getBuilder().subTitle("net.savignano.snotify.smime-p7b-verification.canRead.failure.title", new Object[0]);
            this.getBuilder().message("net.savignano.snotify.smime-p7b-verification.canRead.failure.message", this.location);
            this.build();
        }
    }

    private void loadKeyStore() {
        Exception e = null;
        KeyStore ks = null;
        try {
            CMSSignedData signature;
            try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(this.location));){
                signature = new CMSSignedData(is);
            }
            Store<X509CertificateHolder> certStore = signature.getCertificates();
            log.debug("Loaded key store from location: {}", (Object)this.location);
            ks = SmimeUtil.convertToKeyStore(certStore, "BKS", null);
        }
        catch (Exception e1) {
            e = e1;
            log.debug("Could not load key store from location: " + this.location, (Throwable)e);
        }
        if (e == null) {
            this.getBuilder().status(EVerificationStatus.SUCCESS);
            this.getBuilder().subTitle("net.savignano.snotify.smime-p7b-verification.loadKeyStore.success.title", new Object[0]);
            this.getBuilder().message("net.savignano.snotify.smime-p7b-verification.loadKeyStore.success.message", new Object[0]);
            this.build();
            this.checkEmails(ks);
        } else {
            this.getBuilder().status(EVerificationStatus.ERROR);
            this.getBuilder().subTitle("net.savignano.snotify.smime-p7b-verification.loadKeyStore.exception.title", new Object[0]);
            this.getBuilder().message("net.savignano.snotify.smime-p7b-verification.loadKeyStore.exception.message", e.getClass().getSimpleName(), e.getLocalizedMessage());
            this.build();
        }
    }

    private void checkEmails(KeyStore keyStore) {
        if (keyStore == null) {
            return;
        }
        if (this.getEmails().isEmpty()) {
            log.debug("No email address was given, so can't check if a certificate was found for it.");
            this.getBuilder().status(EVerificationStatus.INFO);
            this.getBuilder().subTitle("net.savignano.snotify.smime-p7b-verification.checkEmail.noEmail.title", new Object[0]);
            this.getBuilder().message("net.savignano.snotify.smime-p7b-verification.checkEmail.noEmail.message", new Object[0]);
            this.build();
            return;
        }
        for (String email : this.getEmails()) {
            X509Certificate cert;
            try {
                cert = SmimeUtil.getCertForEmail(keyStore, email);
            }
            catch (Exception e) {
                log.debug("Could not look up email <" + email + "> in keystore \"" + keyStore + "\".", (Throwable)e);
                this.getBuilder().status(EVerificationStatus.ERROR);
                this.getBuilder().subTitle("net.savignano.snotify.smime-p7b-verification.checkEmail.exception.title", new Object[0]);
                this.getBuilder().message("net.savignano.snotify.smime-p7b-verification.checkEmail.exception.message", email, e.getClass().getSimpleName(), e.getLocalizedMessage());
                this.build();
                return;
            }
            if (cert != null) {
                log.debug("Certificate for email <{}> was found in key store.", (Object)email);
                this.getBuilder().status(EVerificationStatus.SUCCESS);
                this.getBuilder().subTitle("net.savignano.snotify.smime-p7b-verification.checkEmail.success.title", new Object[0]);
                this.getBuilder().message("net.savignano.snotify.smime-p7b-verification.checkEmail.success.message", email);
                this.build();
                this.verifyKey(new SnotifySmimePublicKey(cert, email));
                continue;
            }
            log.debug("No certificate for email <{}> was found in key store.", (Object)email);
            this.getBuilder().status(EVerificationStatus.WARNING);
            this.getBuilder().subTitle("net.savignano.snotify.smime-p7b-verification.checkEmail.failure.title", new Object[0]);
            this.getBuilder().message("net.savignano.snotify.smime-p7b-verification.checkEmail.failure.message", email);
            this.build();
        }
    }

    public Set<String> getEmails() {
        return this.emails;
    }
}

