/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.gui.templates.handler.impl;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import net.savignano.snotify.atlassian.gui.templates.handler.IValueHandler;
import net.savignano.snotify.atlassian.gui.templates.handler.IValueHandlerProvider;

public class ValueHandlerWrapper
implements IValueHandlerProvider {
    private final Map<String, IValueHandler<?>> handlers = new HashMap();

    public void add(IValueHandler<?> handler) {
        if (handler != null) {
            this.handlers.put(handler.getId(), handler);
        }
    }

    public void remove(IValueHandler<?> handler) {
        if (handler != null) {
            this.remove(handler.getId());
        }
    }

    public void remove(String id) {
        if (id != null) {
            this.handlers.remove(id);
        }
    }

    public void read() {
        for (IValueHandler<?> handler : this.handlers.values()) {
            handler.read();
        }
    }

    public void store() {
        for (IValueHandler<?> handler : this.handlers.values()) {
            handler.store();
        }
    }

    public void receive(HttpServletRequest request) {
        for (IValueHandler<?> handler : this.handlers.values()) {
            handler.receive(request);
        }
    }

    @Override
    public IValueHandler<?> getValueHandler(String id) {
        return this.handlers.get(id);
    }

    public <T> T getValue(String id) {
        IValueHandler<?> handler = this.getValueHandler(id);
        return handler != null ? (T)handler.getValue() : null;
    }
}

