/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.confluence.gui.action;

import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.user.EntityException;
import com.atlassian.user.GroupManager;
import com.atlassian.user.search.page.Pager;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import net.savignano.snotify.atlassian.common.EProperty;
import net.savignano.snotify.atlassian.common.enums.EEncryptionFailureBehavior;
import net.savignano.snotify.atlassian.common.enums.EEncryptionTypePriority;
import net.savignano.snotify.confluence.gui.action.SnotifyAdminSettingsAction;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnotifyGlobalSettingsAction
extends SnotifyAdminSettingsAction {
    private static final long serialVersionUID = 7292660268857614798L;
    private static final String ENCRYPTION_FAILURE_PARAM = "encryptionFailure";
    private static final String ENCRYPTION_TYPE_PRIORITY_PARAM = "encryptionTypePriority";
    private static final String PROJECT_SPECIFIC_ENCRYPTION_PARAM = "projectSpecificEncryption";
    private static final String DEFAULT_PROJECT_ENCRYPTION_PARAM = "defaultProjectEncryption";
    private static final String AMBIGUOUS_PROJECT_ENCRYPTION_PARAM = "ambiguousProjectEncryption";
    private static final String NO_PROJECT_ENCRYPTION_PARAM = "noProjectEncryption";
    private static final String WHITELIST_USER_GROUP_PARAM = "whitelistUserGroup";
    private static final String SIGNING_ENABLED_PARAM = "signingEnabled";
    private static final String SUBJECT_REPLACEMENT_PARAM = "subjectReplacement";
    private static final String SUBJECT_REPLACEMENT_KEEP_ID_PARAM = "subjectReplacementKeepId";
    private static final Logger log = LoggerFactory.getLogger(SnotifyGlobalSettingsAction.class);
    private String whitelistUserGroup;

    public String doInput() {
        if (!this.hasAdminRights()) {
            ConfluenceUser user = this.getAuthenticatedUser();
            log.warn("Unauthorized access to view global S/Notify values from user: {}", (Object)(user != null ? user.getFullName() : "<Unknown User>"));
            return "error";
        }
        this.whitelistUserGroup = this.getAppProps().getString(EProperty.WHITELIST_USER_GROUP);
        return "input";
    }

    public String doSubmit() {
        HttpServletRequest request = this.getCurrentRequest();
        if (!"POST".equals(request.getMethod())) {
            log.debug("Access to submit method redirected to input method, as request method wasn't 'POST'. Used method: " + request.getMethod());
            return this.doInput();
        }
        if (!this.hasAdminRights()) {
            ConfluenceUser user = this.getAuthenticatedUser();
            log.warn("Unauthorized access to submit global S/Notify values from user: {}", (Object)(user != null ? user.getFullName() : "<Unknown User>"));
            return "error";
        }
        String encryptionFailure = request.getParameter(ENCRYPTION_FAILURE_PARAM);
        this.getAppProps().setEnum(EProperty.ENCRYPTION_FAILURE_BEHAVIOR, EEncryptionFailureBehavior.valueOf(encryptionFailure));
        String encryptionTypePriority = request.getParameter(ENCRYPTION_TYPE_PRIORITY_PARAM);
        this.getAppProps().setEnum(EProperty.ENCRYPTION_TYPE_PRIORITY, EEncryptionTypePriority.valueOf(encryptionTypePriority));
        String projectSpecificEncryption = request.getParameter(PROJECT_SPECIFIC_ENCRYPTION_PARAM);
        this.getAppProps().setBoolean(EProperty.ENABLE_PROJECT_SPECIFIC_ENCRYPTION, Boolean.parseBoolean(projectSpecificEncryption));
        String defaultProjectEncryption = request.getParameter(DEFAULT_PROJECT_ENCRYPTION_PARAM);
        this.getAppProps().setBoolean(EProperty.DEFAULT_PROJECT_ENCRYPTION_STATE, Boolean.parseBoolean(defaultProjectEncryption));
        String ambiguousProjectEncryption = request.getParameter(AMBIGUOUS_PROJECT_ENCRYPTION_PARAM);
        this.getAppProps().setBoolean(EProperty.AMBIGUOUS_PROJECT_ENCRYPTION_STATE, Boolean.parseBoolean(ambiguousProjectEncryption));
        String noProjectEncryption = request.getParameter(NO_PROJECT_ENCRYPTION_PARAM);
        this.getAppProps().setBoolean(EProperty.NO_PROJECT_ENCRYPTION_STATE, Boolean.parseBoolean(noProjectEncryption));
        String signingEnabled = request.getParameter(SIGNING_ENABLED_PARAM);
        this.getAppProps().setBoolean(EProperty.SIGNING_ENABLED, Boolean.parseBoolean(signingEnabled));
        String subjectProtection = request.getParameter(SUBJECT_REPLACEMENT_PARAM);
        this.getAppProps().setBoolean(EProperty.SUBJECT_PROTECTION, Boolean.parseBoolean(subjectProtection));
        String subjectProtectionKeepId = request.getParameter(SUBJECT_REPLACEMENT_KEEP_ID_PARAM);
        this.getAppProps().setBoolean(EProperty.SUBJECT_PROTECTION_KEEP_ID, Boolean.parseBoolean(subjectProtectionKeepId));
        this.whitelistUserGroup = request.getParameter(WHITELIST_USER_GROUP_PARAM);
        this.getAppProps().setString(EProperty.WHITELIST_USER_GROUP, StringUtils.isEmpty((String)this.whitelistUserGroup) ? null : this.whitelistUserGroup);
        this.setShowUpdated(true);
        return "success";
    }

    public boolean isProjectSpecificEncryption() {
        return this.getAppProps().getBoolean(EProperty.ENABLE_PROJECT_SPECIFIC_ENCRYPTION);
    }

    public boolean isDefaultProjectEncryption() {
        return this.getAppProps().getBoolean(EProperty.DEFAULT_PROJECT_ENCRYPTION_STATE);
    }

    public boolean isAmbiguousProjectEncryption() {
        return this.getAppProps().getBoolean(EProperty.AMBIGUOUS_PROJECT_ENCRYPTION_STATE);
    }

    public boolean isNoProjectEncryption() {
        return this.getAppProps().getBoolean(EProperty.NO_PROJECT_ENCRYPTION_STATE);
    }

    public boolean isSigningEnabled() {
        return this.getAppProps().getBoolean(EProperty.SIGNING_ENABLED);
    }

    public boolean isReplaceSubject() {
        return this.getAppProps().getBoolean(EProperty.SUBJECT_PROTECTION);
    }

    public boolean isReplaceSubjectKeepId() {
        return this.getAppProps().getBoolean(EProperty.SUBJECT_PROTECTION_KEEP_ID);
    }

    public boolean isPriority(String id) {
        EEncryptionTypePriority prop = this.getAppProps().getEnum(EProperty.ENCRYPTION_TYPE_PRIORITY, EEncryptionTypePriority.class);
        return prop.name().equalsIgnoreCase(id);
    }

    public boolean isFailure(String id) {
        EEncryptionFailureBehavior prop = this.getAppProps().getEnum(EProperty.ENCRYPTION_FAILURE_BEHAVIOR, EEncryptionFailureBehavior.class);
        return prop.name().equalsIgnoreCase(id);
    }

    public List<String> getUserGroups() {
        ArrayList<String> userGroups = new ArrayList<String>();
        try {
            Pager groups = ((GroupManager)ComponentLocator.getComponent(GroupManager.class)).getGroups();
            groups.forEach(g -> userGroups.add(g.getName()));
        }
        catch (EntityException e) {
            log.error("Could not create list of all groups. Error message: " + e.getMessage(), (Throwable)e);
        }
        return userGroups;
    }

    public boolean isGroupSelected(String group) {
        return ObjectUtils.equals((Object)StringUtils.trimToNull((String)group), (Object)this.whitelistUserGroup);
    }
}

