/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.common.security.access.pgp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import net.savignano.snotify.atlassian.common.EProperty;
import net.savignano.snotify.atlassian.common.ISnotifyUserProperties;
import net.savignano.snotify.atlassian.common.IUser;
import net.savignano.snotify.atlassian.common.enums.ECryptographyType;
import net.savignano.snotify.atlassian.common.enums.EKeySource;
import net.savignano.snotify.atlassian.common.enums.EKeyValidity;
import net.savignano.snotify.atlassian.common.security.access.AUserKeyLoader;
import net.savignano.snotify.atlassian.common.security.key.publicly.SnotifyPgpPublicKey;
import net.savignano.snotify.atlassian.common.util.PgpUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PgpUserKeyLoader
extends AUserKeyLoader<SnotifyPgpPublicKey> {
    private static final Logger log = LoggerFactory.getLogger(PgpUserKeyLoader.class);

    public PgpUserKeyLoader(IUser<?> user, ISnotifyUserProperties userProps) {
        super(user, userProps);
    }

    @Override
    protected SnotifyPgpPublicKey loadInternalKey() throws Exception {
        IUser<?> user = this.getUser();
        ISnotifyUserProperties userProps = this.getUserProperties();
        Long keyId = userProps.getLong(EProperty.EMAIL_PGP_KEY_ID, user);
        byte[] keyBytes = userProps.getBytes(EProperty.EMAIL_PGP_KEY, user);
        if (keyId != null && keyBytes != null) {
            log.debug("Loading cached public key of user {} from user properties.", user);
            try {
                SnotifyPgpPublicKey key = new SnotifyPgpPublicKey(PgpUtil.loadPublicKey(new ByteArrayInputStream(keyBytes)), user.getEmail());
                key.setKeySource(this.getUserKeySource());
                return key;
            }
            catch (IOException e) {
                log.error("Could not load cached public key of user " + user + " because an exception occured. Error message: " + e.getMessage(), (Throwable)e);
                return this.getValidityKey(EKeyValidity.ERROR);
            }
        }
        log.debug("User {} has no cached public key stored.", user);
        return this.getValidityKey(EKeyValidity.NOT_FOUND);
    }

    private EKeySource getUserKeySource() {
        return this.getUserProperties().getEnum(EProperty.EMAIL_PGP_KEY_SOURCE, EKeySource.class, this.getUser());
    }

    @Override
    public ECryptographyType getCryptography() {
        return ECryptographyType.PGP;
    }

    @Override
    protected SnotifyPgpPublicKey getValidityKey(EKeyValidity validity) {
        return new SnotifyPgpPublicKey(validity, this.getKeySource());
    }

    public String toString() {
        return "PgpCachedKeyLoader [user=" + this.getUser() + "]";
    }
}

