/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.common.security.key.secret;

import java.security.KeyStore;
import java.util.Arrays;
import net.savignano.snotify.atlassian.common.enums.ECryptographyType;
import net.savignano.snotify.atlassian.common.enums.EKeyPurpose;
import net.savignano.snotify.atlassian.common.enums.EKeySource;
import net.savignano.snotify.atlassian.common.enums.EKeyValidity;
import net.savignano.snotify.atlassian.common.security.key.ASnotifyKey;
import net.savignano.snotify.atlassian.common.security.key.secret.ISnotifySecretKey;
import net.savignano.snotify.atlassian.common.util.SecurityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnotifySmimeDecryptionKey
extends ASnotifyKey<KeyStore>
implements ISnotifySecretKey<KeyStore> {
    private static final Logger log = LoggerFactory.getLogger(SnotifySmimeDecryptionKey.class);
    private KeyStore secret;
    private char[] password;

    public SnotifySmimeDecryptionKey(KeyStore secret, char[] password) {
        super(EKeyPurpose.DECRYPTION, ECryptographyType.SMIME);
        this.secret = secret;
        if (password != null) {
            this.password = Arrays.copyOf(password, password.length);
        } else {
            log.warn("Password was <null>. If secret key does indeed have no password, this is a security problem, as anyone can use it.");
        }
        if (secret == null) {
            log.warn("Secret key was <null>.");
            this.setKeyValidity(EKeyValidity.INVALID);
        }
    }

    public SnotifySmimeDecryptionKey(EKeyValidity validity) {
        this(validity, EKeySource.UNKNOWN);
    }

    public SnotifySmimeDecryptionKey(EKeyValidity validity, EKeySource keySource) {
        super(EKeyPurpose.DECRYPTION, ECryptographyType.SMIME);
        this.setKeyValidity(validity);
        this.setKeySource(keySource);
    }

    @Override
    public KeyStore getKey() {
        return this.secret;
    }

    public char[] getPassword() {
        return this.password;
    }

    @Override
    public void destroy() {
        this.setKeyValidity(EKeyValidity.INVALID);
        this.secret = null;
        SecurityUtil.clearPassword(this.password);
        this.password = null;
    }

    @Override
    public boolean isDestroyed() {
        return this.secret == null && this.password == null && this.getKeyValidity() == EKeyValidity.INVALID;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(200);
        builder.append("S/MIME Decryption Key. ");
        builder.append("Key Validity: ");
        builder.append((Object)this.getKeyValidity());
        builder.append("; Key Purpose: ");
        builder.append((Object)this.getKeyPurpose());
        builder.append("; Key Source: ");
        builder.append((Object)this.getKeySource());
        builder.append("; Password: ");
        builder.append(this.getPassword() == null ? "<null>" : "*****");
        return builder.toString();
    }
}

