/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.gui.keysource.verification.pgp;

import java.net.URI;
import java.util.function.Consumer;
import net.savignano.snotify.atlassian.common.ISnotifyI18n;
import net.savignano.snotify.atlassian.common.connector.LdapConnector;
import net.savignano.snotify.atlassian.common.info.InfoData;
import net.savignano.snotify.atlassian.common.security.access.pgp.PgpGlobalDirectoryLoader;
import net.savignano.snotify.atlassian.common.security.key.ISnotifyKey;
import net.savignano.snotify.atlassian.gui.keysource.verification.AKeySourceVerification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PgpGlobalDirectoryVerification
extends AKeySourceVerification {
    private static final Logger log = LoggerFactory.getLogger(PgpGlobalDirectoryVerification.class);
    private final PgpGlobalDirectoryLoader loader;

    public PgpGlobalDirectoryVerification(PgpGlobalDirectoryLoader loader, ISnotifyI18n i18n) {
        super(i18n);
        this.loader = loader;
        if (loader == null) {
            throw new IllegalArgumentException("Loader must not be null.");
        }
        this.getBuilder().title("net.savignano.snotify.pgp-global-directory-verification.title", new Object[0]);
        this.setReportKey(false);
    }

    @Override
    protected void doVerify() throws Exception {
        if (!this.validateLdapUrl()) {
            return;
        }
        Consumer<InfoData> consumer = this::handleInfoData;
        this.loader.getInfoDataManager().register(consumer);
        this.loader.loadKey();
        this.loader.getInfoDataManager().unregister(consumer);
    }

    private void handleInfoData(InfoData data) {
        switch (data.infoType) {
            case 102: {
                this.handleError((Exception)data.additionalData[0]);
                break;
            }
            case 100: {
                this.verifyKey((ISnotifyKey)data.additionalData[0]);
                break;
            }
            case 200: {
                this.emailNotPresent();
                break;
            }
            case 201: {
                this.connectionSuccess((String)data.additionalData[0]);
                break;
            }
            case 202: {
                break;
            }
            case 203: {
                this.connectionError((String)data.additionalData[0], (Exception)data.additionalData[1]);
                break;
            }
            case 204: {
                this.emailFound(this.loader.getEmail());
                break;
            }
            case 205: {
                this.emailNotFound(this.loader.getEmail());
                break;
            }
            case 301: {
                this.serverInfo((String)data.additionalData[0]);
                break;
            }
            case 302: {
                this.serverInfoNotAvailable();
                break;
            }
            default: {
                log.debug("Unhandled info data of type: {}", (Object)data.infoType);
            }
        }
    }

    private void emailNotPresent() {
        this.getBuilder().warning();
        this.getBuilder().subTitle("net.savignano.snotify.pgp-global-directory-verification.emailPresent.failure.title", new Object[0]);
        this.getBuilder().message("net.savignano.snotify.pgp-global-directory-verification.emailPresent.failure.message", new Object[0]);
        this.build();
    }

    private void connectionSuccess(String location) {
        this.getBuilder().success();
        this.getBuilder().subTitle("net.savignano.snotify.pgp-global-directory-verification.connect.success.title", new Object[0]);
        this.getBuilder().message("net.savignano.snotify.pgp-global-directory-verification.connect.success.message", location);
        this.build();
    }

    private void connectionError(String location, Exception e) {
        this.getBuilder().error();
        this.getBuilder().subTitle("net.savignano.snotify.pgp-global-directory-verification.connect.exception.title", new Object[0]);
        this.getBuilder().message("net.savignano.snotify.pgp-global-directory-verification.connect.exception.message", location, e.getClass().getSimpleName(), e.getLocalizedMessage());
        this.build();
    }

    private void emailFound(String email) {
        this.setReportKey(true);
        this.getBuilder().success();
        this.getBuilder().subTitle("net.savignano.snotify.pgp-global-directory-verification.checkEmail.success.title", new Object[0]);
        this.getBuilder().message("net.savignano.snotify.pgp-global-directory-verification.checkEmail.success.message", email);
        this.build();
    }

    private void emailNotFound(String email) {
        this.getBuilder().warning();
        this.getBuilder().subTitle("net.savignano.snotify.pgp-global-directory-verification.checkEmail.failure.title", new Object[0]);
        this.getBuilder().message("net.savignano.snotify.pgp-global-directory-verification.checkEmail.failure.message", email);
        this.build();
    }

    private void serverInfo(String server) {
        this.getBuilder().success();
        this.getBuilder().subTitle("net.savignano.snotify.pgp-global-directory-verification.keyServerInfo.success.title", new Object[0]);
        this.getBuilder().message("net.savignano.snotify.pgp-global-directory-verification.keyServerInfo.success.message", server);
        this.build();
    }

    private void serverInfoNotAvailable() {
        this.setReportError(false);
        this.getBuilder().error();
        this.getBuilder().subTitle("net.savignano.snotify.pgp-global-directory-verification.keyServerInfo.failure.title", new Object[0]);
        this.getBuilder().message("net.savignano.snotify.pgp-global-directory-verification.keyServerInfo.failure.message", new Object[0]);
        this.build();
    }

    private boolean validateLdapUrl() {
        LdapConnector connector = this.loader.getConnector();
        log.debug("Verifying PGP LDAP location: {}", (Object)connector.getHost());
        boolean success = false;
        try {
            URI uri = connector.getUri();
            this.getBuilder().success();
            this.getBuilder().subTitle("net.savignano.snotify.pgp-global-directory-verification.validUrl.success.title", new Object[0]);
            this.getBuilder().message("net.savignano.snotify.pgp-global-directory-verification.validUrl.success.message", uri.toString());
            this.build();
            success = true;
        }
        catch (Exception e) {
            log.debug("Key server location is not a valid URL: " + connector.getHost(), (Throwable)e);
            this.getBuilder().error();
            this.getBuilder().subTitle("net.savignano.snotify.pgp-global-directory-verification.validUrl.exception.title", new Object[0]);
            this.getBuilder().message("net.savignano.snotify.pgp-global-directory-verification.validUrl.exception.message", connector.getHost(), e.getClass().getSimpleName(), e.getLocalizedMessage());
            this.build();
        }
        return success;
    }
}

