/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.common.update;

import java.util.Map;
import java.util.TreeMap;
import net.savignano.snotify.atlassian.common.EProperty;
import net.savignano.snotify.atlassian.common.ISnotifyAppProperties;
import net.savignano.snotify.atlassian.common.update.SnotifyUpdateManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ASnotifyAtlassianUpdateManager
extends SnotifyUpdateManager {
    private static final Logger log = LoggerFactory.getLogger(ASnotifyAtlassianUpdateManager.class);

    @Override
    protected void initialize() {
        super.initialize();
        this.getAppProps();
        this.add("3.1.0", this::updatePublicSmimeKeystoreType);
        this.add("3.1.0", this::addNoProjectEncryptionState);
        this.add("3.4.2", this::updateTweakOverview);
    }

    private void updatePublicSmimeKeystoreType() {
        log.debug("Evaluating update of public S/MIME key store.");
        if (this.getAppProps().hasKey(EProperty.PUBLIC_KEYSTORE_SMIME_LOCATION)) {
            log.info("Added information about public S/MIME key store. Type: Bouncy Castle Key Store");
            this.getAppProps().setString(EProperty.PUBLIC_KEYSTORE_SMIME_TYPE, "BKS");
        } else {
            log.debug("No public S/MIME key store configured.");
        }
    }

    private void addNoProjectEncryptionState() {
        log.debug("Evaluating adding of 'no project encryption state'.");
        if (this.getAppProps().hasKey(EProperty.AMBIGUOUS_PROJECT_ENCRYPTION_STATE)) {
            boolean ambiguous = this.getAppProps().getBoolean(EProperty.AMBIGUOUS_PROJECT_ENCRYPTION_STATE);
            log.info("Added 'no project encryption state'. New value: {}", (Object)ambiguous);
            this.getAppProps().setBoolean(EProperty.NO_PROJECT_ENCRYPTION_STATE, ambiguous);
        } else {
            log.debug("'No project encryption state' not added.");
        }
    }

    private void updateTweakOverview() {
        log.debug("Evaluating update of tweak display.");
        if (this.getAppProps().hasKey(EProperty.TWEAK_OVERVIEW)) {
            log.info("Updated tweak overview property.");
            String overview = this.createUsedTweaks(this.getUsedTweaks());
            log.debug("New Overview Tweak: {}", (Object)overview);
            this.getAppProps().setUnlimitedString(EProperty.TWEAK_OVERVIEW, overview);
        } else {
            log.debug("Overview tweak not present.");
        }
    }

    private Map<String, String> getUsedTweaks() {
        TreeMap<String, String> tweaks = new TreeMap<String, String>();
        String tweakString = this.getAppProps().getUnlimitedString(EProperty.TWEAK_OVERVIEW);
        log.debug("Old Overview Tweak: {}", (Object)tweakString);
        if (tweakString != null) {
            for (String oneTweak : tweakString.split("\\;")) {
                String[] keyValue = oneTweak.split("\\=");
                if (keyValue.length == 2) {
                    tweaks.put(keyValue[0], keyValue[1]);
                    continue;
                }
                log.warn("Unknown key/value format ({}) detected in tweaks: {}", (Object)keyValue, (Object)tweakString);
            }
        }
        return tweaks;
    }

    private String createUsedTweaks(Map<String, String> tweaks) {
        if (tweaks.isEmpty()) {
            return null;
        }
        StringBuilder builder = new StringBuilder(100);
        for (String key : tweaks.keySet()) {
            builder.append(key);
            builder.append(';');
        }
        builder.deleteCharAt(builder.length() - 1);
        return builder.toString();
    }

    public abstract ISnotifyAppProperties getAppProps();
}

