/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.common.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Random;
import java.util.jar.Manifest;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import net.savignano.snotify.atlassian.common.Constants;
import net.savignano.snotify.atlassian.common.security.SnotifyJce;
import net.savignano.thirdparty.org.bouncycastle.crypto.BufferedBlockCipher;
import net.savignano.thirdparty.org.bouncycastle.crypto.engines.AESEngine;
import net.savignano.thirdparty.org.bouncycastle.crypto.modes.CBCBlockCipher;
import net.savignano.thirdparty.org.bouncycastle.crypto.paddings.PKCS7Padding;
import net.savignano.thirdparty.org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.KeyParameter;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.ParametersWithIV;
import net.savignano.thirdparty.org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityUtil {
    private static final Logger log = LoggerFactory.getLogger(SecurityUtil.class);
    private static final String OBFUSCATION_STRING = "Obfuscate This!!";
    private static final int AES_NIVBITS = 128;
    private static Boolean integrityIntact;
    private static KeyStore trustStore;
    private static Manifest manifest;

    public static final boolean checkSnotifyIntegrity() {
        if (integrityIntact == null) {
            log.info("Checking integrity of S/Notify.");
            integrityIntact = SnotifyJce.selfIntegrityChecking();
            if (integrityIntact.booleanValue()) {
                log.info("Integrity of S/Notify is intact.");
            } else {
                log.error("Integrity of S/Notify has been compromised. Jar files have been modified.");
            }
        }
        return integrityIntact;
    }

    public static final Provider getProvider() {
        Provider provider = Security.getProvider("SAVIGNANO-BC");
        if (provider == null) {
            log.debug("Initializing Bouncy Castle Provider.");
            provider = new BouncyCastleProvider();
            Security.addProvider(provider);
        }
        log.trace("Bouncy Castle Provider: " + provider);
        return provider;
    }

    public static final String getManifestValue(String key) {
        if (manifest == null && SecurityUtil.getManifest() == null) {
            return null;
        }
        return manifest.getMainAttributes().getValue(key);
    }

    public static final Manifest getManifest() {
        if (manifest != null) {
            return manifest;
        }
        String className = SecurityUtil.class.getSimpleName() + ".class";
        String resourcePath = SecurityUtil.class.getResource(className).toString();
        log.debug("Resource for {}: {}", SecurityUtil.class, (Object)resourcePath);
        String manifestPath = null;
        if (resourcePath.startsWith("jar")) {
            manifestPath = resourcePath.substring(0, resourcePath.lastIndexOf("!") + 1) + "/META-INF/MANIFEST.MF";
        } else if (resourcePath.startsWith("bundle")) {
            manifestPath = resourcePath.substring(0, resourcePath.lastIndexOf("net")) + "META-INF/MANIFEST.MF";
        }
        log.debug("Loading MANIFEST.MF from: {}", manifestPath);
        if (manifestPath != null) {
            try (InputStream is = new URL(manifestPath).openStream();){
                manifest = new Manifest(is);
            }
            catch (IOException e) {
                log.error("Could not load S/Notify MANIFEST.MF from \"" + manifestPath + "\". Error message: " + e.getMessage(), (Throwable)e);
            }
        }
        return manifest;
    }

    public static final KeyStore getJavaTrustStore() throws KeyStoreException, IOException, CertificateException, NoSuchAlgorithmException {
        TrustManager[] trustManagers;
        if (trustStore != null) {
            return trustStore;
        }
        log.debug("Initializing trust store.");
        TrustManagerFactory trustFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustFactory.init(trustStore);
        for (TrustManager trustManager : trustManagers = trustFactory.getTrustManagers()) {
            if (trustManager instanceof X509TrustManager) {
                log.debug("X509TrustManager found.");
                X509Certificate[] issuers = ((X509TrustManager)trustManager).getAcceptedIssuers();
                log.debug("Found {} certificates in trust store.", (Object)issuers.length);
                trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
                trustStore.load(null, null);
                for (X509Certificate cert : issuers) {
                    String certName = cert.getSubjectX500Principal().toString();
                    log.trace("Trusting: {}", (Object)certName);
                    trustStore.setCertificateEntry(certName, cert);
                }
                continue;
            }
            log.trace("TrustManager: {}", trustManager.getClass());
        }
        if (trustStore == null) {
            log.warn("TrustManagerFactory did not provide a trust store with X509Certificates. No trust store available.");
        } else {
            log.info("Trust store initialized with {} certificates.", (Object)trustStore.size());
        }
        return trustStore;
    }

    public static final void clearPassword(char[] password) {
        if (password != null) {
            Arrays.fill(password, '\u0000');
        }
    }

    public static final String encode(String string) throws GeneralSecurityException {
        if (string == null) {
            return null;
        }
        return SecurityUtil.encode(string.toCharArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String encode(char[] chars) throws GeneralSecurityException {
        byte[] encBytes;
        if (chars == null) {
            return null;
        }
        CharBuffer charBuffer = CharBuffer.wrap(chars);
        ByteBuffer byteBuffer = Constants.UTF8_CHARSET.encode(charBuffer);
        byte[] bytes = Arrays.copyOfRange(byteBuffer.array(), byteBuffer.position(), byteBuffer.limit());
        try {
            encBytes = SecurityUtil.encode(bytes);
        }
        finally {
            Arrays.fill(byteBuffer.array(), (byte)0);
            Arrays.fill(bytes, (byte)0);
        }
        return new String(Base64.encodeBase64((byte[])encBytes), Constants.UTF8_CHARSET);
    }

    private static final byte[] encode(byte[] bytes) throws GeneralSecurityException {
        byte[] bytesAll;
        try {
            byte[] ivData = new byte[16];
            Random r = new Random();
            r.nextBytes(ivData);
            PKCS7Padding padding = new PKCS7Padding();
            PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher(new CBCBlockCipher(new AESEngine()), padding);
            KeyParameter keyParam = SecurityUtil.getAesKey();
            ParametersWithIV params = new ParametersWithIV(keyParam, ivData);
            cipher.reset();
            ((BufferedBlockCipher)cipher).init(true, params);
            int buflen = ((BufferedBlockCipher)cipher).getOutputSize(bytes.length);
            byte[] bytesEnc = new byte[buflen];
            int nBytesEnc = ((BufferedBlockCipher)cipher).processBytes(bytes, 0, bytes.length, bytesEnc, 0);
            nBytesEnc += ((BufferedBlockCipher)cipher).doFinal(bytesEnc, nBytesEnc);
            if (nBytesEnc != bytesEnc.length) {
                throw new IllegalStateException("Unexpected behaviour : getOutputSize value incorrect.");
            }
            bytesAll = new byte[ivData.length + bytesEnc.length];
            System.arraycopy(ivData, 0, bytesAll, 0, ivData.length);
            System.arraycopy(bytesEnc, 0, bytesAll, ivData.length, bytesEnc.length);
        }
        catch (Exception e) {
            throw new GeneralSecurityException("Encryption failed.", e);
        }
        return bytesAll;
    }

    public static final String decodeStringBase64Aes(String string) throws GeneralSecurityException {
        if (string == null) {
            return null;
        }
        byte[] bytesDec = SecurityUtil.decodeBase64Aes(string);
        return new String(bytesDec, Constants.UTF8_CHARSET);
    }

    public static final char[] decodeCharsBase64Aes(String string) throws GeneralSecurityException {
        if (string == null) {
            return null;
        }
        byte[] bytesDec = SecurityUtil.decodeBase64Aes(string);
        ByteBuffer bb = ByteBuffer.wrap(bytesDec);
        CharBuffer cb = Constants.UTF8_CHARSET.decode(bb);
        char[] chars = Arrays.copyOfRange(cb.array(), cb.position(), cb.limit());
        Arrays.fill(bytesDec, (byte)0);
        Arrays.fill(bb.array(), (byte)0);
        Arrays.fill(cb.array(), '\u0000');
        return chars;
    }

    private static byte[] decodeBase64Aes(String string) throws GeneralSecurityException {
        byte[] bytesDec;
        try {
            byte[] bytesEnc = Base64.decodeBase64((byte[])string.getBytes(Constants.UTF8_CHARSET));
            int nIvBytes = 16;
            byte[] ivBytes = new byte[16];
            System.arraycopy(bytesEnc, 0, ivBytes, 0, 16);
            KeyParameter keyParam = SecurityUtil.getAesKey();
            ParametersWithIV params = new ParametersWithIV(keyParam, ivBytes);
            PKCS7Padding padding = new PKCS7Padding();
            PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher(new CBCBlockCipher(new AESEngine()), padding);
            cipher.reset();
            ((BufferedBlockCipher)cipher).init(false, params);
            int buflen = ((BufferedBlockCipher)cipher).getOutputSize(bytesEnc.length - 16);
            byte[] workingBuffer = new byte[buflen];
            int len = ((BufferedBlockCipher)cipher).processBytes(bytesEnc, 16, bytesEnc.length - 16, workingBuffer, 0);
            len += ((BufferedBlockCipher)cipher).doFinal(workingBuffer, len);
            bytesDec = new byte[len];
            System.arraycopy(workingBuffer, 0, bytesDec, 0, len);
        }
        catch (Exception e) {
            throw new GeneralSecurityException("Decoding failed. Error message: " + e.getMessage(), e);
        }
        return bytesDec;
    }

    private static final KeyParameter getAesKey() {
        byte[] rawKeyData = OBFUSCATION_STRING.getBytes(Constants.UTF8_CHARSET);
        return new KeyParameter(rawKeyData);
    }
}

