/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.gui.keysource.verification.pgp;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import net.savignano.snotify.atlassian.common.ISnotifyI18n;
import net.savignano.snotify.atlassian.common.security.key.publicly.SnotifyPgpPublicKey;
import net.savignano.snotify.atlassian.common.util.PgpUtil;
import net.savignano.snotify.atlassian.gui.keysource.verification.AKeySourceVerification;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKeyRing;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PgpPublicKeyStoreVerification
extends AKeySourceVerification {
    private static final Logger log = LoggerFactory.getLogger(PgpPublicKeyStoreVerification.class);
    private final String location;
    private String email;

    public PgpPublicKeyStoreVerification(String location, ISnotifyI18n i18n) {
        super(i18n);
        if (location == null) {
            throw new IllegalArgumentException("Location must not be null.");
        }
        this.location = location;
        this.getBuilder().title("net.savignano.snotify.pgp-public-keystore-verification.title", new Object[0]);
    }

    @Override
    protected void doVerify() throws Exception {
        this.canReadLocation();
    }

    private void canReadLocation() {
        Exception e = null;
        boolean canRead = false;
        try {
            canRead = new File(this.location).canRead();
            log.debug("Can access key store at location {}: {}", (Object)this.location, (Object)canRead);
        }
        catch (Exception e1) {
            e = e1;
            log.debug("Can not access key store location: " + this.location, (Throwable)e);
        }
        if (canRead) {
            this.getBuilder().success();
            this.getBuilder().subTitle("net.savignano.snotify.pgp-keystore-verification.canRead.success.title", new Object[0]);
            this.getBuilder().message("net.savignano.snotify.pgp-keystore-verification.canRead.success.message", this.location);
            this.build();
            this.loadKeyStore();
        } else if (e != null) {
            this.getBuilder().error();
            this.getBuilder().subTitle("net.savignano.snotify.pgp-keystore-verification.canRead.exception.title", new Object[0]);
            this.getBuilder().message("net.savignano.snotify.pgp-keystore-verification.canRead.exception.message", this.location, e.getClass().getSimpleName(), e.getLocalizedMessage());
            this.build();
        } else {
            this.getBuilder().error();
            this.getBuilder().subTitle("net.savignano.snotify.pgp-keystore-verification.canRead.failure.title", new Object[0]);
            this.getBuilder().message("net.savignano.snotify.pgp-keystore-verification.canRead.failure.message", this.location);
            this.build();
        }
    }

    private void loadKeyStore() {
        Exception e = null;
        PGPPublicKeyRingCollection krColl = null;
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(this.location));){
            krColl = PgpUtil.loadPublicKeys(is);
            log.debug("Could load key store from location: {}", (Object)this.location);
        }
        catch (Exception e1) {
            e = e1;
            log.debug("Could not load key store from location: " + this.location, (Throwable)e);
        }
        if (e == null) {
            if (krColl == null || krColl.size() == 0) {
                this.getBuilder().error();
                this.getBuilder().subTitle("net.savignano.snotify.pgp-keystore-verification.loadKeyStore.empty.title", new Object[0]);
                this.getBuilder().message("net.savignano.snotify.pgp-keystore-verification.loadKeyStore.empty.message", new Object[0]);
                this.build();
            } else {
                this.getBuilder().success();
                this.getBuilder().subTitle("net.savignano.snotify.pgp-keystore-verification.loadKeyStore.success.title", new Object[0]);
                this.getBuilder().message("net.savignano.snotify.pgp-keystore-verification.loadKeyStore.success.message", krColl.size());
                this.build();
                this.checkEmail(krColl);
            }
        } else {
            this.getBuilder().error();
            this.getBuilder().subTitle("net.savignano.snotify.pgp-keystore-verification.loadKeyStore.exception.title", new Object[0]);
            this.getBuilder().message("net.savignano.snotify.pgp-keystore-verification.loadKeyStore.exception.message", e.getClass().getSimpleName(), e.getLocalizedMessage());
            this.build();
        }
    }

    private void checkEmail(PGPPublicKeyRingCollection keyRingColl) {
        if (keyRingColl == null) {
            return;
        }
        if (this.getEmail() == null) {
            log.debug("No email address was given, so can't check if a key was found for it.");
            this.getBuilder().info();
            this.getBuilder().subTitle("net.savignano.snotify.pgp-keystore-verification.checkEmail.noEmail.title", new Object[0]);
            this.getBuilder().message("net.savignano.snotify.pgp-keystore-verification.checkEmail.noEmail.message", new Object[0]);
            this.build();
            return;
        }
        PGPPublicKeyRing ring = PgpUtil.getKeysForEmail(keyRingColl, this.getEmail());
        if (ring != null) {
            log.debug("Key for email <{}> was found in key store.", (Object)this.email);
            this.getBuilder().success();
            this.getBuilder().subTitle("net.savignano.snotify.pgp-keystore-verification.checkEmail.success.title", new Object[0]);
            this.getBuilder().message("net.savignano.snotify.pgp-keystore-verification.checkEmail.success.message", this.email);
            this.build();
            this.verifyKey(new SnotifyPgpPublicKey(ring, this.email));
        } else {
            log.debug("No key for email <{}> was found in key store.", (Object)this.email);
            this.getBuilder().warning();
            this.getBuilder().subTitle("net.savignano.snotify.pgp-keystore-verification.checkEmail.failure.title", new Object[0]);
            this.getBuilder().message("net.savignano.snotify.pgp-keystore-verification.checkEmail.failure.message", this.email);
            this.build();
        }
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }
}

