/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.gui.templates.handler.impl;

import java.security.GeneralSecurityException;
import javax.servlet.http.HttpServletRequest;
import net.savignano.snotify.atlassian.common.ASnotifyAppProperties;
import net.savignano.snotify.atlassian.common.EProperty;
import net.savignano.snotify.atlassian.common.util.SecurityUtil;
import net.savignano.snotify.atlassian.gui.templates.handler.IPasswordHandler;
import net.savignano.snotify.atlassian.gui.templates.handler.impl.AAppPropValueHandler;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PasswordHandler
extends AAppPropValueHandler<char[]>
implements IPasswordHandler {
    private static final Logger log = LoggerFactory.getLogger(PasswordHandler.class);
    private String passEnc;

    public PasswordHandler(String id, ASnotifyAppProperties appProps, EProperty prop) {
        super(id, appProps, prop);
    }

    @Override
    protected ASnotifyAppProperties getAppProps() {
        return (ASnotifyAppProperties)super.getAppProps();
    }

    @Override
    public void read() {
        this.passEnc = this.getAppProps().getAsString(this.getProp());
    }

    @Override
    public void receive(HttpServletRequest request) {
        String password = request.getParameter(this.getId() + ";password");
        if (StringUtils.isBlank((String)password)) {
            this.passEnc = null;
        } else if (this.isDummyPassword(password)) {
            this.passEnc = request.getParameter(this.getId() + ";passcheck");
        } else {
            try {
                this.passEnc = SecurityUtil.encode(password);
            }
            catch (GeneralSecurityException e) {
                log.error("Could not obfuscate password for key " + (Object)((Object)this.getProp()) + ". Error message: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void store() {
        this.getAppProps().setAsString(this.getProp(), this.passEnc);
    }

    @Override
    public char[] getValue() {
        return this.decode(this.passEnc);
    }

    @Override
    public void setValue(char[] value) {
        this.passEnc = value == null || value.length == 0 ? null : this.encode(value);
    }

    @Override
    public String getPassword() {
        char[] password = this.decode(this.passEnc);
        if (password == null) {
            return "";
        }
        for (int i = 0; i < password.length; ++i) {
            password[i] = 42;
        }
        return new String(password);
    }

    @Override
    public String getPasswordCheck() {
        return this.passEnc != null ? this.passEnc : "";
    }

    private String encode(char[] pass) {
        if (pass == null) {
            return null;
        }
        try {
            return SecurityUtil.encode(pass);
        }
        catch (GeneralSecurityException e) {
            log.error("Could not obfuscate password for key " + (Object)((Object)this.getProp()) + ". Error message: " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private char[] decode(String pass) {
        if (pass == null) {
            return null;
        }
        try {
            return SecurityUtil.decodeCharsBase64Aes(pass);
        }
        catch (GeneralSecurityException e) {
            log.error("Could not display password for key " + (Object)((Object)this.getProp()) + ". Error message: " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private boolean isDummyPassword(String password) {
        for (int i = 0; i < password.length(); ++i) {
            if (password.charAt(i) == '*') continue;
            return false;
        }
        return true;
    }
}

