/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.common.security.key;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;

public class PgpKeyRingSplitter
extends Reader {
    private final BufferedReader reader;
    private final EPgpKeyRingSplitterType type;
    private char[] buffer;
    private int bufferEnd;
    private boolean foundStart;
    private boolean foundEnd;

    public PgpKeyRingSplitter(Reader reader, EPgpKeyRingSplitterType type) {
        this.reader = new BufferedReader(reader, 80);
        this.type = type;
        this.buffer = new char[80];
        if (reader == null) {
            throw new IllegalArgumentException("Reader must not be null.");
        }
        if (type == null) {
            throw new IllegalArgumentException("Type must not be null.");
        }
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        String line;
        while (!this.foundStart) {
            line = this.reader.readLine();
            if (line == null) {
                return -1;
            }
            if (!line.equals(this.type.start)) continue;
            this.foundStart = true;
            this.ensureBufferCapacity(line.length() + 1);
            System.arraycopy(line.toCharArray(), 0, this.buffer, 0, line.length());
            this.bufferEnd = line.length();
            this.buffer[this.bufferEnd++] = 10;
        }
        if (this.bufferEnd >= len) {
            System.arraycopy(this.buffer, 0, cbuf, off, len);
            this.bufferEnd -= len;
            System.arraycopy(this.buffer, len, this.buffer, 0, this.bufferEnd);
            return len;
        }
        if (this.foundEnd) {
            if (this.bufferEnd == 0) {
                return -1;
            }
            int rest = this.bufferEnd;
            this.bufferEnd = 0;
            System.arraycopy(this.buffer, 0, cbuf, off, rest);
            return rest;
        }
        line = this.reader.readLine();
        if (line == null) {
            this.foundEnd = true;
        } else {
            if (line.equals(this.type.end)) {
                this.foundEnd = true;
            }
            this.ensureBufferCapacity(this.bufferEnd + line.length() + 1);
            System.arraycopy(line.toCharArray(), 0, this.buffer, this.bufferEnd, line.length());
            this.bufferEnd += line.length();
            this.buffer[this.bufferEnd++] = 10;
        }
        return this.read(cbuf, off, len);
    }

    @Override
    public void close() throws IOException {
        this.foundStart = true;
        this.foundEnd = true;
        this.bufferEnd = 0;
        this.reader.close();
    }

    private void ensureBufferCapacity(int desiredLength) {
        if (this.buffer.length < desiredLength) {
            char[] newBuffer = new char[desiredLength];
            System.arraycopy(this.buffer, 0, newBuffer, 0, this.bufferEnd);
            this.buffer = newBuffer;
        }
    }

    public static enum EPgpKeyRingSplitterType {
        PRIVATE("-----BEGIN PGP PRIVATE KEY BLOCK-----", "-----END PGP PRIVATE KEY BLOCK-----"),
        PUBLIC("-----BEGIN PGP PUBLIC KEY BLOCK-----", "-----END PGP PUBLIC KEY BLOCK-----");

        private String start;
        private String end;

        private EPgpKeyRingSplitterType(String start, String end) {
            this.start = start;
            this.end = end;
        }
    }
}

