/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.gui;

import com.atlassian.mail.Email;
import com.atlassian.mail.MailException;
import com.atlassian.mail.server.SMTPMailServer;
import java.util.Arrays;
import java.util.Date;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MailDateFormat;
import net.savignano.snotify.atlassian.common.EProperty;
import net.savignano.snotify.atlassian.common.ISnotifyAppProperties;
import net.savignano.snotify.atlassian.common.IVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailerVersion
implements IVersion {
    private static final Logger log = LoggerFactory.getLogger(MailerVersion.class);
    private static String version;
    private final SMTPMailServer server;
    private final ISnotifyAppProperties appProps;

    public MailerVersion(SMTPMailServer server, ISnotifyAppProperties appProps) {
        this.server = server;
        this.appProps = appProps;
        if (server == null) {
            throw new IllegalArgumentException("Server must not be null.");
        }
        if (appProps == null) {
            throw new IllegalArgumentException("Application Properties must not be null.");
        }
    }

    @Override
    public String getVersion() {
        if (version == null) {
            version = this.getMailerVersion();
        }
        return version;
    }

    private String getMailerVersion() {
        this.appProps.setString(EProperty.MAILER_VERSION, null);
        try {
            Email email = this.createEmail();
            log.debug("Sending internal email to check S/Notify mailer library version. Email: {}", (Object)email);
            this.server.send(email);
        }
        catch (MailException e) {
            log.error("Could not send internal email to check S/Notify mailer library version. Error message: " + e.getMessage(), (Throwable)e);
        }
        return this.appProps.getString(EProperty.MAILER_VERSION);
    }

    private Email createEmail() throws MailException {
        String address = this.getAddress();
        Email email = new Email(address);
        email.setSubject("S/Notify test email");
        email.setFrom(address);
        email.setBody("This is a test email of S/Notify. Should you have received this, S/Notify mailer library is not properly configured or missing entirely.");
        email.addHeader("Date", new MailDateFormat().format(new Date()));
        email.addHeader("X-SNotify-Do-Not-Send", Boolean.TRUE.toString());
        return email;
    }

    private String getAddress() throws MailException {
        Object[] addresses;
        String address = this.server.getDefaultFrom();
        if (address == null) {
            throw new MailException("No 'form' address configured for SMPT server.");
        }
        try {
            addresses = InternetAddress.parse(address);
        }
        catch (AddressException e) {
            throw new MailException("Could not parse email address \"" + address + ". Error message: " + e.getMessage(), (Throwable)e);
        }
        if (addresses == null || addresses.length == 0) {
            throw new MailException("Parsing failed for email address \"" + address + "\". No address available.");
        }
        if (addresses.length > 1) {
            log.warn("'From' address of configured SMTP server contains multiple addresses. Only first address will be used. Found addresses: {}", (Object)Arrays.toString(addresses));
        }
        return addresses[0].getAddress();
    }
}

