/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.asn1.cmc.test;

import java.math.BigInteger;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Integer;
import net.savignano.thirdparty.org.bouncycastle.asn1.DERSequence;
import net.savignano.thirdparty.org.bouncycastle.asn1.cmc.PublishTrustAnchors;
import net.savignano.thirdparty.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import net.savignano.thirdparty.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import net.savignano.thirdparty.org.bouncycastle.util.test.SimpleTest;

public class PublishTrustAnchorsTest
extends SimpleTest {
    public static void main(String[] args) {
        PublishTrustAnchorsTest.runTest(new PublishTrustAnchorsTest());
    }

    public String getName() {
        return "PublishTrustAnchorsTest";
    }

    public void performTest() throws Exception {
        PublishTrustAnchors publishTrustAnchors = new PublishTrustAnchors(new BigInteger("10"), new AlgorithmIdentifier(PKCSObjectIdentifiers.crlTypes, new ASN1Integer(5L)), new byte[][]{"cats".getBytes()});
        byte[] b = publishTrustAnchors.getEncoded();
        PublishTrustAnchors publishTrustAnchorsResult = PublishTrustAnchors.getInstance(b);
        this.isEquals("seqNumber", publishTrustAnchors.getSeqNumber(), publishTrustAnchorsResult.getSeqNumber());
        this.isEquals("hashAlgorithm", publishTrustAnchors.getHashAlgorithm(), publishTrustAnchorsResult.getHashAlgorithm());
        this.isTrue("anchorHashes", this.areEqual(publishTrustAnchors.getAnchorHashes(), publishTrustAnchorsResult.getAnchorHashes()));
        try {
            PublishTrustAnchors.getInstance(new DERSequence());
            this.fail("Sequence must be 3");
        }
        catch (Throwable t) {
            this.isEquals("Expect IllegalArgumentException", t.getClass(), IllegalArgumentException.class);
        }
    }
}

