/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.oer.its;

import java.io.IOException;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Choice;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Encodable;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Null;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Object;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1OctetString;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Primitive;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1TaggedObject;
import net.savignano.thirdparty.org.bouncycastle.asn1.DERNull;
import net.savignano.thirdparty.org.bouncycastle.asn1.DEROctetString;
import net.savignano.thirdparty.org.bouncycastle.asn1.DERTaggedObject;
import net.savignano.thirdparty.org.bouncycastle.oer.its.BitmapSspRange;
import net.savignano.thirdparty.org.bouncycastle.oer.its.SequenceOfOctetString;

public class SspRange
extends ASN1Object
implements ASN1Choice {
    private static final int opaque = 0;
    private static final int all = 1;
    private static final int extension = 2;
    private static final int bitmapSspRange = 3;
    private final int choice;
    private final ASN1Encodable value;

    public SspRange(int choice, ASN1Encodable value) {
        switch (choice) {
            case 0: {
                if (value instanceof SequenceOfOctetString) break;
                throw new IllegalArgumentException("value is not SequenceOfOctetString");
            }
            case 1: {
                if (value instanceof ASN1Null) break;
                throw new IllegalArgumentException("value is not ASN1Null");
            }
            case 2: {
                if (value instanceof ASN1OctetString) break;
                throw new IllegalArgumentException("value is not ASN1OctetString");
            }
            case 3: {
                if (value instanceof BitmapSspRange) break;
                throw new IllegalArgumentException("value is not BitmapSspRange");
            }
        }
        this.choice = choice;
        this.value = value;
    }

    public static SspRange getInstance(Object src) {
        if (src instanceof SspRange) {
            return (SspRange)src;
        }
        ASN1TaggedObject taggedObject = ASN1TaggedObject.getInstance(src);
        int item = taggedObject.getTagNo();
        switch (item) {
            case 0: {
                return new SspRange(0, SequenceOfOctetString.getInstance(taggedObject.getObject()));
            }
            case 1: {
                return new SspRange(1, DERNull.INSTANCE);
            }
            case 2: {
                try {
                    return new SspRange(2, new DEROctetString(taggedObject.getObject().getEncoded()));
                }
                catch (IOException ioException) {
                    throw new RuntimeException(ioException.getMessage(), ioException);
                }
            }
            case 3: {
                return new SspRange(3, BitmapSspRange.getInstance(taggedObject.getObject()));
            }
        }
        throw new IllegalStateException("unknown choice " + item);
    }

    public static Builder builder() {
        return new Builder();
    }

    public ASN1Primitive toASN1Primitive() {
        return new DERTaggedObject(this.choice, this.value);
    }

    public static class Builder {
        private int choice;
        private ASN1Encodable value;

        public Builder setChoice(int choice) {
            this.choice = choice;
            return this;
        }

        public Builder setValue(ASN1Encodable value) {
            this.value = value;
            return this;
        }

        public Builder opaque(SequenceOfOctetString value) {
            this.value = value;
            this.choice = 0;
            return this;
        }

        public Builder all() {
            this.value = DERNull.INSTANCE;
            this.choice = 0;
            return this;
        }

        public Builder extension(byte[] value) {
            this.value = new DEROctetString(value);
            this.choice = 2;
            return this;
        }

        public Builder bitmapSSPRange(BitmapSspRange value) {
            this.value = value;
            this.choice = 3;
            return this;
        }

        public SspRange createSspRange() {
            return new SspRange(this.choice, this.value);
        }
    }
}

