/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.openpgp.operator.jcajce;

import java.security.Provider;
import net.savignano.thirdparty.org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import net.savignano.thirdparty.org.bouncycastle.jcajce.util.NamedJcaJceHelper;
import net.savignano.thirdparty.org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPException;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPSessionKey;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.PGPDataDecryptor;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.SessionKeyDataDecryptorFactory;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.jcajce.JcaPGPKeyConverter;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.jcajce.OperatorHelper;

public class JceSessionKeyDataDecryptorFactoryBuilder {
    private OperatorHelper helper = new OperatorHelper(new DefaultJcaJceHelper());
    private JcaPGPKeyConverter keyConverter = new JcaPGPKeyConverter();

    public JceSessionKeyDataDecryptorFactoryBuilder setProvider(Provider provider) {
        this.helper = new OperatorHelper(new ProviderJcaJceHelper(provider));
        this.keyConverter.setProvider(provider);
        return this;
    }

    public JceSessionKeyDataDecryptorFactoryBuilder setProvider(String providerName) {
        this.helper = new OperatorHelper(new NamedJcaJceHelper(providerName));
        this.keyConverter.setProvider(providerName);
        return this;
    }

    public SessionKeyDataDecryptorFactory build(PGPSessionKey sessionKey) {
        return new JceSessionKeyDataDecryptorFactory(this.helper, sessionKey);
    }

    private static class JceSessionKeyDataDecryptorFactory
    implements SessionKeyDataDecryptorFactory {
        private final OperatorHelper helper;
        private final PGPSessionKey sessionKey;

        public JceSessionKeyDataDecryptorFactory(OperatorHelper helper, PGPSessionKey sessionKey) {
            this.helper = helper;
            this.sessionKey = sessionKey;
        }

        public byte[] recoverSessionData(int keyAlgorithm, byte[] key, byte[] seckKeyData) throws PGPException {
            throw new IllegalStateException("trying to recover session data from session key!");
        }

        public byte[] recoverSessionData(int keyAlgorithm, byte[][] secKeyData) throws PGPException {
            throw new IllegalStateException("trying to recover session data from session key!");
        }

        public PGPSessionKey getSessionKey() {
            return this.sessionKey;
        }

        public PGPDataDecryptor createDataDecryptor(boolean withIntegrityPacket, int encAlgorithm, byte[] key) throws PGPException {
            return this.helper.createDataDecryptor(withIntegrityPacket, encAlgorithm, key);
        }
    }
}

