/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.pqc.crypto.util;

import java.io.IOException;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Set;
import net.savignano.thirdparty.org.bouncycastle.asn1.DEROctetString;
import net.savignano.thirdparty.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import net.savignano.thirdparty.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import net.savignano.thirdparty.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import net.savignano.thirdparty.org.bouncycastle.pqc.asn1.McElieceCCA2PrivateKey;
import net.savignano.thirdparty.org.bouncycastle.pqc.asn1.PQCObjectIdentifiers;
import net.savignano.thirdparty.org.bouncycastle.pqc.asn1.SPHINCS256KeyParams;
import net.savignano.thirdparty.org.bouncycastle.pqc.asn1.XMSSKeyParams;
import net.savignano.thirdparty.org.bouncycastle.pqc.asn1.XMSSMTKeyParams;
import net.savignano.thirdparty.org.bouncycastle.pqc.asn1.XMSSMTPrivateKey;
import net.savignano.thirdparty.org.bouncycastle.pqc.asn1.XMSSPrivateKey;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.lms.Composer;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.lms.HSSPrivateKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.lms.LMSPrivateKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.mceliece.McElieceCCA2PrivateKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.newhope.NHPrivateKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.qtesla.QTESLAPrivateKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.sphincs.SPHINCSPrivateKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.util.Utils;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.xmss.BDS;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.xmss.BDSStateMap;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.xmss.XMSSMTPrivateKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.xmss.XMSSPrivateKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.xmss.XMSSUtil;
import net.savignano.thirdparty.org.bouncycastle.util.Pack;

public class PrivateKeyInfoFactory {
    private PrivateKeyInfoFactory() {
    }

    public static PrivateKeyInfo createPrivateKeyInfo(AsymmetricKeyParameter privateKey) throws IOException {
        return PrivateKeyInfoFactory.createPrivateKeyInfo(privateKey, null);
    }

    public static PrivateKeyInfo createPrivateKeyInfo(AsymmetricKeyParameter privateKey, ASN1Set attributes) throws IOException {
        if (privateKey instanceof QTESLAPrivateKeyParameters) {
            QTESLAPrivateKeyParameters keyParams = (QTESLAPrivateKeyParameters)privateKey;
            AlgorithmIdentifier algorithmIdentifier = Utils.qTeslaLookupAlgID(keyParams.getSecurityCategory());
            return new PrivateKeyInfo(algorithmIdentifier, new DEROctetString(keyParams.getSecret()), attributes);
        }
        if (privateKey instanceof SPHINCSPrivateKeyParameters) {
            SPHINCSPrivateKeyParameters params = (SPHINCSPrivateKeyParameters)privateKey;
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.sphincs256, new SPHINCS256KeyParams(Utils.sphincs256LookupTreeAlgID(params.getTreeDigest())));
            return new PrivateKeyInfo(algorithmIdentifier, new DEROctetString(params.getKeyData()));
        }
        if (privateKey instanceof NHPrivateKeyParameters) {
            NHPrivateKeyParameters params = (NHPrivateKeyParameters)privateKey;
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.newHope);
            short[] privateKeyData = params.getSecData();
            byte[] octets = new byte[privateKeyData.length * 2];
            for (int i = 0; i != privateKeyData.length; ++i) {
                Pack.shortToLittleEndian(privateKeyData[i], octets, i * 2);
            }
            return new PrivateKeyInfo(algorithmIdentifier, new DEROctetString(octets));
        }
        if (privateKey instanceof LMSPrivateKeyParameters) {
            LMSPrivateKeyParameters params = (LMSPrivateKeyParameters)privateKey;
            byte[] encoding = Composer.compose().u32str(1).bytes(params).build();
            byte[] pubEncoding = Composer.compose().u32str(1).bytes(params.getPublicKey()).build();
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_alg_hss_lms_hashsig);
            return new PrivateKeyInfo(algorithmIdentifier, new DEROctetString(encoding), attributes, pubEncoding);
        }
        if (privateKey instanceof HSSPrivateKeyParameters) {
            HSSPrivateKeyParameters params = (HSSPrivateKeyParameters)privateKey;
            byte[] encoding = Composer.compose().u32str(params.getL()).bytes(params).build();
            byte[] pubEncoding = Composer.compose().u32str(params.getL()).bytes(params.getPublicKey().getLMSPublicKey()).build();
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_alg_hss_lms_hashsig);
            return new PrivateKeyInfo(algorithmIdentifier, new DEROctetString(encoding), attributes, pubEncoding);
        }
        if (privateKey instanceof XMSSPrivateKeyParameters) {
            XMSSPrivateKeyParameters keyParams = (XMSSPrivateKeyParameters)privateKey;
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.xmss, new XMSSKeyParams(keyParams.getParameters().getHeight(), Utils.xmssLookupTreeAlgID(keyParams.getTreeDigest())));
            return new PrivateKeyInfo(algorithmIdentifier, PrivateKeyInfoFactory.xmssCreateKeyStructure(keyParams), attributes);
        }
        if (privateKey instanceof XMSSMTPrivateKeyParameters) {
            XMSSMTPrivateKeyParameters keyParams = (XMSSMTPrivateKeyParameters)privateKey;
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.xmss_mt, new XMSSMTKeyParams(keyParams.getParameters().getHeight(), keyParams.getParameters().getLayers(), Utils.xmssLookupTreeAlgID(keyParams.getTreeDigest())));
            return new PrivateKeyInfo(algorithmIdentifier, PrivateKeyInfoFactory.xmssmtCreateKeyStructure(keyParams), attributes);
        }
        if (privateKey instanceof McElieceCCA2PrivateKeyParameters) {
            McElieceCCA2PrivateKeyParameters priv = (McElieceCCA2PrivateKeyParameters)privateKey;
            McElieceCCA2PrivateKey mcEliecePriv = new McElieceCCA2PrivateKey(priv.getN(), priv.getK(), priv.getField(), priv.getGoppaPoly(), priv.getP(), Utils.getAlgorithmIdentifier(priv.getDigest()));
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.mcElieceCca2);
            return new PrivateKeyInfo(algorithmIdentifier, mcEliecePriv);
        }
        throw new IOException("key parameters not recognized");
    }

    private static XMSSPrivateKey xmssCreateKeyStructure(XMSSPrivateKeyParameters keyParams) throws IOException {
        byte[] keyData = keyParams.getEncoded();
        int n = keyParams.getParameters().getTreeDigestSize();
        int totalHeight = keyParams.getParameters().getHeight();
        int indexSize = 4;
        int secretKeySize = n;
        int secretKeyPRFSize = n;
        int publicSeedSize = n;
        int rootSize = n;
        int position = 0;
        int index = (int)XMSSUtil.bytesToXBigEndian(keyData, position, indexSize);
        if (!XMSSUtil.isIndexValid(totalHeight, index)) {
            throw new IllegalArgumentException("index out of bounds");
        }
        byte[] secretKeySeed = XMSSUtil.extractBytesAtOffset(keyData, position += indexSize, secretKeySize);
        byte[] secretKeyPRF = XMSSUtil.extractBytesAtOffset(keyData, position += secretKeySize, secretKeyPRFSize);
        byte[] publicSeed = XMSSUtil.extractBytesAtOffset(keyData, position += secretKeyPRFSize, publicSeedSize);
        byte[] root = XMSSUtil.extractBytesAtOffset(keyData, position += publicSeedSize, rootSize);
        byte[] bdsStateBinary = XMSSUtil.extractBytesAtOffset(keyData, position += rootSize, keyData.length - position);
        BDS bds = null;
        try {
            bds = (BDS)XMSSUtil.deserialize(bdsStateBinary, BDS.class);
        }
        catch (ClassNotFoundException e) {
            throw new IOException("cannot parse BDS: " + e.getMessage());
        }
        if (bds.getMaxIndex() != (1 << totalHeight) - 1) {
            return new XMSSPrivateKey(index, secretKeySeed, secretKeyPRF, publicSeed, root, bdsStateBinary, bds.getMaxIndex());
        }
        return new XMSSPrivateKey(index, secretKeySeed, secretKeyPRF, publicSeed, root, bdsStateBinary);
    }

    private static XMSSMTPrivateKey xmssmtCreateKeyStructure(XMSSMTPrivateKeyParameters keyParams) throws IOException {
        byte[] keyData = keyParams.getEncoded();
        int n = keyParams.getParameters().getTreeDigestSize();
        int totalHeight = keyParams.getParameters().getHeight();
        int indexSize = (totalHeight + 7) / 8;
        int secretKeySize = n;
        int secretKeyPRFSize = n;
        int publicSeedSize = n;
        int rootSize = n;
        int position = 0;
        int index = (int)XMSSUtil.bytesToXBigEndian(keyData, position, indexSize);
        if (!XMSSUtil.isIndexValid(totalHeight, index)) {
            throw new IllegalArgumentException("index out of bounds");
        }
        byte[] secretKeySeed = XMSSUtil.extractBytesAtOffset(keyData, position += indexSize, secretKeySize);
        byte[] secretKeyPRF = XMSSUtil.extractBytesAtOffset(keyData, position += secretKeySize, secretKeyPRFSize);
        byte[] publicSeed = XMSSUtil.extractBytesAtOffset(keyData, position += secretKeyPRFSize, publicSeedSize);
        byte[] root = XMSSUtil.extractBytesAtOffset(keyData, position += publicSeedSize, rootSize);
        byte[] bdsStateBinary = XMSSUtil.extractBytesAtOffset(keyData, position += rootSize, keyData.length - position);
        BDSStateMap bds = null;
        try {
            bds = (BDSStateMap)XMSSUtil.deserialize(bdsStateBinary, BDSStateMap.class);
        }
        catch (ClassNotFoundException e) {
            throw new IOException("cannot parse BDSStateMap: " + e.getMessage());
        }
        if (bds.getMaxIndex() != (1L << totalHeight) - 1L) {
            return new XMSSMTPrivateKey(index, secretKeySeed, secretKeyPRF, publicSeed, root, bdsStateBinary, bds.getMaxIndex());
        }
        return new XMSSMTPrivateKey(index, secretKeySeed, secretKeyPRF, publicSeed, root, bdsStateBinary);
    }
}

