/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.tls;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import net.savignano.thirdparty.org.bouncycastle.tls.ProtocolVersion;
import net.savignano.thirdparty.org.bouncycastle.tls.TlsContext;
import net.savignano.thirdparty.org.bouncycastle.tls.TlsFatalAlert;
import net.savignano.thirdparty.org.bouncycastle.tls.TlsProtocol;
import net.savignano.thirdparty.org.bouncycastle.tls.TlsUtils;
import net.savignano.thirdparty.org.bouncycastle.util.Arrays;

public class ServerHello {
    private static final byte[] HELLO_RETRY_REQUEST_MAGIC = new byte[]{-49, 33, -83, 116, -27, -102, 97, 17, -66, 29, -116, 2, 30, 101, -72, -111, -62, -94, 17, 22, 122, -69, -116, 94, 7, -98, 9, -30, -56, -88, 51, -100};
    private final ProtocolVersion version;
    private final byte[] random;
    private final byte[] sessionID;
    private final int cipherSuite;
    private final Hashtable extensions;

    public ServerHello(byte[] sessionID, int cipherSuite, Hashtable extensions) {
        this(ProtocolVersion.TLSv12, Arrays.clone(HELLO_RETRY_REQUEST_MAGIC), sessionID, cipherSuite, extensions);
    }

    public ServerHello(ProtocolVersion version, byte[] random, byte[] sessionID, int cipherSuite, Hashtable extensions) {
        this.version = version;
        this.random = random;
        this.sessionID = sessionID;
        this.cipherSuite = cipherSuite;
        this.extensions = extensions;
    }

    public int getCipherSuite() {
        return this.cipherSuite;
    }

    public Hashtable getExtensions() {
        return this.extensions;
    }

    public byte[] getRandom() {
        return this.random;
    }

    public byte[] getSessionID() {
        return this.sessionID;
    }

    public ProtocolVersion getVersion() {
        return this.version;
    }

    public boolean isHelloRetryRequest() {
        return Arrays.areEqual(HELLO_RETRY_REQUEST_MAGIC, this.random);
    }

    public void encode(TlsContext context, OutputStream output) throws IOException {
        TlsUtils.writeVersion(this.version, output);
        output.write(this.random);
        TlsUtils.writeOpaque8(this.sessionID, output);
        TlsUtils.writeUint16(this.cipherSuite, output);
        TlsUtils.writeUint8((short)0, output);
        TlsProtocol.writeExtensions(output, this.extensions);
    }

    public static ServerHello parse(ByteArrayInputStream input) throws IOException {
        ProtocolVersion version = TlsUtils.readVersion(input);
        byte[] random = TlsUtils.readFully(32, (InputStream)input);
        byte[] sessionID = TlsUtils.readOpaque8(input, 0, 32);
        int cipherSuite = TlsUtils.readUint16(input);
        short compressionMethod = TlsUtils.readUint8(input);
        if (0 != compressionMethod) {
            throw new TlsFatalAlert(47);
        }
        Hashtable extensions = TlsProtocol.readExtensions(input);
        return new ServerHello(version, random, sessionID, cipherSuite, extensions);
    }
}

