/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.tls.crypto.impl.bc;

import java.io.IOException;
import java.math.BigInteger;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Encodable;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Primitive;
import net.savignano.thirdparty.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import net.savignano.thirdparty.org.bouncycastle.asn1.x509.Certificate;
import net.savignano.thirdparty.org.bouncycastle.asn1.x509.Extension;
import net.savignano.thirdparty.org.bouncycastle.asn1.x509.Extensions;
import net.savignano.thirdparty.org.bouncycastle.asn1.x509.KeyUsage;
import net.savignano.thirdparty.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.DHPublicKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.DSAPublicKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.Ed25519PublicKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.Ed448PublicKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.RSAKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.crypto.util.PublicKeyFactory;
import net.savignano.thirdparty.org.bouncycastle.tls.SignatureScheme;
import net.savignano.thirdparty.org.bouncycastle.tls.TlsFatalAlert;
import net.savignano.thirdparty.org.bouncycastle.tls.TlsUtils;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.TlsCertificate;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.TlsEncryptor;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.TlsVerifier;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.impl.RSAUtil;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.impl.bc.BcTlsDSAVerifier;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.impl.bc.BcTlsECDSA13Verifier;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.impl.bc.BcTlsECDSAVerifier;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.impl.bc.BcTlsEd25519Verifier;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.impl.bc.BcTlsEd448Verifier;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.impl.bc.BcTlsRSAEncryptor;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.impl.bc.BcTlsRSAPSSVerifier;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.impl.bc.BcTlsRSAVerifier;
import net.savignano.thirdparty.org.bouncycastle.util.Arrays;

public class BcTlsCertificate
implements TlsCertificate {
    protected final BcTlsCrypto crypto;
    protected final Certificate certificate;
    protected DHPublicKeyParameters pubKeyDH = null;
    protected ECPublicKeyParameters pubKeyEC = null;
    protected Ed25519PublicKeyParameters pubKeyEd25519 = null;
    protected Ed448PublicKeyParameters pubKeyEd448 = null;
    protected RSAKeyParameters pubKeyRSA = null;

    public static BcTlsCertificate convert(BcTlsCrypto crypto, TlsCertificate certificate) throws IOException {
        if (certificate instanceof BcTlsCertificate) {
            return (BcTlsCertificate)certificate;
        }
        return new BcTlsCertificate(crypto, certificate.getEncoded());
    }

    public static Certificate parseCertificate(byte[] encoding) throws IOException {
        try {
            ASN1Primitive asn1 = TlsUtils.readASN1Object(encoding);
            return Certificate.getInstance(asn1);
        }
        catch (IllegalArgumentException e) {
            throw new TlsFatalAlert(42, (Throwable)e);
        }
    }

    public BcTlsCertificate(BcTlsCrypto crypto, byte[] encoding) throws IOException {
        this(crypto, BcTlsCertificate.parseCertificate(encoding));
    }

    public BcTlsCertificate(BcTlsCrypto crypto, Certificate certificate) {
        this.crypto = crypto;
        this.certificate = certificate;
    }

    public TlsEncryptor createEncryptor(int tlsCertificateRole) throws IOException {
        this.validateKeyUsage(32);
        switch (tlsCertificateRole) {
            case 3: {
                this.pubKeyRSA = this.getPubKeyRSA();
                return new BcTlsRSAEncryptor(this.crypto, this.pubKeyRSA);
            }
        }
        throw new TlsFatalAlert(46);
    }

    public TlsVerifier createVerifier(short signatureAlgorithm) throws IOException {
        switch (signatureAlgorithm) {
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return this.createVerifier(SignatureScheme.from((short)8, signatureAlgorithm));
            }
        }
        this.validateKeyUsage(128);
        switch (signatureAlgorithm) {
            case 1: {
                this.validateRSA_PKCS1();
                return new BcTlsRSAVerifier(this.crypto, this.getPubKeyRSA());
            }
            case 2: {
                return new BcTlsDSAVerifier(this.crypto, this.getPubKeyDSS());
            }
            case 3: {
                return new BcTlsECDSAVerifier(this.crypto, this.getPubKeyEC());
            }
        }
        throw new TlsFatalAlert(46);
    }

    public TlsVerifier createVerifier(int signatureScheme) throws IOException {
        this.validateKeyUsage(128);
        switch (signatureScheme) {
            case 515: 
            case 1027: 
            case 1283: 
            case 1539: 
            case 2074: 
            case 2075: 
            case 2076: {
                return new BcTlsECDSA13Verifier(this.crypto, this.getPubKeyEC(), signatureScheme);
            }
            case 2055: {
                return new BcTlsEd25519Verifier(this.crypto, this.getPubKeyEd25519());
            }
            case 2056: {
                return new BcTlsEd448Verifier(this.crypto, this.getPubKeyEd448());
            }
            case 513: 
            case 1025: 
            case 1281: 
            case 1537: {
                this.validateRSA_PKCS1();
                return new BcTlsRSAVerifier(this.crypto, this.getPubKeyRSA());
            }
            case 2057: 
            case 2058: 
            case 2059: {
                this.validateRSA_PSS_PSS(SignatureScheme.getSignatureAlgorithm(signatureScheme));
                return new BcTlsRSAPSSVerifier(this.crypto, this.getPubKeyRSA(), signatureScheme);
            }
            case 2052: 
            case 2053: 
            case 2054: {
                this.validateRSA_PSS_RSAE();
                return new BcTlsRSAPSSVerifier(this.crypto, this.getPubKeyRSA(), signatureScheme);
            }
        }
        throw new TlsFatalAlert(46);
    }

    public byte[] getEncoded() throws IOException {
        return this.certificate.getEncoded("DER");
    }

    public byte[] getExtension(ASN1ObjectIdentifier extensionOID) throws IOException {
        Extension extension;
        Extensions extensions = this.certificate.getTBSCertificate().getExtensions();
        if (extensions != null && (extension = extensions.getExtension(extensionOID)) != null) {
            return Arrays.clone(extension.getExtnValue().getOctets());
        }
        return null;
    }

    public BigInteger getSerialNumber() {
        return this.certificate.getSerialNumber().getValue();
    }

    public String getSigAlgOID() {
        return this.certificate.getSignatureAlgorithm().getAlgorithm().getId();
    }

    public ASN1Encodable getSigAlgParams() {
        return this.certificate.getSignatureAlgorithm().getParameters();
    }

    public short getLegacySignatureAlgorithm() throws IOException {
        AsymmetricKeyParameter publicKey = this.getPublicKey();
        if (publicKey.isPrivate()) {
            throw new TlsFatalAlert(80);
        }
        if (!this.supportsKeyUsage(128)) {
            return -1;
        }
        if (publicKey instanceof RSAKeyParameters) {
            return 1;
        }
        if (publicKey instanceof DSAPublicKeyParameters) {
            return 2;
        }
        if (publicKey instanceof ECPublicKeyParameters) {
            return 3;
        }
        return -1;
    }

    public DHPublicKeyParameters getPubKeyDH() throws IOException {
        try {
            return (DHPublicKeyParameters)this.getPublicKey();
        }
        catch (ClassCastException e) {
            throw new TlsFatalAlert(46, (Throwable)e);
        }
    }

    public DSAPublicKeyParameters getPubKeyDSS() throws IOException {
        try {
            return (DSAPublicKeyParameters)this.getPublicKey();
        }
        catch (ClassCastException e) {
            throw new TlsFatalAlert(46, (Throwable)e);
        }
    }

    public ECPublicKeyParameters getPubKeyEC() throws IOException {
        try {
            return (ECPublicKeyParameters)this.getPublicKey();
        }
        catch (ClassCastException e) {
            throw new TlsFatalAlert(46, (Throwable)e);
        }
    }

    public Ed25519PublicKeyParameters getPubKeyEd25519() throws IOException {
        try {
            return (Ed25519PublicKeyParameters)this.getPublicKey();
        }
        catch (ClassCastException e) {
            throw new TlsFatalAlert(46, (Throwable)e);
        }
    }

    public Ed448PublicKeyParameters getPubKeyEd448() throws IOException {
        try {
            return (Ed448PublicKeyParameters)this.getPublicKey();
        }
        catch (ClassCastException e) {
            throw new TlsFatalAlert(46, (Throwable)e);
        }
    }

    public RSAKeyParameters getPubKeyRSA() throws IOException {
        try {
            return (RSAKeyParameters)this.getPublicKey();
        }
        catch (ClassCastException e) {
            throw new TlsFatalAlert(46, (Throwable)e);
        }
    }

    public boolean supportsSignatureAlgorithm(short signatureAlgorithm) throws IOException {
        return this.supportsSignatureAlgorithm(signatureAlgorithm, 128);
    }

    public boolean supportsSignatureAlgorithmCA(short signatureAlgorithm) throws IOException {
        return this.supportsSignatureAlgorithm(signatureAlgorithm, 4);
    }

    public TlsCertificate checkUsageInRole(int tlsCertificateRole) throws IOException {
        switch (tlsCertificateRole) {
            case 1: {
                this.validateKeyUsage(8);
                this.pubKeyDH = this.getPubKeyDH();
                return this;
            }
            case 2: {
                this.validateKeyUsage(8);
                this.pubKeyEC = this.getPubKeyEC();
                return this;
            }
        }
        throw new TlsFatalAlert(46);
    }

    protected AsymmetricKeyParameter getPublicKey() throws IOException {
        SubjectPublicKeyInfo keyInfo = this.certificate.getSubjectPublicKeyInfo();
        try {
            return PublicKeyFactory.createKey(keyInfo);
        }
        catch (RuntimeException e) {
            throw new TlsFatalAlert(43, (Throwable)e);
        }
    }

    protected boolean supportsKeyUsage(int keyUsageBits) {
        int bits;
        KeyUsage ku;
        Extensions exts = this.certificate.getTBSCertificate().getExtensions();
        return exts == null || (ku = KeyUsage.fromExtensions(exts)) == null || ((bits = ku.getBytes()[0] & 0xFF) & keyUsageBits) == keyUsageBits;
    }

    protected boolean supportsRSA_PKCS1() {
        AlgorithmIdentifier pubKeyAlgID = this.certificate.getSubjectPublicKeyInfo().getAlgorithm();
        return RSAUtil.supportsPKCS1(pubKeyAlgID);
    }

    protected boolean supportsRSA_PSS_PSS(short signatureAlgorithm) {
        AlgorithmIdentifier pubKeyAlgID = this.certificate.getSubjectPublicKeyInfo().getAlgorithm();
        return RSAUtil.supportsPSS_PSS(signatureAlgorithm, pubKeyAlgID);
    }

    protected boolean supportsRSA_PSS_RSAE() {
        AlgorithmIdentifier pubKeyAlgID = this.certificate.getSubjectPublicKeyInfo().getAlgorithm();
        return RSAUtil.supportsPSS_RSAE(pubKeyAlgID);
    }

    protected boolean supportsSignatureAlgorithm(short signatureAlgorithm, int keyUsage) throws IOException {
        if (!this.supportsKeyUsage(keyUsage)) {
            return false;
        }
        AsymmetricKeyParameter publicKey = this.getPublicKey();
        switch (signatureAlgorithm) {
            case 1: {
                return this.supportsRSA_PKCS1() && publicKey instanceof RSAKeyParameters;
            }
            case 2: {
                return publicKey instanceof DSAPublicKeyParameters;
            }
            case 3: 
            case 26: 
            case 27: 
            case 28: {
                return publicKey instanceof ECPublicKeyParameters;
            }
            case 7: {
                return publicKey instanceof Ed25519PublicKeyParameters;
            }
            case 8: {
                return publicKey instanceof Ed448PublicKeyParameters;
            }
            case 4: 
            case 5: 
            case 6: {
                return this.supportsRSA_PSS_RSAE() && publicKey instanceof RSAKeyParameters;
            }
            case 9: 
            case 10: 
            case 11: {
                return this.supportsRSA_PSS_PSS(signatureAlgorithm) && publicKey instanceof RSAKeyParameters;
            }
        }
        return false;
    }

    public void validateKeyUsage(int keyUsageBits) throws IOException {
        if (!this.supportsKeyUsage(keyUsageBits)) {
            throw new TlsFatalAlert(46);
        }
    }

    protected void validateRSA_PKCS1() throws IOException {
        if (!this.supportsRSA_PKCS1()) {
            throw new TlsFatalAlert(46);
        }
    }

    protected void validateRSA_PSS_PSS(short signatureAlgorithm) throws IOException {
        if (!this.supportsRSA_PSS_PSS(signatureAlgorithm)) {
            throw new TlsFatalAlert(46);
        }
    }

    protected void validateRSA_PSS_RSAE() throws IOException {
        if (!this.supportsRSA_PSS_RSAE()) {
            throw new TlsFatalAlert(46);
        }
    }
}

