/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.tls.crypto.impl.jcajce;

import java.io.IOException;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import net.savignano.thirdparty.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import net.savignano.thirdparty.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import net.savignano.thirdparty.org.bouncycastle.jcajce.interfaces.XDHPublicKey;
import net.savignano.thirdparty.org.bouncycastle.jcajce.spec.RawEncodedKeySpec;
import net.savignano.thirdparty.org.bouncycastle.jce.provider.BouncyCastleProvider;
import net.savignano.thirdparty.org.bouncycastle.tls.TlsFatalAlert;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;

class XDHUtil {
    XDHUtil() {
    }

    static PublicKey decodePublicKey(JcaTlsCrypto crypto, String keyFactoryAlgorithm, ASN1ObjectIdentifier algorithmOID, byte[] encoding) throws TlsFatalAlert {
        try {
            KeyFactory kf = crypto.getHelper().createKeyFactory(keyFactoryAlgorithm);
            if (kf.getProvider() instanceof BouncyCastleProvider) {
                try {
                    RawEncodedKeySpec keySpec = new RawEncodedKeySpec(encoding);
                    return kf.generatePublic(keySpec);
                }
                catch (Exception keySpec) {
                    // empty catch block
                }
            }
            X509EncodedKeySpec keySpec = XDHUtil.createX509EncodedKeySpec(algorithmOID, encoding);
            return kf.generatePublic(keySpec);
        }
        catch (Exception e) {
            throw new TlsFatalAlert(47, (Throwable)e);
        }
    }

    static byte[] encodePublicKey(PublicKey publicKey) throws TlsFatalAlert {
        if (publicKey instanceof XDHPublicKey) {
            return ((XDHPublicKey)publicKey).getUEncoding();
        }
        if (!"X.509".equals(publicKey.getFormat())) {
            throw new TlsFatalAlert(80, "Public key format unrecognized");
        }
        try {
            SubjectPublicKeyInfo spki = SubjectPublicKeyInfo.getInstance(publicKey.getEncoded());
            return spki.getPublicKeyData().getOctets();
        }
        catch (Exception e) {
            throw new TlsFatalAlert(80, (Throwable)e);
        }
    }

    private static X509EncodedKeySpec createX509EncodedKeySpec(ASN1ObjectIdentifier oid, byte[] encoding) throws IOException {
        AlgorithmIdentifier algID = new AlgorithmIdentifier(oid);
        SubjectPublicKeyInfo spki = new SubjectPublicKeyInfo(algID, encoding);
        return new X509EncodedKeySpec(spki.getEncoded("DER"));
    }
}

