/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.common.security.access.smime;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import net.savignano.snotify.atlassian.common.Constants;
import net.savignano.snotify.atlassian.common.connector.LdapConnector;
import net.savignano.snotify.atlassian.common.enums.ECryptographyType;
import net.savignano.snotify.atlassian.common.enums.EKeyValidity;
import net.savignano.snotify.atlassian.common.security.access.ALdapLoader;
import net.savignano.snotify.atlassian.common.security.key.publicly.SnotifySmimePublicKey;
import net.savignano.snotify.atlassian.common.util.SecurityUtil;
import net.savignano.snotify.atlassian.common.util.SmimeUtil;
import net.savignano.thirdparty.org.bouncycastle.cert.X509CertificateHolder;
import net.savignano.thirdparty.org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import net.savignano.thirdparty.org.bouncycastle.cms.CMSException;
import net.savignano.thirdparty.org.bouncycastle.cms.CMSSignedData;
import net.savignano.thirdparty.org.bouncycastle.util.Store;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmimeLdapLoader
extends ALdapLoader<SnotifySmimePublicKey> {
    private static final Logger log = LoggerFactory.getLogger(SmimeLdapLoader.class);
    private static final String BINARY_TRANSFER = "java.naming.ldap.attributes.binary";
    private static final String USER_SMIME_CERT = "userSMIMECertificate";
    private static final String USER_CERT = "userCertificate";
    private boolean searchCert = true;
    private boolean searchSmime = true;
    private boolean expectP7b;

    public SmimeLdapLoader(LdapConnector connector) {
        super(connector, null);
    }

    public SmimeLdapLoader(LdapConnector connector, String userFilter) {
        super(connector, userFilter);
    }

    @Override
    protected SnotifySmimePublicKey loadLdapKey() throws Exception {
        LdapConnector connector = this.getConnector();
        List<Attributes> attrs = this.getAttributes(connector.getContext(), connector.getDn(), connector.applyFilter(this.getUserFilter()), this.getFieldParameter());
        if (!attrs.isEmpty()) {
            Attribute userSmimeCertAttr = null;
            Attribute userCertAttr = null;
            for (Attributes attributes : attrs) {
                NamingEnumeration<String> ids = attributes.getIDs();
                while (ids.hasMoreElements()) {
                    String id = (String)ids.nextElement();
                    log.trace("Attribute ID: {}", (Object)id);
                    if (id.startsWith(USER_CERT)) {
                        userCertAttr = attributes.get(id);
                        continue;
                    }
                    if (!id.startsWith(USER_SMIME_CERT)) continue;
                    userSmimeCertAttr = attributes.get(id);
                }
            }
            return this.getPublicKey(userSmimeCertAttr, userCertAttr);
        }
        return this.getValidityKey(EKeyValidity.NOT_FOUND);
    }

    @Override
    protected Map<String, String> createEnvironment() {
        Map<String, String> env = super.createEnvironment();
        env.put(BINARY_TRANSFER, USER_CERT);
        env.put(BINARY_TRANSFER, USER_SMIME_CERT);
        return env;
    }

    private SnotifySmimePublicKey getPublicKey(Attribute userSmimeCertAttr, Attribute userCertAttr) throws NamingException {
        SnotifySmimePublicKey otherKey;
        SnotifySmimePublicKey key = this.getValidityKey(EKeyValidity.NOT_FOUND);
        if (this.isSearchSmime()) {
            key = this.getKeyFromUserSmimeCert(userSmimeCertAttr);
        }
        if (this.isSearchCert() && key.getKeyValidity() != EKeyValidity.VALID && (otherKey = this.getKeyFromUserCert(userCertAttr)).compareTo(key) < 0) {
            key = otherKey;
        }
        return key;
    }

    private String[] getFieldParameter() {
        String[] stringArray;
        log.debug("Querying field {}: {}", (Object)USER_CERT, (Object)this.isSearchCert());
        log.debug("Querying field {}: {}", (Object)USER_SMIME_CERT, (Object)this.isSearchSmime());
        if (this.isSearchCert()) {
            String[] stringArray2;
            if (this.isSearchSmime()) {
                String[] stringArray3 = new String[2];
                stringArray3[0] = USER_CERT;
                stringArray2 = stringArray3;
                stringArray3[1] = USER_SMIME_CERT;
            } else {
                String[] stringArray4 = new String[1];
                stringArray2 = stringArray4;
                stringArray4[0] = USER_CERT;
            }
            return stringArray2;
        }
        if (this.isSearchSmime()) {
            String[] stringArray5 = new String[1];
            stringArray = stringArray5;
            stringArray5[0] = USER_SMIME_CERT;
        } else {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SnotifySmimePublicKey getKeyFromUserSmimeCert(Attribute attribute) throws NamingException {
        InputStream is;
        if (attribute == null || attribute.get() == null) {
            log.debug("No data stored in {} attribute.", (Object)USER_SMIME_CERT);
            return this.getValidityKey(EKeyValidity.NOT_FOUND);
        }
        log.debug("Retrieving data from {} attribute.", (Object)USER_SMIME_CERT);
        byte[] bytes = this.asBytes(attribute.get());
        if (bytes == null) {
            log.warn("Wrong data format in {} attribute for user {} in LDAP. Expected String or bytes, but found: {}", (Object[])new String[]{USER_SMIME_CERT, this.getUserFilter(), attribute.get().getClass().getName()});
            return this.getValidityKey(EKeyValidity.ERROR);
        }
        if (this.isExpectP7b()) {
            log.debug("Expecting p7b format.");
            is = new ByteArrayInputStream(bytes);
        } else {
            log.debug("Expecting p7m format.");
            try {
                MimeMessage msg = new MimeMessage(null, (InputStream)new ByteArrayInputStream(bytes));
                is = msg.getInputStream();
            }
            catch (IOException | MessagingException e) {
                log.warn("Error loading S/MIME certificate for " + this.getUserFilter() + " in LDAP. It appears that the stored content is not a properly formatted MIME message. Error message: " + e.getMessage(), e);
                return this.getValidityKey(EKeyValidity.ERROR);
            }
        }
        log.debug("Email address to look for: <{}>", (Object)this.getEmail());
        JcaX509CertificateConverter converter = new JcaX509CertificateConverter().setProvider(SecurityUtil.getProvider());
        try {
            CMSSignedData signature = new CMSSignedData(is);
            Store<X509CertificateHolder> certStore = signature.getCertificates();
            Collection<X509CertificateHolder> allHolders = certStore.getMatches(null);
            log.debug("Found {} certificate(s).", (Object)allHolders.size());
            if (allHolders.size() == 1) {
                X509Certificate certificate = converter.getCertificate(allHolders.iterator().next());
                log.trace("Used certificate: {}", (Object)certificate);
                SnotifySmimePublicKey key = new SnotifySmimePublicKey(certificate, this.getEmail());
                key.setKeySource(this.getKeySource());
                SnotifySmimePublicKey snotifySmimePublicKey = key;
                return snotifySmimePublicKey;
            }
            if (this.getEmail() != null) {
                for (X509CertificateHolder holder : allHolders) {
                    X509Certificate certificate = converter.getCertificate(holder);
                    log.trace("Found certificate: {}", (Object)certificate);
                    if (!SmimeUtil.isCertForEmail(certificate, this.getEmail())) continue;
                    log.debug("Using certificate with serial number: {}", (Object)SmimeUtil.getSerialNumber(certificate));
                    SnotifySmimePublicKey key = new SnotifySmimePublicKey(certificate, this.getEmail());
                    key.setKeySource(this.getKeySource());
                    SnotifySmimePublicKey snotifySmimePublicKey = key;
                    return snotifySmimePublicKey;
                }
            }
            log.debug("Found no certificate matching email: <{}>", (Object)this.getEmail());
            SnotifySmimePublicKey snotifySmimePublicKey = this.getValidityKey(EKeyValidity.NOT_FOUND);
            return snotifySmimePublicKey;
        }
        catch (CertificateException | CMSException e) {
            log.warn("Error loading S/MIME certificate for " + this.getUserFilter() + " in LDAP. It appears that the content is not a properly formatted p7 certificate or certificate chain. Error message: " + e.getMessage(), (Throwable)e);
            SnotifySmimePublicKey snotifySmimePublicKey = this.getValidityKey(EKeyValidity.ERROR);
            return snotifySmimePublicKey;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private SnotifySmimePublicKey getKeyFromUserCert(Attribute attribute) throws NamingException {
        if (attribute == null || attribute.size() == 0) {
            log.debug("No data stored in {} attribute.", (Object)USER_CERT);
            return this.getValidityKey(EKeyValidity.NOT_FOUND);
        }
        log.debug("Retrieving data from {} attribute.", (Object)attribute.getID());
        byte[] bytes = this.asBytes(attribute.get());
        if (bytes == null) {
            log.warn("Wrong data format in {} attribute for user {} in LDAP. Expected String or bytes, but found: {}", (Object[])new String[]{USER_CERT, this.getUserFilter(), attribute.get().getClass().getName()});
            return this.getValidityKey(EKeyValidity.ERROR);
        }
        log.info("Found S/MIME certificate for {} in LDAP.", (Object)this.getUserFilter());
        try {
            X509Certificate cert = SmimeUtil.createCertificate(bytes);
            log.trace("Found certificate: {}", (Object)cert);
            SnotifySmimePublicKey key = new SnotifySmimePublicKey(cert, this.getEmail());
            key.setKeySource(this.getKeySource());
            return key;
        }
        catch (CertificateException e) {
            log.warn("Error loading S/MIME certificate for " + this.getUserFilter() + " in LDAP. Error message: " + e.getMessage(), (Throwable)e);
            return this.getValidityKey(EKeyValidity.ERROR);
        }
    }

    private byte[] asBytes(Object obj) {
        if (obj instanceof byte[]) {
            return (byte[])obj;
        }
        if (obj instanceof String) {
            return ((String)obj).getBytes(Constants.UTF8_CHARSET);
        }
        return null;
    }

    @Override
    public ECryptographyType getCryptography() {
        return ECryptographyType.SMIME;
    }

    @Override
    protected SnotifySmimePublicKey getValidityKey(EKeyValidity validity) {
        return new SnotifySmimePublicKey(validity, this.getKeySource());
    }

    public boolean isSearchCert() {
        return this.searchCert;
    }

    public void setSearchCert(boolean searchCert) {
        this.searchCert = searchCert;
    }

    public boolean isSearchSmime() {
        return this.searchSmime;
    }

    public void setSearchSmime(boolean searchSmime) {
        this.searchSmime = searchSmime;
    }

    public boolean isExpectP7b() {
        return this.expectP7b;
    }

    public void setExpectP7b(boolean expectP7b) {
        this.expectP7b = expectP7b;
    }

    @Override
    public String toString() {
        return "SmimeLdapLoader [connector=" + this.getConnector() + ", userName=" + this.getUserFilter() + ", email=" + this.getEmail() + ", searchCert=" + this.searchCert + ", searchSmime=" + this.searchSmime + ", expectP7b=" + this.expectP7b + "]";
    }
}

