/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.confluence.gui.action;

import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.ConfluenceUserImpl;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.user.User;
import com.atlassian.velocity.htmlsafe.HtmlSafe;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.naming.ConfigurationException;
import javax.servlet.http.HttpServletRequest;
import net.savignano.snotify.atlassian.common.ASnotifyAppProperties;
import net.savignano.snotify.atlassian.common.EProperty;
import net.savignano.snotify.atlassian.common.ISnotifyI18n;
import net.savignano.snotify.atlassian.common.connector.AtlassianLdapConnector;
import net.savignano.snotify.atlassian.common.connector.LdapConnector;
import net.savignano.snotify.atlassian.common.enums.ECryptographyType;
import net.savignano.snotify.atlassian.common.enums.EEncryptionTypePriority;
import net.savignano.snotify.atlassian.common.enums.EKeySource;
import net.savignano.snotify.atlassian.common.security.access.pgp.PgpGlobalDirectoryLoader;
import net.savignano.snotify.atlassian.common.security.access.pgp.PgpKeyServerLoader;
import net.savignano.snotify.atlassian.common.security.access.smime.SmimeLdapLoader;
import net.savignano.snotify.atlassian.gui.keysource.verification.AKeySourceVerification;
import net.savignano.snotify.atlassian.gui.keysource.verification.EVerificationStatus;
import net.savignano.snotify.atlassian.gui.keysource.verification.VerificationStatus;
import net.savignano.snotify.atlassian.gui.keysource.verification.pgp.PgpGlobalDirectoryVerification;
import net.savignano.snotify.atlassian.gui.keysource.verification.pgp.PgpKeyServerVerification;
import net.savignano.snotify.atlassian.gui.keysource.verification.pgp.PgpPublicKeyStoreVerification;
import net.savignano.snotify.atlassian.gui.keysource.verification.smime.SmimeKeyStoreVerification;
import net.savignano.snotify.atlassian.gui.keysource.verification.smime.SmimeLdapVerification;
import net.savignano.snotify.atlassian.gui.keysource.verification.smime.SmimeP7bVerification;
import net.savignano.snotify.atlassian.gui.templates.handler.IValueHandler;
import net.savignano.snotify.atlassian.gui.templates.handler.IValueHandlerProvider;
import net.savignano.snotify.atlassian.gui.templates.handler.impl.CheckBoxHandler;
import net.savignano.snotify.atlassian.gui.templates.handler.impl.InputHandler;
import net.savignano.snotify.atlassian.gui.templates.handler.impl.PasswordHandler;
import net.savignano.snotify.atlassian.gui.templates.handler.impl.RadioHandler;
import net.savignano.snotify.atlassian.gui.templates.handler.impl.StringInputToLongWrapperHandler;
import net.savignano.snotify.atlassian.gui.templates.handler.impl.ValueHandlerWrapper;
import net.savignano.snotify.confluence.gui.action.SnotifyAdminSettingsAction;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnotifyKeystoreSettingsAction
extends SnotifyAdminSettingsAction
implements IValueHandlerProvider {
    private static final long serialVersionUID = -5678110155207254030L;
    private static final String SMIME_PUBLIC_KEYSTORE_LOCATION_ID = "smimePublicKeystoreLocation";
    private static final String SMIME_PUBLIC_KEYSTORE_TYPE_ID = "smimePublicKeystoreType";
    private static final String PGP_PUBLIC_KEYSTORE_LOCATION_ID = "pgpPublicKeystoreLocation";
    private static final String PGP_PUBLIC_KEYSERVER_LOCATION_ID = "pgpPublicKeyserverLocation";
    private static final String ALLOW_PGP_PUBLIC_KEY_OVERWRITE_ID = "allowPublicPgpKeyOverwrite";
    private static final String ALLOW_SMIME_CERTIFICATE_OVERWRITE_ID = "allowPublicSmimeCertOverwrite";
    private static final String USE_SMIME_PUBLIC_USER_DIRECTORY_ID = "smimePublicUserDirectory";
    private static final String SMIME_PUBLIC_LDAP_HOST_ID = "smimePublicLdapHost";
    private static final String SMIME_PUBLIC_LDAP_PORT_ID = "smimePublicLdapPort";
    private static final String SMIME_PUBLIC_LDAP_SSL_ID = "smimePublicLdapSsl";
    private static final String SMIME_PUBLIC_LDAP_DN_ID = "smimePublicLdapDn";
    private static final String SMIME_PUBLIC_LDAP_FILTER_ID = "smimePublicLdapFilter";
    private static final String SMIME_PUBLIC_LDAP_USER_ID = "smimePublicLdapUser";
    private static final String SMIME_PUBLIC_LDAP_PASSWORD_ID = "smimePublicLdapPassword";
    private static final String VERIFY_PGP_BUTTON_PARAM = "Test settings pgp";
    private static final String VERIFY_SMIME_BUTTON_PARAM = "Test settings smime";
    private static final String CLEAR_CACHE_PGP_BUTTON_PARAM = "Clear Cache pgp";
    private static final String CLEAR_CACHE_SMIME_PARAM = "Clear Cache smime";
    private static final String SUBMIT_PGP_BUTTON_PARAM = "Update pgp";
    private static final String SUBMIT_SMIME_BUTTON_PARAM = "Update smime";
    private static final Logger log = LoggerFactory.getLogger(SnotifyKeystoreSettingsAction.class);
    private ValueHandlerWrapper valueWrapper;
    private String verifyMessage;
    private boolean expireKeys;
    private EEncryptionTypePriority typePriority;
    private ECryptographyType lastSubmit;

    public String doInput() {
        if (!this.hasAdminRights()) {
            ConfluenceUser user = this.getAuthenticatedUser();
            log.warn("Unauthorized access to view global S/Notify values from user: {}", (Object)(user != null ? user.getFullName() : "<Unknown User>"));
            return "error";
        }
        this.createValueHandlers();
        this.valueWrapper.read();
        return "input";
    }

    public String doSubmit() {
        HttpServletRequest request = this.getCurrentRequest();
        if (!"POST".equals(request.getMethod())) {
            log.debug("Access to submit method redirected to input method, as request method wasn't 'POST'. Used method: " + request.getMethod());
            return this.doInput();
        }
        if (!this.hasAdminRights()) {
            ConfluenceUser user = this.getAuthenticatedUser();
            log.warn("Unauthorized access to submit global S/Notify values from user: {}", (Object)(user != null ? user.getFullName() : "<Unknown User>"));
            return "error";
        }
        this.createValueHandlers();
        this.valueWrapper.receive(request);
        this.clearCache();
        if (request.getParameter(SUBMIT_PGP_BUTTON_PARAM) != null) {
            this.lastSubmit = ECryptographyType.PGP;
            this.storeSettings();
            return "input";
        }
        if (request.getParameter(SUBMIT_SMIME_BUTTON_PARAM) != null) {
            this.lastSubmit = ECryptographyType.SMIME;
            this.storeSettings();
            return "input";
        }
        if (request.getParameter(VERIFY_PGP_BUTTON_PARAM) != null) {
            this.lastSubmit = ECryptographyType.PGP;
            this.verifySettings(this.valueWrapper);
            return "input";
        }
        if (request.getParameter(VERIFY_SMIME_BUTTON_PARAM) != null) {
            this.lastSubmit = ECryptographyType.SMIME;
            this.verifySettings(this.valueWrapper);
            return "input";
        }
        if (request.getParameter(CLEAR_CACHE_PGP_BUTTON_PARAM) != null) {
            this.lastSubmit = ECryptographyType.PGP;
            this.expireKeys = true;
            return "input";
        }
        if (request.getParameter(CLEAR_CACHE_SMIME_PARAM) != null) {
            this.lastSubmit = ECryptographyType.SMIME;
            this.expireKeys = true;
            return "input";
        }
        log.error("Unknown submit option used.");
        return "input";
    }

    private void createValueHandlers() {
        if (this.valueWrapper != null) {
            return;
        }
        this.valueWrapper = new ValueHandlerWrapper();
        this.valueWrapper.add(new InputHandler(SMIME_PUBLIC_KEYSTORE_LOCATION_ID, this.getAppProps(), EProperty.PUBLIC_KEYSTORE_SMIME_LOCATION));
        this.valueWrapper.add(new RadioHandler(SMIME_PUBLIC_KEYSTORE_TYPE_ID, this.getAppProps(), EProperty.PUBLIC_KEYSTORE_SMIME_TYPE));
        this.valueWrapper.add(new CheckBoxHandler(USE_SMIME_PUBLIC_USER_DIRECTORY_ID, this.getAppProps(), EProperty.USER_DIRECTORY_LDAP_QUERY_SMIME));
        this.valueWrapper.add(new CheckBoxHandler(ALLOW_SMIME_CERTIFICATE_OVERWRITE_ID, this.getAppProps(), EProperty.ALLOW_SMIME_CERTIFICATE_OVERWRITE));
        this.valueWrapper.add(new InputHandler(PGP_PUBLIC_KEYSTORE_LOCATION_ID, this.getAppProps(), EProperty.PUBLIC_KEYSTORE_PGP_LOCATION));
        this.valueWrapper.add(new InputHandler(PGP_PUBLIC_KEYSERVER_LOCATION_ID, this.getAppProps(), EProperty.PUBLIC_KEYSERVER_PGP_LOCATION));
        this.valueWrapper.add(new CheckBoxHandler(ALLOW_PGP_PUBLIC_KEY_OVERWRITE_ID, this.getAppProps(), EProperty.ALLOW_PGP_PUBLIC_KEY_OVERWRITE));
        this.valueWrapper.add(new InputHandler(SMIME_PUBLIC_LDAP_HOST_ID, this.getAppProps(), EProperty.PUBLIC_LDAP_HOST_SMIME));
        this.valueWrapper.add(new StringInputToLongWrapperHandler(SMIME_PUBLIC_LDAP_PORT_ID, this.getAppProps(), EProperty.PUBLIC_LDAP_PORT_SMIME));
        this.valueWrapper.add(new CheckBoxHandler(SMIME_PUBLIC_LDAP_SSL_ID, this.getAppProps(), EProperty.PUBLIC_LDAP_SSL_SMIME));
        this.valueWrapper.add(new InputHandler(SMIME_PUBLIC_LDAP_DN_ID, this.getAppProps(), EProperty.PUBLIC_LDAP_DN_SMIME));
        this.valueWrapper.add(new InputHandler(SMIME_PUBLIC_LDAP_FILTER_ID, this.getAppProps(), EProperty.PUBLIC_LDAP_FILTER_SMIME));
        this.valueWrapper.add(new InputHandler(SMIME_PUBLIC_LDAP_USER_ID, this.getAppProps(), EProperty.PUBLIC_LDAP_LOGIN_USER_SMIME));
        this.valueWrapper.add(new PasswordHandler(SMIME_PUBLIC_LDAP_PASSWORD_ID, (ASnotifyAppProperties)this.getAppProps(), EProperty.PUBLIC_LDAP_LOGIN_PASSWORD_SMIME));
    }

    private void storeSettings() {
        this.valueWrapper.store();
        this.setShowUpdated(true);
    }

    private void verifySettings(IValueHandlerProvider provider) {
        String pgpKeyServerLocation;
        String pgpKeyStoreLocation;
        this.expireKeys = false;
        ArrayList<VerificationStatus> statusList = new ArrayList<VerificationStatus>();
        String smimeKeyStoreLocation = (String)provider.getValue(SMIME_PUBLIC_KEYSTORE_LOCATION_ID);
        if (StringUtils.isNotBlank((String)smimeKeyStoreLocation)) {
            String keyStoreType = (String)provider.getValue(SMIME_PUBLIC_KEYSTORE_TYPE_ID);
            statusList.addAll(this.verifySmimePublicKeystore(smimeKeyStoreLocation, keyStoreType));
        }
        if (provider.getValue(SMIME_PUBLIC_LDAP_HOST_ID) != null) {
            LdapConnector connector = new LdapConnector();
            Long port = ((StringInputToLongWrapperHandler)provider.getValueHandler(SMIME_PUBLIC_LDAP_PORT_ID)).asLong();
            if (port != null) {
                connector.setPort(port.intValue());
            }
            connector.setHost((String)provider.getValue(SMIME_PUBLIC_LDAP_HOST_ID));
            connector.setSsl((Boolean)provider.getValue(SMIME_PUBLIC_LDAP_SSL_ID));
            connector.setDn((String)provider.getValue(SMIME_PUBLIC_LDAP_DN_ID));
            connector.setFilter((String)provider.getValue(SMIME_PUBLIC_LDAP_FILTER_ID));
            connector.setLoginUser((String)provider.getValue(SMIME_PUBLIC_LDAP_USER_ID));
            connector.setLoginPassword((char[])provider.getValue(SMIME_PUBLIC_LDAP_PASSWORD_ID));
            statusList.addAll(this.verifySmimePublicLdap(connector));
        }
        if (((Boolean)provider.getValue(USE_SMIME_PUBLIC_USER_DIRECTORY_ID)).booleanValue()) {
            statusList.addAll(this.verifySmimePublicUserDirectory());
        }
        if (StringUtils.isNotBlank((String)(pgpKeyStoreLocation = (String)provider.getValue(PGP_PUBLIC_KEYSTORE_LOCATION_ID)))) {
            statusList.addAll(this.verifyPgpPublicKeystore(pgpKeyStoreLocation));
        }
        if (StringUtils.isNotBlank((String)(pgpKeyServerLocation = (String)provider.getValue(PGP_PUBLIC_KEYSERVER_LOCATION_ID)))) {
            statusList.addAll(this.verifyPgpPublicKeyserver(pgpKeyServerLocation));
        }
        StringBuilder builder = new StringBuilder(512 * statusList.size());
        for (VerificationStatus status : statusList) {
            builder.append(status.getHtmlStatus());
        }
        this.verifyMessage = builder.toString();
    }

    private List<VerificationStatus> verifySmimePublicKeystore(String smimePublicKeystoreLocation, String smimePublicKeystoreType) {
        log.info("Verifying S/MIME public key store at location: {}", (Object)smimePublicKeystoreLocation);
        String email = this.getAuthenticatedUser().getEmail();
        ISnotifyI18n i18n = this.getSnotifyI18n();
        switch (smimePublicKeystoreType) {
            case "BKS": {
                SmimeKeyStoreVerification ksVerification = new SmimeKeyStoreVerification(smimePublicKeystoreLocation, smimePublicKeystoreType, i18n);
                if (email != null) {
                    ksVerification.getEmails().add(email);
                }
                return ksVerification.verify();
            }
            case "PKCS7": {
                SmimeP7bVerification p7bVerification = new SmimeP7bVerification(smimePublicKeystoreLocation, i18n);
                if (email != null) {
                    p7bVerification.getEmails().add(email);
                }
                return p7bVerification.verify();
            }
        }
        log.error("Unknown key store type encountered: {}", (Object)smimePublicKeystoreType);
        VerificationStatus status = new VerificationStatus();
        status.status = EVerificationStatus.ERROR;
        status.title = i18n.getText("snotify-keystore-settings-webwork.input.smime.public.keystore.verification.typeError.title");
        status.message = i18n.getText("snotify-keystore-settings-webwork.input.smime.public.keystore.verification.typeError.message", (Object)smimePublicKeystoreType);
        return Collections.singletonList(status);
    }

    private List<VerificationStatus> verifyPgpPublicKeystore(String pgpPublicKeystoreLocation) {
        log.info("Verifying PGP public key store at location: {}", (Object)pgpPublicKeystoreLocation);
        String email = this.getAuthenticatedUser().getEmail();
        ISnotifyI18n i18n = this.getSnotifyI18n();
        PgpPublicKeyStoreVerification verification = new PgpPublicKeyStoreVerification(pgpPublicKeystoreLocation, i18n);
        verification.setEmail(email);
        return verification.verify();
    }

    private List<VerificationStatus> verifyPgpPublicKeyserver(String pgpPublicKeyserverLocation) {
        AKeySourceVerification verification;
        URI uri;
        log.info("Verifying PGP public key server at location: {}", (Object)pgpPublicKeyserverLocation);
        String email = this.getAuthenticatedUser().getEmail();
        ISnotifyI18n i18n = this.getSnotifyI18n();
        try {
            uri = new URI(pgpPublicKeyserverLocation);
        }
        catch (URISyntaxException e) {
            log.debug("Given url was not valid: {}", (Object)pgpPublicKeyserverLocation);
            VerificationStatus status = new VerificationStatus();
            status.status = EVerificationStatus.ERROR;
            status.title = i18n.getText("snotify-keystore-settings-webwork.input.smime.public.keyserver.verification.invalidUrl.title");
            status.message = i18n.getText("snotify-keystore-settings-webwork.input.smime.public.keyserver.verification.invalid.message", (Object)pgpPublicKeyserverLocation);
            return Collections.singletonList(status);
        }
        if (uri.getScheme() != null && uri.getScheme().startsWith("ldap")) {
            LdapConnector connector = new LdapConnector();
            connector.setHost(uri.getHost());
            connector.setPort(uri.getPort());
            connector.setSsl(uri.getScheme().equals("ldaps"));
            PgpGlobalDirectoryLoader loader = new PgpGlobalDirectoryLoader(connector, email);
            verification = new PgpGlobalDirectoryVerification(loader, i18n);
        } else {
            PgpKeyServerLoader loader = new PgpKeyServerLoader(pgpPublicKeyserverLocation, email);
            verification = new PgpKeyServerVerification(loader, i18n);
        }
        return verification.verify();
    }

    private List<VerificationStatus> verifySmimePublicUserDirectory() {
        AtlassianLdapConnector connector;
        Directory directory;
        log.info("Verifying user directory for S/MIME public certificates.");
        ISnotifyI18n i18n = this.getSnotifyI18n();
        com.atlassian.crowd.embedded.api.User user = this.getCrowdUser((User)this.getAuthenticatedUser());
        if (user == null) {
            log.debug("Could not find a crowd user for user: {}", (Object)this.getAuthenticatedUser());
            VerificationStatus status = new VerificationStatus();
            status.status = EVerificationStatus.WARNING;
            status.title = i18n.getText("snotify-keystore-settings-webwork.input.smime.public.directory.verification.dirUserNotFound.title");
            status.message = i18n.getText("snotify-keystore-settings-webwork.input.smime.public.directory.verification.dirUserNotFound.message", (Object)this.getAuthenticatedUser());
            return Collections.singletonList(status);
        }
        long directoryId = user.getDirectoryId();
        String userName = user.getName();
        DirectoryManager manager = (DirectoryManager)ComponentLocator.getComponent(DirectoryManager.class);
        try {
            directory = manager.findDirectoryById(directoryId);
        }
        catch (DirectoryNotFoundException e) {
            log.error("Could not find directory with ID " + directoryId + ". Error message: " + e.getMessage(), (Throwable)e);
            VerificationStatus status = new VerificationStatus();
            status.status = EVerificationStatus.ERROR;
            status.title = i18n.getText("snotify-keystore-settings-webwork.input.smime.public.directory.verification.dirNotFound.title");
            status.message = i18n.getText("snotify-keystore-settings-webwork.input.smime.public.directory.verification.dirNotFound.message", (Object)directoryId, (Object)e.getMessage());
            return Collections.singletonList(status);
        }
        if (!AtlassianLdapConnector.isConnector(directory)) {
            log.debug("Directory {} is probably not an LDAP directory.", (Object)directory.getName());
            VerificationStatus status = new VerificationStatus();
            status.status = EVerificationStatus.WARNING;
            status.title = i18n.getText("snotify-keystore-settings-webwork.input.smime.public.directory.verification.dirNotLdap.title");
            status.message = i18n.getText("snotify-keystore-settings-webwork.input.smime.public.directory.verification.dirNotLdap.message", (Object)directory.getName(), (Object)userName);
            return Collections.singletonList(status);
        }
        try {
            connector = AtlassianLdapConnector.createConnector(directory);
        }
        catch (ConfigurationException e) {
            log.error("Could not create an LDAP connection from directory " + directory.getName() + ". Error message: " + e.getMessage());
            VerificationStatus status = new VerificationStatus();
            status.status = EVerificationStatus.ERROR;
            status.title = i18n.getText("snotify-keystore-settings-webwork.input.smime.public.directory.verification.dirError.title");
            status.message = i18n.getText("snotify-keystore-settings-webwork.input.smime.public.directory.verification.dirError.message", (Object)e.getMessage());
            return Collections.singletonList(status);
        }
        String userFilter = "(" + connector.getUserNameKey() + "=" + userName + ")";
        SmimeLdapLoader loader = new SmimeLdapLoader(connector, userFilter);
        loader.setKeySource(EKeySource.LDAP);
        loader.setEmail(user.getEmailAddress());
        loader.setExpectP7b(this.getAppProps().getBoolean(EProperty.TWEAK_EXPECT_P7B_IN_LDAP));
        SmimeLdapVerification verification = new SmimeLdapVerification(loader, i18n);
        verification.setUserNotFoundStatus(EVerificationStatus.ERROR);
        return verification.verify();
    }

    private List<VerificationStatus> verifySmimePublicLdap(LdapConnector connector) {
        log.info("Verifying LDAP configuration for S/MIME public certificates.");
        String email = this.getAuthenticatedUser().getEmail();
        SmimeLdapLoader loader = new SmimeLdapLoader(connector, "(mail=" + email + ")");
        loader.setEmail(email);
        SmimeLdapVerification verification = new SmimeLdapVerification(loader, this.getSnotifyI18n());
        return verification.verify();
    }

    private com.atlassian.crowd.embedded.api.User getCrowdUser(User user) {
        if (user instanceof com.atlassian.crowd.embedded.api.User) {
            return (com.atlassian.crowd.embedded.api.User)user;
        }
        if (user instanceof ConfluenceUserImpl) {
            return this.getCrowdUser(((ConfluenceUserImpl)user).getBackingUser());
        }
        return null;
    }

    private void clearCache() {
        this.getAppProps().setLong(EProperty.EXPIRE_KEYS_PUBLIC_TIMESTAMP, System.currentTimeMillis());
    }

    private EEncryptionTypePriority getTypePriority() {
        if (this.typePriority == null) {
            this.typePriority = this.getAppProps().getEnum(EProperty.ENCRYPTION_TYPE_PRIORITY, EEncryptionTypePriority.class);
        }
        return this.typePriority;
    }

    @Override
    public <T> IValueHandler<T> getValueHandler(String id) {
        return this.valueWrapper.getValueHandler(id);
    }

    public boolean isSmimeSelected() {
        if (this.lastSubmit == ECryptographyType.SMIME) {
            return true;
        }
        if (this.lastSubmit == ECryptographyType.PGP) {
            return false;
        }
        switch (this.getTypePriority()) {
            case SMIME_ONLY: 
            case SMIME_PREFERED: {
                return true;
            }
            case PGP_ONLY: 
            case PGP_PREFERED: {
                return false;
            }
        }
        log.error("Type priority not yet implemented: {}", (Object)this.getTypePriority());
        return false;
    }

    public boolean isPgpSelected() {
        if (this.lastSubmit == ECryptographyType.PGP) {
            return true;
        }
        if (this.lastSubmit == ECryptographyType.SMIME) {
            return false;
        }
        switch (this.getTypePriority()) {
            case SMIME_ONLY: 
            case SMIME_PREFERED: {
                return false;
            }
            case PGP_ONLY: 
            case PGP_PREFERED: {
                return true;
            }
        }
        log.error("Type priority not yet implemented: {}", (Object)this.getTypePriority());
        return false;
    }

    public boolean isShowExpireCacheInfo() {
        return this.expireKeys;
    }

    public boolean isShowLeavingPageWarning() {
        return this.verifyMessage != null;
    }

    @HtmlSafe
    public String getVerificationMessage() {
        return this.verifyMessage == null ? "" : this.verifyMessage;
    }
}

