/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.confluence.gui.action;

import com.atlassian.confluence.api.service.exceptions.ReadOnlyException;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.user.actions.AbstractUserProfileAction;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.user.User;
import com.atlassian.velocity.htmlsafe.HtmlSafe;
import com.atlassian.xwork.FileUploadUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.security.KeyException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Locale;
import net.savignano.snotify.atlassian.common.EProperty;
import net.savignano.snotify.atlassian.common.ISnotifyAppProperties;
import net.savignano.snotify.atlassian.common.ISnotifyI18n;
import net.savignano.snotify.atlassian.common.ISnotifyUserProperties;
import net.savignano.snotify.atlassian.common.enums.ECryptographyType;
import net.savignano.snotify.atlassian.common.enums.EEncryptionTypePriority;
import net.savignano.snotify.atlassian.common.enums.EKeySource;
import net.savignano.snotify.atlassian.common.security.key.publicly.SnotifyPgpPublicKey;
import net.savignano.snotify.atlassian.common.util.PgpUtil;
import net.savignano.snotify.atlassian.common.util.SmimeUtil;
import net.savignano.snotify.atlassian.gui.key.info.PgpPublicKeyInfoBuilder;
import net.savignano.snotify.atlassian.gui.key.info.SmimeCertInfoBuilder;
import net.savignano.snotify.confluence.common.ConfluenceUser;
import net.savignano.snotify.confluence.common.SnotifyAppProperties;
import net.savignano.snotify.confluence.common.SnotifyI18n;
import net.savignano.snotify.confluence.common.SnotifyUserProperties;
import net.savignano.snotify.confluence.gui.key.info.HtmlKeyValueStyle;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPException;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKeyRing;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnotifyUserSettingsAction
extends AbstractUserProfileAction {
    private static final long serialVersionUID = -6230532372976632611L;
    private static final String ERROR_EMAIL_MISMATCH = "error-email";
    private static final String ERROR_EXPIRED = "error-expired";
    private static final String ERROR_KEYNOTFOUND = "error-keynotfound";
    private static final String ERROR_NOFILE = "error-nofile";
    private static final String ERROR_NOTYETVALID = "error-notyetvalid";
    private static final String ERROR_PGP = "error-pgp";
    private static final String ERROR_SMIME = "error-smime";
    private static final String DELETE_BUTTON_PARAM = "Delete";
    private static final Logger log = LoggerFactory.getLogger(SnotifyUserSettingsAction.class);
    private final ISnotifyAppProperties appProps = new SnotifyAppProperties();
    private final ISnotifyUserProperties userProps = new SnotifyUserProperties();
    private ISnotifyI18n i18n;
    private Exception lastException;
    private EEncryptionTypePriority typePriority;
    private ECryptographyType lastUpload;
    private Boolean allowSmimeUpload;
    private Boolean allowPgpUpload;

    public String doInput() {
        com.atlassian.confluence.user.ConfluenceUser user = this.getAuthenticatedUser();
        if (user == null) {
            return null;
        }
        this.lastUpload = null;
        return "input";
    }

    public String doSubmitSmime() {
        byte[] certData;
        if (!"POST".equals(this.getCurrentRequest().getMethod())) {
            log.debug("Access to submit method redirected to input method, as request method wasn't 'POST'. Used method: " + this.getCurrentRequest().getMethod());
            return this.doInput();
        }
        com.atlassian.confluence.user.ConfluenceUser authUser = this.getAuthenticatedUser();
        if (authUser == null) {
            log.warn("User is not authenticated for uploading custom S/MIME certificate.");
            return null;
        }
        if (!this.isAllowSmimeUpload()) {
            if (this.isReadOnlyMode()) {
                throw new ReadOnlyException(this.i18NBeanFactory.getI18NBean().getText("read.only.mode.default.banner.message"));
            }
            log.warn("Uploading of custom S/MIME certificate is not allowed. User: {}", (Object)authUser);
            return this.doInput();
        }
        this.lastUpload = ECryptographyType.SMIME;
        if (this.getCurrentRequest().getParameterMap().containsKey(DELETE_BUTTON_PARAM)) {
            certData = null;
        } else {
            try {
                certData = this.readUploadedFile();
                if (certData == null || certData.length == 0) {
                    return ERROR_NOFILE;
                }
            }
            catch (IOException e) {
                this.lastException = e;
                log.info("Uploaded file could not be read.", (Throwable)e);
                return "error";
            }
        }
        ConfluenceUser user = new ConfluenceUser((User)authUser);
        try {
            this.setEmailCert(certData, user);
            return "success";
        }
        catch (EmailException e) {
            this.lastException = e;
            log.info("Email address mismatch.", (Throwable)e);
            return ERROR_EMAIL_MISMATCH;
        }
        catch (CertificateExpiredException e) {
            this.lastException = e;
            log.info("Certificate expired.", (Throwable)e);
            return ERROR_EXPIRED;
        }
        catch (CertificateNotYetValidException e) {
            this.lastException = e;
            log.info("Certificate not yet valid.", (Throwable)e);
            return ERROR_NOTYETVALID;
        }
        catch (CertificateException e) {
            this.lastException = e;
            log.info("Certificate parsing failed.", (Throwable)e);
            return ERROR_SMIME;
        }
    }

    public String doSubmitPgp() {
        byte[] keyData;
        if (!"POST".equals(this.getCurrentRequest().getMethod())) {
            log.debug("Access to submit method redirected to input method, as request method wasn't 'POST'. Used method: " + this.getCurrentRequest().getMethod());
            return this.doInput();
        }
        com.atlassian.confluence.user.ConfluenceUser authUser = this.getAuthenticatedUser();
        if (authUser == null) {
            log.warn("User is not authenticated for uploading custom PGP key.");
            return null;
        }
        if (!this.isAllowPgpUpload()) {
            if (this.isReadOnlyMode()) {
                throw new ReadOnlyException(this.i18NBeanFactory.getI18NBean().getText("read.only.mode.default.banner.message"));
            }
            log.warn("Uploading of custom PGP key is not allowed. User: {}", (Object)authUser);
            return null;
        }
        this.lastUpload = ECryptographyType.PGP;
        if (this.getCurrentRequest().getParameterMap().containsKey(DELETE_BUTTON_PARAM)) {
            keyData = null;
        } else {
            try {
                keyData = this.readUploadedFile();
                if (keyData == null || keyData.length == 0) {
                    return ERROR_NOFILE;
                }
            }
            catch (IOException e) {
                this.lastException = e;
                log.info("Uploaded file could not be read.", (Throwable)e);
                return "error";
            }
        }
        ConfluenceUser user = new ConfluenceUser((User)authUser);
        try {
            this.setEmailPgpKey(keyData, user);
            return "success";
        }
        catch (PGPException e) {
            this.lastException = e;
            log.info("Key parsing failed.", (Throwable)e);
            return ERROR_PGP;
        }
        catch (KeyException e) {
            this.lastException = e;
            log.info("No valid key found.", (Throwable)e);
            return ERROR_KEYNOTFOUND;
        }
    }

    private byte[] readUploadedFile() throws IOException {
        File uploadedFile;
        try {
            uploadedFile = FileUploadUtils.getSingleFile();
            if (uploadedFile == null) {
                return null;
            }
        }
        catch (FileUploadUtils.FileUploadException e) {
            throw new IOException(e.getMessage(), e);
        }
        return Files.readAllBytes(uploadedFile.toPath());
    }

    private void setEmailCert(byte[] cert, ConfluenceUser user) throws CertificateException {
        if (cert == null || cert.length == 0) {
            log.debug("Clearing certificate for user: " + user.getDisplayName());
            this.userProps.setBytes(EProperty.EMAIL_SMIME_CERT, null, user);
            this.userProps.setLong(EProperty.EMAIL_SMIME_TIME_STAMP, null, user);
            this.userProps.setEnum(EProperty.EMAIL_SMIME_KEY_SOURCE, null, user);
        } else {
            log.debug("Checking certificate for user: " + user.getDisplayName());
            this.checkSmimeCert(cert, user);
            log.debug("Setting certificate for user: " + user.getDisplayName());
            this.userProps.setBytes(EProperty.EMAIL_SMIME_CERT, cert, user);
            this.userProps.setLong(EProperty.EMAIL_SMIME_TIME_STAMP, System.currentTimeMillis(), user);
            this.userProps.setEnum(EProperty.EMAIL_SMIME_KEY_SOURCE, EKeySource.USER, user);
        }
    }

    private void checkSmimeCert(byte[] cert, ConfluenceUser user) throws CertificateException, CertificateExpiredException, CertificateNotYetValidException, CertificateEncodingException, CertificateParsingException, EmailException {
        CertificateFactory fact = CertificateFactory.getInstance("X.509");
        X509Certificate certificate = (X509Certificate)fact.generateCertificate(new ByteArrayInputStream(cert));
        certificate.checkValidity();
        String certEmail = StringUtils.join((Object[])SmimeUtil.getEmails(certificate), (String)", ").toLowerCase();
        if (!certEmail.contains(user.getEmail().toLowerCase())) {
            throw new EmailException(certEmail, user.getDisplayName());
        }
    }

    private void setEmailPgpKey(byte[] key, ConfluenceUser user) throws PGPException, KeyException {
        if (key == null || key.length == 0) {
            log.info("Clearing PGP key for user: {}", (Object)user.getDisplayName());
            this.userProps.setBytes(EProperty.EMAIL_PGP_KEY, null, user);
            this.userProps.setLong(EProperty.EMAIL_PGP_KEY_ID, null, user);
            this.userProps.setLong(EProperty.EMAIL_PGP_TIME_STAMP, null, user);
            this.userProps.setEnum(EProperty.EMAIL_PGP_KEY_SOURCE, null, user);
        } else {
            log.debug("Checking PGP key for user: {}", (Object)user.getDisplayName());
            SnotifyPgpPublicKey pubKey = this.loadPgpKey(key, user);
            log.info("Setting PGP key for user: {}", (Object)user.getDisplayName());
            this.userProps.setBytes(EProperty.EMAIL_PGP_KEY, key, user);
            this.userProps.setLong(EProperty.EMAIL_PGP_KEY_ID, pubKey.getKey().getKeyID(), user);
            this.userProps.setLong(EProperty.EMAIL_PGP_TIME_STAMP, System.currentTimeMillis(), user);
            this.userProps.setEnum(EProperty.EMAIL_PGP_KEY_SOURCE, EKeySource.USER, user);
        }
    }

    private SnotifyPgpPublicKey loadPgpKey(byte[] key, ConfluenceUser user) throws PGPException, KeyException {
        PGPPublicKeyRingCollection keyRings;
        String userEmailAddress = user.getEmail().toLowerCase();
        try {
            keyRings = PgpUtil.loadPublicKeys(new ByteArrayInputStream(key));
        }
        catch (IOException e) {
            throw new KeyException("Could not read stream", e);
        }
        PGPPublicKeyRing keyRing = PgpUtil.getKeysForEmail(keyRings, userEmailAddress);
        if (keyRing == null) {
            throw new KeyException("Could not find a key ring for email address: " + userEmailAddress);
        }
        SnotifyPgpPublicKey pubKey = new SnotifyPgpPublicKey(keyRing, userEmailAddress);
        if (!pubKey.isValid()) {
            throw new KeyException("Could not find a valid encryption key.");
        }
        return pubKey;
    }

    private String buildCertInfo(byte[] cert, ConfluenceUser user) throws CertificateException {
        SmimeCertInfoBuilder builder = new SmimeCertInfoBuilder(cert, this.getSnotifyI18n());
        builder.setUser(user);
        builder.setUserProps(this.userProps);
        return builder.build(new HtmlKeyValueStyle());
    }

    private String buildKeyInfo(byte[] key, long keyId, ConfluenceUser user) throws IOException, PGPException {
        PgpPublicKeyInfoBuilder builder = new PgpPublicKeyInfoBuilder(key, keyId, this.getSnotifyI18n());
        builder.setUser(user);
        builder.setUserProps(this.userProps);
        return builder.build(new HtmlKeyValueStyle());
    }

    private ISnotifyI18n getSnotifyI18n() {
        if (this.i18n == null) {
            LocaleManager localeManager = (LocaleManager)ComponentLocator.getComponent(LocaleManager.class);
            Locale locale = localeManager.getLocale((User)this.getAuthenticatedUser());
            this.i18n = new SnotifyI18n(this.getI18n(), locale);
        }
        return this.i18n;
    }

    public String getErrorMessage() {
        return this.lastException == null ? null : this.lastException.getMessage();
    }

    @HtmlSafe
    public String getCertDetails() {
        ConfluenceUser user = new ConfluenceUser((User)this.getUser());
        Object cert = this.appProps.getBoolean(EProperty.LITE_MODE) && this.userProps.getEnum(EProperty.EMAIL_SMIME_KEY_SOURCE, EKeySource.class, user) != EKeySource.USER ? null : this.userProps.getBytes(EProperty.EMAIL_SMIME_CERT, user);
        String info = null;
        if (cert == null) {
            info = this.getText("snotify-user-settings-webwork.input.smime.notfound");
            log.debug("No certificate specified for user: {}", (Object)user.getDisplayName());
        } else {
            try {
                info = this.buildCertInfo((byte[])cert, user);
                log.debug("Certificate information for user {}: {}", (Object)user.getDisplayName(), (Object)info);
            }
            catch (CertificateException e) {
                log.warn("Could not load public certificate for user: " + user.getDisplayName(), (Throwable)e);
                info = this.getText("snotify-user-settings-webwork.input.smime.error", new String[]{e.getLocalizedMessage()});
            }
        }
        return info;
    }

    @HtmlSafe
    public String getPgpDetails() {
        Long keyId;
        byte[] key;
        ConfluenceUser user = new ConfluenceUser((User)this.getUser());
        if (this.appProps.getBoolean(EProperty.LITE_MODE) && this.userProps.getEnum(EProperty.EMAIL_PGP_KEY_SOURCE, EKeySource.class, user) != EKeySource.USER) {
            key = null;
            keyId = null;
        } else {
            key = this.userProps.getBytes(EProperty.EMAIL_PGP_KEY, user);
            keyId = this.userProps.getLong(EProperty.EMAIL_PGP_KEY_ID, user);
        }
        String info = null;
        if (key == null || keyId == null) {
            info = this.getText("snotify-user-settings-webwork.input.pgp.notfound");
            log.debug("No certificate specified for user: {}", (Object)user.getDisplayName());
        } else {
            try {
                info = this.buildKeyInfo(key, keyId, user);
                log.debug("Key information for user {}: {}", (Object)user.getDisplayName(), (Object)info);
            }
            catch (IOException | PGPException e) {
                log.warn("Could not load PGP key for user: " + user.getDisplayName(), (Throwable)e);
                info = this.getText("snotify-user-settings-webwork.input.pgp.error", e.getLocalizedMessage());
            }
        }
        return info;
    }

    public boolean isChoiceEnabled() {
        switch (this.getTypePriority()) {
            case SMIME_PREFERED: 
            case PGP_PREFERED: {
                return true;
            }
            case SMIME_ONLY: 
            case PGP_ONLY: {
                return false;
            }
        }
        log.warn("Unknwon value for 'Encryption Type Priority' found. Value found was '" + (Object)((Object)this.getTypePriority()) + "'. It is not yet implemented,");
        return true;
    }

    public boolean isSmimeSelected() {
        if (this.lastUpload == ECryptographyType.SMIME) {
            return true;
        }
        if (this.lastUpload == ECryptographyType.PGP) {
            return false;
        }
        switch (this.getTypePriority()) {
            case SMIME_ONLY: {
                return true;
            }
            case PGP_ONLY: {
                return false;
            }
            case SMIME_PREFERED: {
                return this.isAllowSmimeUpload() || !this.isAllowPgpUpload();
            }
            case PGP_PREFERED: {
                return this.isAllowSmimeUpload() && !this.isAllowPgpUpload();
            }
        }
        log.warn("Unknwon value for 'Encryption Type Priority' found. Value found was '" + (Object)((Object)this.getTypePriority()) + "'. It is not yet implemented,");
        return true;
    }

    public boolean isPgpSelected() {
        if (this.lastUpload == ECryptographyType.PGP) {
            return true;
        }
        if (this.lastUpload == ECryptographyType.SMIME) {
            return false;
        }
        switch (this.getTypePriority()) {
            case SMIME_ONLY: {
                return false;
            }
            case PGP_ONLY: {
                return true;
            }
            case SMIME_PREFERED: {
                return this.isAllowPgpUpload() && !this.isAllowSmimeUpload();
            }
            case PGP_PREFERED: {
                return this.isAllowPgpUpload() || !this.isAllowSmimeUpload();
            }
        }
        log.warn("Unknwon value for 'Encryption Type Priority' found. Value found was '" + (Object)((Object)this.getTypePriority()) + "'. It is not yet implemented,");
        return false;
    }

    public boolean isSmimeUploadAllowed() {
        return this.isAllowSmimeUpload() && (this.isChoiceEnabled() || this.isSmimeSelected()) && !this.isReadOnlyMode();
    }

    public boolean isPgpUploadAllowed() {
        return this.isAllowPgpUpload() && (this.isChoiceEnabled() || this.isPgpSelected()) && !this.isReadOnlyMode();
    }

    public boolean showMultipleUsersError() {
        return (this.isAllowSmimeUpload() || this.isAllowPgpUpload()) && ConfluenceUser.lookupUsers(this.getAuthenticatedUser().getEmail()).size() > 1;
    }

    private EEncryptionTypePriority getTypePriority() {
        if (this.typePriority == null) {
            this.typePriority = this.appProps.getEnum(EProperty.ENCRYPTION_TYPE_PRIORITY, EEncryptionTypePriority.class);
        }
        return this.typePriority;
    }

    private boolean isReadOnlyMode() {
        return this.accessModeService.isReadOnlyAccessModeEnabled();
    }

    private boolean isAllowSmimeUpload() {
        if (this.allowSmimeUpload == null) {
            this.allowSmimeUpload = this.appProps.getBoolean(EProperty.ALLOW_SMIME_CERTIFICATE_OVERWRITE) || this.appProps.getBoolean(EProperty.LITE_MODE);
        }
        return this.allowSmimeUpload;
    }

    private boolean isAllowPgpUpload() {
        if (this.allowPgpUpload == null) {
            this.allowPgpUpload = this.appProps.getBoolean(EProperty.ALLOW_PGP_PUBLIC_KEY_OVERWRITE) || this.appProps.getBoolean(EProperty.LITE_MODE);
        }
        return this.allowPgpUpload;
    }

    private static final class EmailException
    extends CertificateException {
        private static final long serialVersionUID = -5262905856665194L;

        private EmailException(String email, String user) {
            super("Email address(es) of certificate (" + email + ") do not match email of user: " + user);
        }
    }
}

