/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.crypto.util;

import java.io.IOException;
import java.math.BigInteger;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1EncodableVector;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Integer;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Sequence;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1TaggedObject;
import net.savignano.thirdparty.org.bouncycastle.asn1.DERSequence;
import net.savignano.thirdparty.org.bouncycastle.asn1.nist.NISTNamedCurves;
import net.savignano.thirdparty.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import net.savignano.thirdparty.org.bouncycastle.asn1.pkcs.RSAPrivateKey;
import net.savignano.thirdparty.org.bouncycastle.asn1.sec.ECPrivateKey;
import net.savignano.thirdparty.org.bouncycastle.asn1.x9.ECNamedCurveTable;
import net.savignano.thirdparty.org.bouncycastle.asn1.x9.X9ECParameters;
import net.savignano.thirdparty.org.bouncycastle.crypto.CryptoServicesRegistrar;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.DSAParameters;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.DSAPrivateKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.ECDomainParameters;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.ECNamedDomainParameters;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.Ed25519PrivateKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.Ed25519PublicKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.crypto.util.OpenSSHPublicKeyUtil;
import net.savignano.thirdparty.org.bouncycastle.crypto.util.PrivateKeyInfoFactory;
import net.savignano.thirdparty.org.bouncycastle.crypto.util.SSHBuffer;
import net.savignano.thirdparty.org.bouncycastle.crypto.util.SSHBuilder;
import net.savignano.thirdparty.org.bouncycastle.crypto.util.SSHNamedCurves;
import net.savignano.thirdparty.org.bouncycastle.util.Arrays;
import net.savignano.thirdparty.org.bouncycastle.util.BigIntegers;
import net.savignano.thirdparty.org.bouncycastle.util.Strings;

public class OpenSSHPrivateKeyUtil {
    static final byte[] AUTH_MAGIC = Strings.toByteArray("openssh-key-v1\u0000");

    private OpenSSHPrivateKeyUtil() {
    }

    public static byte[] encodePrivateKey(AsymmetricKeyParameter params) throws IOException {
        if (params == null) {
            throw new IllegalArgumentException("param is null");
        }
        if (params instanceof RSAPrivateCrtKeyParameters) {
            PrivateKeyInfo pInfo = PrivateKeyInfoFactory.createPrivateKeyInfo(params);
            return pInfo.parsePrivateKey().toASN1Primitive().getEncoded();
        }
        if (params instanceof ECPrivateKeyParameters) {
            PrivateKeyInfo pInfo = PrivateKeyInfoFactory.createPrivateKeyInfo(params);
            return pInfo.parsePrivateKey().toASN1Primitive().getEncoded();
        }
        if (params instanceof DSAPrivateKeyParameters) {
            DSAPrivateKeyParameters dsaPrivKey = (DSAPrivateKeyParameters)params;
            DSAParameters dsaParams = dsaPrivKey.getParameters();
            ASN1EncodableVector vec = new ASN1EncodableVector();
            vec.add(new ASN1Integer(0L));
            vec.add(new ASN1Integer(dsaParams.getP()));
            vec.add(new ASN1Integer(dsaParams.getQ()));
            vec.add(new ASN1Integer(dsaParams.getG()));
            BigInteger pubKey = dsaParams.getG().modPow(dsaPrivKey.getX(), dsaParams.getP());
            vec.add(new ASN1Integer(pubKey));
            vec.add(new ASN1Integer(dsaPrivKey.getX()));
            try {
                return new DERSequence(vec).getEncoded();
            }
            catch (Exception ex) {
                throw new IllegalStateException("unable to encode DSAPrivateKeyParameters " + ex.getMessage());
            }
        }
        if (params instanceof Ed25519PrivateKeyParameters) {
            Ed25519PublicKeyParameters publicKeyParameters = ((Ed25519PrivateKeyParameters)params).generatePublicKey();
            SSHBuilder builder = new SSHBuilder();
            builder.writeBytes(AUTH_MAGIC);
            builder.writeString("none");
            builder.writeString("none");
            builder.writeString("");
            builder.u32(1);
            byte[] pkEncoded = OpenSSHPublicKeyUtil.encodePublicKey(publicKeyParameters);
            builder.writeBlock(pkEncoded);
            SSHBuilder pkBuild = new SSHBuilder();
            int checkint = CryptoServicesRegistrar.getSecureRandom().nextInt();
            pkBuild.u32(checkint);
            pkBuild.u32(checkint);
            pkBuild.writeString("ssh-ed25519");
            byte[] pubKeyEncoded = publicKeyParameters.getEncoded();
            pkBuild.writeBlock(pubKeyEncoded);
            pkBuild.writeBlock(Arrays.concatenate(((Ed25519PrivateKeyParameters)params).getEncoded(), pubKeyEncoded));
            pkBuild.writeString("");
            builder.writeBlock(pkBuild.getPaddedBytes());
            return builder.getBytes();
        }
        throw new IllegalArgumentException("unable to convert " + params.getClass().getName() + " to openssh private key");
    }

    public static AsymmetricKeyParameter parsePrivateKeyBlob(byte[] blob) {
        AsymmetricKeyParameter result = null;
        if (blob[0] == 48) {
            ASN1Sequence sequence = ASN1Sequence.getInstance(blob);
            if (sequence.size() == 6) {
                if (OpenSSHPrivateKeyUtil.allIntegers(sequence) && ((ASN1Integer)sequence.getObjectAt(0)).getPositiveValue().equals(BigIntegers.ZERO)) {
                    result = new DSAPrivateKeyParameters(((ASN1Integer)sequence.getObjectAt(5)).getPositiveValue(), new DSAParameters(((ASN1Integer)sequence.getObjectAt(1)).getPositiveValue(), ((ASN1Integer)sequence.getObjectAt(2)).getPositiveValue(), ((ASN1Integer)sequence.getObjectAt(3)).getPositiveValue()));
                }
            } else if (sequence.size() == 9) {
                if (OpenSSHPrivateKeyUtil.allIntegers(sequence) && ((ASN1Integer)sequence.getObjectAt(0)).getPositiveValue().equals(BigIntegers.ZERO)) {
                    RSAPrivateKey rsaPrivateKey = RSAPrivateKey.getInstance(sequence);
                    result = new RSAPrivateCrtKeyParameters(rsaPrivateKey.getModulus(), rsaPrivateKey.getPublicExponent(), rsaPrivateKey.getPrivateExponent(), rsaPrivateKey.getPrime1(), rsaPrivateKey.getPrime2(), rsaPrivateKey.getExponent1(), rsaPrivateKey.getExponent2(), rsaPrivateKey.getCoefficient());
                }
            } else if (sequence.size() == 4 && sequence.getObjectAt(3) instanceof ASN1TaggedObject && sequence.getObjectAt(2) instanceof ASN1TaggedObject) {
                ECPrivateKey ecPrivateKey = ECPrivateKey.getInstance(sequence);
                ASN1ObjectIdentifier curveOID = ASN1ObjectIdentifier.getInstance(ecPrivateKey.getParametersObject());
                X9ECParameters x9Params = ECNamedCurveTable.getByOID(curveOID);
                result = new ECPrivateKeyParameters(ecPrivateKey.getKey(), (ECDomainParameters)new ECNamedDomainParameters(curveOID, x9Params));
            }
        } else {
            int check2;
            SSHBuffer kIn = new SSHBuffer(AUTH_MAGIC, blob);
            String cipherName = kIn.readString();
            if (!"none".equals(cipherName)) {
                throw new IllegalStateException("encrypted keys not supported");
            }
            kIn.skipBlock();
            kIn.skipBlock();
            int publicKeyCount = kIn.readU32();
            if (publicKeyCount != 1) {
                throw new IllegalStateException("multiple keys not supported");
            }
            OpenSSHPublicKeyUtil.parsePublicKey(kIn.readBlock());
            byte[] privateKeyBlock = kIn.readPaddedBlock();
            if (kIn.hasRemaining()) {
                throw new IllegalArgumentException("decoded key has trailing data");
            }
            SSHBuffer pkIn = new SSHBuffer(privateKeyBlock);
            int check1 = pkIn.readU32();
            if (check1 != (check2 = pkIn.readU32())) {
                throw new IllegalStateException("private key check values are not the same");
            }
            String keyType = pkIn.readString();
            if ("ssh-ed25519".equals(keyType)) {
                pkIn.readBlock();
                byte[] edPrivateKey = pkIn.readBlock();
                if (edPrivateKey.length != 64) {
                    throw new IllegalStateException("private key value of wrong length");
                }
                result = new Ed25519PrivateKeyParameters(edPrivateKey, 0);
            } else if (keyType.startsWith("ecdsa")) {
                ASN1ObjectIdentifier oid = SSHNamedCurves.getByName(Strings.fromByteArray(pkIn.readBlock()));
                if (oid == null) {
                    throw new IllegalStateException("OID not found for: " + keyType);
                }
                X9ECParameters curveParams = NISTNamedCurves.getByOID(oid);
                if (curveParams == null) {
                    throw new IllegalStateException("Curve not found for: " + oid);
                }
                pkIn.readBlock();
                byte[] privKey = pkIn.readBlock();
                result = new ECPrivateKeyParameters(new BigInteger(1, privKey), (ECDomainParameters)new ECNamedDomainParameters(oid, curveParams));
            }
            pkIn.skipBlock();
            if (pkIn.hasRemaining()) {
                throw new IllegalArgumentException("private key block has trailing data");
            }
        }
        if (result == null) {
            throw new IllegalArgumentException("unable to parse key");
        }
        return result;
    }

    private static boolean allIntegers(ASN1Sequence sequence) {
        for (int t = 0; t < sequence.size(); ++t) {
            if (sequence.getObjectAt(t) instanceof ASN1Integer) continue;
            return false;
        }
        return true;
    }
}

