/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.its;

import java.io.IOException;
import java.io.OutputStream;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import net.savignano.thirdparty.org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import net.savignano.thirdparty.org.bouncycastle.asn1.sec.SECObjectIdentifiers;
import net.savignano.thirdparty.org.bouncycastle.asn1.teletrust.TeleTrusTObjectIdentifiers;
import net.savignano.thirdparty.org.bouncycastle.its.ITSCertificate;
import net.savignano.thirdparty.org.bouncycastle.its.ITSCertificateBuilder;
import net.savignano.thirdparty.org.bouncycastle.its.ITSPublicEncryptionKey;
import net.savignano.thirdparty.org.bouncycastle.its.ITSPublicVerificationKey;
import net.savignano.thirdparty.org.bouncycastle.its.operator.ECDSAEncoder;
import net.savignano.thirdparty.org.bouncycastle.its.operator.ITSContentSigner;
import net.savignano.thirdparty.org.bouncycastle.oer.OEREncoder;
import net.savignano.thirdparty.org.bouncycastle.oer.its.Certificate;
import net.savignano.thirdparty.org.bouncycastle.oer.its.CertificateBase;
import net.savignano.thirdparty.org.bouncycastle.oer.its.CertificateId;
import net.savignano.thirdparty.org.bouncycastle.oer.its.CertificateType;
import net.savignano.thirdparty.org.bouncycastle.oer.its.HashAlgorithm;
import net.savignano.thirdparty.org.bouncycastle.oer.its.HashedId;
import net.savignano.thirdparty.org.bouncycastle.oer.its.IssuerIdentifier;
import net.savignano.thirdparty.org.bouncycastle.oer.its.Signature;
import net.savignano.thirdparty.org.bouncycastle.oer.its.ToBeSignedCertificate;
import net.savignano.thirdparty.org.bouncycastle.oer.its.VerificationKeyIndicator;
import net.savignano.thirdparty.org.bouncycastle.oer.its.template.IEEE1609dot2;
import net.savignano.thirdparty.org.bouncycastle.util.Arrays;

public class ITSExplicitCertificateBuilder
extends ITSCertificateBuilder {
    private final ITSContentSigner signer;

    public ITSExplicitCertificateBuilder(ITSContentSigner signer, ToBeSignedCertificate.Builder tbsCertificate) {
        super(tbsCertificate);
        this.signer = signer;
    }

    public ITSCertificate build(CertificateId certificateId, ITSPublicVerificationKey verificationKey) {
        return this.build(certificateId, verificationKey, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ITSCertificate build(CertificateId certificateId, ITSPublicVerificationKey verificationKey, ITSPublicEncryptionKey publicEncryptionKey) {
        VerificationKeyIndicator verificationKeyIndicator;
        ToBeSignedCertificate.Builder tbsBldr = new ToBeSignedCertificate.Builder(this.tbsCertificateBuilder);
        tbsBldr.setCertificateId(certificateId);
        if (publicEncryptionKey != null) {
            tbsBldr.setEncryptionKey(publicEncryptionKey.toASN1Structure());
        }
        tbsBldr.setVerificationKeyIndicator(VerificationKeyIndicator.builder().publicVerificationKey(verificationKey.toASN1Structure()).createVerificationKeyIndicator());
        ToBeSignedCertificate tbsCertificate = tbsBldr.createToBeSignedCertificate();
        ToBeSignedCertificate signerCert = null;
        if (this.signer.isForSelfSigning()) {
            verificationKeyIndicator = tbsCertificate.getVerificationKeyIndicator();
        } else {
            signerCert = this.signer.getAssociatedCertificate().toASN1Structure().getCertificateBase().getToBeSignedCertificate();
            verificationKeyIndicator = signerCert.getVerificationKeyIndicator();
        }
        OutputStream sOut = this.signer.getOutputStream();
        try {
            sOut.write(OEREncoder.toByteArray(tbsCertificate, IEEE1609dot2.tbsCertificate));
            sOut.close();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("cannot produce certificate signature");
        }
        Signature sig = null;
        switch (verificationKeyIndicator.getChoice()) {
            case 0: {
                sig = ECDSAEncoder.toITS(SECObjectIdentifiers.secp256r1, this.signer.getSignature());
                break;
            }
            case 1: {
                sig = ECDSAEncoder.toITS(TeleTrusTObjectIdentifiers.brainpoolP256r1, this.signer.getSignature());
                break;
            }
            case 3: {
                sig = ECDSAEncoder.toITS(TeleTrusTObjectIdentifiers.brainpoolP384r1, this.signer.getSignature());
                break;
            }
            default: {
                throw new IllegalStateException("unknown key type");
            }
        }
        CertificateBase.Builder baseBldr = new CertificateBase.Builder();
        IssuerIdentifier.Builder issuerIdentifierBuilder = IssuerIdentifier.builder();
        ASN1ObjectIdentifier digestAlg = this.signer.getDigestAlgorithm().getAlgorithm();
        if (this.signer.isForSelfSigning()) {
            if (digestAlg.equals(NISTObjectIdentifiers.id_sha256)) {
                issuerIdentifierBuilder.self(HashAlgorithm.sha256);
            } else {
                if (!digestAlg.equals(NISTObjectIdentifiers.id_sha384)) throw new IllegalStateException("unknown digest");
                issuerIdentifierBuilder.self(HashAlgorithm.sha384);
            }
        } else {
            byte[] parentDigest = this.signer.getAssociatedCertificateDigest();
            HashedId.HashedId8 hashedID = new HashedId.HashedId8(Arrays.copyOfRange(parentDigest, parentDigest.length - 8, parentDigest.length));
            if (digestAlg.equals(NISTObjectIdentifiers.id_sha256)) {
                issuerIdentifierBuilder.sha256AndDigest(hashedID);
            } else {
                if (!digestAlg.equals(NISTObjectIdentifiers.id_sha384)) throw new IllegalStateException("unknown digest");
                issuerIdentifierBuilder.sha384AndDigest(hashedID);
            }
        }
        baseBldr.setVersion(this.version);
        baseBldr.setType(CertificateType.Explicit);
        baseBldr.setIssuer(issuerIdentifierBuilder.createIssuerIdentifier());
        baseBldr.setToBeSignedCertificate(tbsCertificate);
        baseBldr.setSignature(sig);
        Certificate.Builder bldr = new Certificate.Builder();
        bldr.setCertificateBase(baseBldr.createCertificateBase());
        return new ITSCertificate(bldr.createCertificate());
    }
}

