/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.jcajce.provider.digest;

import net.savignano.thirdparty.org.bouncycastle.asn1.iso.ISOIECObjectIdentifiers;
import net.savignano.thirdparty.org.bouncycastle.crypto.CipherKeyGenerator;
import net.savignano.thirdparty.org.bouncycastle.crypto.digests.WhirlpoolDigest;
import net.savignano.thirdparty.org.bouncycastle.crypto.macs.HMac;
import net.savignano.thirdparty.org.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import net.savignano.thirdparty.org.bouncycastle.jcajce.provider.digest.BCMessageDigest;
import net.savignano.thirdparty.org.bouncycastle.jcajce.provider.digest.DigestAlgorithmProvider;
import net.savignano.thirdparty.org.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import net.savignano.thirdparty.org.bouncycastle.jcajce.provider.symmetric.util.BaseMac;

public class Whirlpool {
    private Whirlpool() {
    }

    public static class Mappings
    extends DigestAlgorithmProvider {
        private static final String PREFIX = Whirlpool.class.getName();

        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithm("MessageDigest.WHIRLPOOL", PREFIX + "$Digest");
            provider.addAlgorithm("MessageDigest", ISOIECObjectIdentifiers.whirlpool, PREFIX + "$Digest");
            this.addHMACAlgorithm(provider, "WHIRLPOOL", PREFIX + "$HashMac", PREFIX + "$KeyGenerator");
        }
    }

    public static class KeyGenerator
    extends BaseKeyGenerator {
        public KeyGenerator() {
            super("HMACWHIRLPOOL", 512, new CipherKeyGenerator());
        }
    }

    public static class HashMac
    extends BaseMac {
        public HashMac() {
            super(new HMac(new WhirlpoolDigest()));
        }
    }

    public static class Digest
    extends BCMessageDigest
    implements Cloneable {
        public Digest() {
            super(new WhirlpoolDigest());
        }

        public Object clone() throws CloneNotSupportedException {
            Digest d = (Digest)super.clone();
            d.digest = new WhirlpoolDigest((WhirlpoolDigest)this.digest);
            return d;
        }
    }
}

