/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.jsse.provider;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import javax.net.ssl.X509TrustManager;
import net.savignano.thirdparty.org.bouncycastle.jcajce.util.JcaJceHelper;
import net.savignano.thirdparty.org.bouncycastle.jsse.BCX509ExtendedTrustManager;
import net.savignano.thirdparty.org.bouncycastle.jsse.provider.ExportX509TrustManager;
import net.savignano.thirdparty.org.bouncycastle.jsse.provider.ExportX509TrustManager_5;
import net.savignano.thirdparty.org.bouncycastle.jsse.provider.ImportX509TrustManager;
import net.savignano.thirdparty.org.bouncycastle.jsse.provider.ImportX509TrustManager_5;
import net.savignano.thirdparty.org.bouncycastle.jsse.provider.ReflectionUtil;

abstract class X509TrustManagerUtil {
    private static final Class<?> x509ExtendedTrustManagerClass;
    private static final Constructor<? extends X509TrustManager> exportX509TrustManagerConstructor;
    private static final Constructor<? extends BCX509ExtendedTrustManager> importX509TrustManagerConstructor;

    X509TrustManagerUtil() {
    }

    static X509TrustManager exportX509TrustManager(BCX509ExtendedTrustManager x509TrustManager) {
        if (x509TrustManager instanceof ImportX509TrustManager) {
            return ((ImportX509TrustManager)((Object)x509TrustManager)).unwrap();
        }
        if (null != exportX509TrustManagerConstructor) {
            try {
                return exportX509TrustManagerConstructor.newInstance(x509TrustManager);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new ExportX509TrustManager_5(x509TrustManager);
    }

    static BCX509ExtendedTrustManager importX509TrustManager(boolean isInFipsMode, JcaJceHelper helper, X509TrustManager x509TrustManager) {
        if (x509TrustManager instanceof BCX509ExtendedTrustManager) {
            return (BCX509ExtendedTrustManager)x509TrustManager;
        }
        if (x509TrustManager instanceof ExportX509TrustManager) {
            return ((ExportX509TrustManager)((Object)x509TrustManager)).unwrap();
        }
        if (null != importX509TrustManagerConstructor && x509ExtendedTrustManagerClass.isInstance(x509TrustManager)) {
            try {
                return importX509TrustManagerConstructor.newInstance(x509TrustManager);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new ImportX509TrustManager_5(isInFipsMode, helper, x509TrustManager);
    }

    static {
        Class<?> clazz = null;
        try {
            clazz = ReflectionUtil.getClass("javax.net.ssl.X509ExtendedTrustManager");
        }
        catch (Exception exception) {
            // empty catch block
        }
        x509ExtendedTrustManagerClass = clazz;
        Constructor constructor = null;
        try {
            Method[] methods = ReflectionUtil.getMethods("javax.net.ssl.X509ExtendedTrustManager");
            if (null != methods) {
                String className = "net.savignano.thirdparty.org.bouncycastle.jsse.provider.ExportX509TrustManager_7";
                constructor = ReflectionUtil.getDeclaredConstructor(className, BCX509ExtendedTrustManager.class);
            }
        }
        catch (Exception methods) {
            // empty catch block
        }
        exportX509TrustManagerConstructor = constructor;
        constructor = null;
        if (null != x509ExtendedTrustManagerClass) {
            try {
                String className = "net.savignano.thirdparty.org.bouncycastle.jsse.provider.ImportX509TrustManager_7";
                constructor = ReflectionUtil.getDeclaredConstructor(className, x509ExtendedTrustManagerClass);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        importX509TrustManagerConstructor = constructor;
    }
}

