/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.oer;

import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.math.BigInteger;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Encodable;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1EncodableVector;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Enumerated;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Integer;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Object;
import net.savignano.thirdparty.org.bouncycastle.asn1.DERBitString;
import net.savignano.thirdparty.org.bouncycastle.asn1.DERNull;
import net.savignano.thirdparty.org.bouncycastle.asn1.DEROctetString;
import net.savignano.thirdparty.org.bouncycastle.asn1.DERSequence;
import net.savignano.thirdparty.org.bouncycastle.asn1.DERTaggedObject;
import net.savignano.thirdparty.org.bouncycastle.asn1.DERUTF8String;
import net.savignano.thirdparty.org.bouncycastle.oer.OERDefinition;
import net.savignano.thirdparty.org.bouncycastle.oer.OEROptional;
import net.savignano.thirdparty.org.bouncycastle.util.BigIntegers;
import net.savignano.thirdparty.org.bouncycastle.util.Pack;
import net.savignano.thirdparty.org.bouncycastle.util.Strings;
import net.savignano.thirdparty.org.bouncycastle.util.encoders.Hex;
import net.savignano.thirdparty.org.bouncycastle.util.io.Streams;

public class OERInputStream
extends FilterInputStream {
    private static final int[] bits = new int[]{1, 2, 4, 8, 16, 32, 64, 128};
    private int maxByteAllocation = 0x100000;
    protected PrintWriter debugOutput = null;

    public OERInputStream(InputStream src) {
        super(src);
    }

    public OERInputStream(InputStream src, int maxByteAllocation) {
        super(src);
        this.maxByteAllocation = maxByteAllocation;
    }

    private int countOptionalChildTypes(OERDefinition.Element element) {
        int optionalElements = 0;
        for (OERDefinition.Element e : element.children) {
            optionalElements += e.explicit ? 0 : 1;
        }
        return optionalElements;
    }

    /*
     * Unable to fully structure code
     */
    public ASN1Object parse(OERDefinition.Element element) throws Exception {
        switch (1.$SwitchMap$net$savignano$thirdparty$org$bouncycastle$oer$OERDefinition$BaseType[element.baseType.ordinal()]) {
            case 1: {
                l = LengthInfo.access$000(this.readLength());
                lenEnc = this.allocateArray(l);
                if (Streams.readFully(this, lenEnc) != lenEnc.length) {
                    throw new IOException("could not read all of count of seq-of values");
                }
                j = BigIntegers.fromUnsignedByteArray(lenEnc).intValue();
                this.debugPrint(element.appendLabel("(len = " + j + ")"));
                avec = new ASN1EncodableVector();
                for (n = 0; n < j; ++n) {
                    avec.add(this.parse(element.children.get(0)));
                }
                return new DERSequence(avec);
            }
            case 2: {
                sequence = this.sequence(this.countOptionalChildTypes(element), element.hasDefaultChildren(), element.extensionsInDefinition);
                this.debugPrint(element.appendLabel(sequence.toString()));
                avec = new ASN1EncodableVector();
                for (t = 0; t < element.children.size(); ++t) {
                    child = element.children.get(t);
                    if (child.explicit) {
                        avec.add(this.parse(child));
                        continue;
                    }
                    if (sequence.hasOptional(element.optionalOrDefaultChildrenInOrder().indexOf(child))) {
                        avec.add(OEROptional.getInstance(this.parse(child)));
                        continue;
                    }
                    if (child.getDefaultValue() != null) {
                        avec.add(child.defaultValue);
                        this.debugPrint("Using default.");
                        continue;
                    }
                    avec.add(this.absent(child));
                }
                return new DERSequence(avec);
            }
            case 3: {
                choice = this.choice();
                this.debugPrint(element.appendLabel(choice.toString()));
                if (choice.isContextSpecific()) {
                    item = element.children.get(choice.getTag());
                    return new DERTaggedObject(choice.tag, this.parse(element.children.get(choice.getTag())));
                }
                if (choice.isApplicationTagClass()) {
                    throw new IllegalStateException("Unimplemented tag type");
                }
                if (choice.isPrivateTagClass()) {
                    throw new IllegalStateException("Unimplemented tag type");
                }
                if (choice.isUniversalTagClass()) {
                    choice.getTag();
                } else {
                    throw new IllegalStateException("Unimplemented tag type");
                }
            }
            case 4: {
                bi = this.enumeration();
                this.debugPrint(element.appendLabel("ENUM(" + bi + ") = " + element.children.get((int)bi.intValue()).label));
                return new ASN1Enumerated(bi);
            }
            case 5: {
                bytesToRead = element.intBytesForRange();
                if (bytesToRead == 0) ** GOTO lbl73
                data = this.allocateArray(Math.abs(bytesToRead));
                Streams.readFully(this, data);
                switch (data.length) {
                    case 1: {
                        bi = BigInteger.valueOf(data[0]);
                        ** GOTO lbl85
                    }
                    case 2: {
                        bi = BigInteger.valueOf(Pack.bigEndianToShort(data, 0));
                        ** GOTO lbl85
                    }
                    case 4: {
                        bi = BigInteger.valueOf(Pack.bigEndianToInt(data, 0));
                        ** GOTO lbl85
                    }
                    case 8: {
                        bi = BigInteger.valueOf(Pack.bigEndianToLong(data, 0));
                        ** GOTO lbl85
                    }
                    default: {
                        throw new IllegalStateException("Unknown size");
                    }
                }
lbl73:
                // 1 sources

                if (element.isLowerRangeZero()) {
                    lengthInfo = this.readLength();
                    data = this.allocateArray(LengthInfo.access$000(lengthInfo));
                    Streams.readFully(this, data);
                    bi = data.length == 0 ? BigInteger.ZERO : BigIntegers.fromUnsignedByteArray(data);
                } else {
                    lengthInfo = this.readLength();
                    data = this.allocateArray(LengthInfo.access$000(lengthInfo));
                    Streams.readFully(this, data);
                    bi = data.length == 0 ? BigInteger.ZERO : new BigInteger(data);
                }
lbl85:
                // 6 sources

                if (this.debugOutput != null) {
                    this.debugPrint(element.appendLabel("INTEGER(" + data.length + " " + bi.toString(16) + ")"));
                }
                return new ASN1Integer(bi);
            }
            case 6: {
                readSize = 0;
                readSize = element.upperBound != null && element.upperBound.equals(element.lowerBound) != false ? element.upperBound.intValue() : LengthInfo.access$000(this.readLength());
                data = this.allocateArray(readSize);
                if (Streams.readFully(this, data) != readSize) {
                    throw new IOException("did not read all of " + element.label);
                }
                if (this.debugOutput != null) {
                    this.debugPrint(element.appendLabel("OCTET STRING (" + data.length + ") = " + Hex.toHexString(data, 0, Math.min(data.length, 32))));
                }
                return new DEROctetString(data);
            }
            case 7: {
                data = this.allocateArray(LengthInfo.access$000(this.readLength()));
                if (Streams.readFully(this, data) != data.length) {
                    throw new IOException("could not read all of utf 8 string");
                }
                content = Strings.fromUTF8ByteArray(data);
                if (this.debugOutput != null) {
                    this.debugPrint(element.appendLabel("UTF8 String (" + data.length + ") = " + content));
                }
                return new DERUTF8String(content);
            }
            case 8: {
                data = element.isFixedLength() != false ? new byte[element.lowerBound.intValue() / 8] : (BigInteger.ZERO.compareTo(element.upperBound) > 0 ? this.allocateArray(element.upperBound.intValue() / 8) : this.allocateArray(LengthInfo.access$000(this.readLength()) / 8));
                Streams.readFully(this, data);
                if (this.debugOutput != null) {
                    sb = new StringBuffer();
                    sb.append("BIT STRING(" + data.length * 8 + ") = ");
                    for (i = 0; i != data.length; ++i) {
                        b = data[i];
                        for (t = 0; t < 8; ++t) {
                            sb.append((b & 128) > 0 ? "1" : "0");
                            b = (byte)(b << 1);
                        }
                    }
                    this.debugPrint(element.appendLabel(sb.toString()));
                }
                return new DERBitString(data);
            }
            case 9: {
                this.debugPrint(element.appendLabel("NULL"));
                return DERNull.INSTANCE;
            }
            case 10: {
                li = this.readLength();
                value = new byte[LengthInfo.access$000(li)];
                if (Streams.readFully(this, value) != LengthInfo.access$000(li)) {
                    throw new IOException("could not read all of count of open value in choice (...) ");
                }
                this.debugPrint("ext " + LengthInfo.access$000(li) + " " + Hex.toHexString(value));
                return new DEROctetString(value);
            }
        }
        throw new IllegalStateException("Unhandled type " + (Object)element.baseType);
    }

    private ASN1Encodable absent(OERDefinition.Element child) {
        this.debugPrint(child.appendLabel("Absent"));
        return OEROptional.ABSENT;
    }

    private byte[] allocateArray(int requiredSize) {
        if (requiredSize > this.maxByteAllocation) {
            throw new IllegalArgumentException("required byte array size " + requiredSize + " was greater than " + this.maxByteAllocation);
        }
        return new byte[requiredSize];
    }

    public BigInteger parseInt(boolean unsigned, int size) throws Exception {
        byte[] buf = new byte[size];
        int read = Streams.readFully(this, buf);
        if (read != buf.length) {
            throw new IllegalStateException("integer not fully read");
        }
        return unsigned ? new BigInteger(1, buf) : new BigInteger(buf);
    }

    public BigInteger uint8() throws Exception {
        return this.parseInt(true, 1);
    }

    public BigInteger uint16() throws Exception {
        return this.parseInt(true, 2);
    }

    public BigInteger uint32() throws Exception {
        return this.parseInt(true, 4);
    }

    public BigInteger uint64() throws Exception {
        return this.parseInt(false, 8);
    }

    public BigInteger int8() throws Exception {
        return this.parseInt(false, 1);
    }

    public BigInteger int16() throws Exception {
        return this.parseInt(false, 2);
    }

    public BigInteger int32() throws Exception {
        return this.parseInt(false, 4);
    }

    public BigInteger int64() throws Exception {
        return this.parseInt(false, 8);
    }

    public LengthInfo readLength() throws Exception {
        boolean accumulator = false;
        int byteVal = this.read();
        if (byteVal == -1) {
            throw new EOFException("expecting length");
        }
        if ((byteVal & 0x80) == 0) {
            return new LengthInfo(BigInteger.valueOf(byteVal & 0x7F), true);
        }
        byte[] lengthInt = new byte[byteVal & 0x7F];
        if (Streams.readFully(this, lengthInt) != lengthInt.length) {
            throw new EOFException("did not read all bytes of length definition");
        }
        String k = Hex.toHexString(lengthInt);
        return new LengthInfo(BigIntegers.fromUnsignedByteArray(lengthInt), false);
    }

    public BigInteger enumeration() throws Exception {
        int first = this.read();
        if (first == -1) {
            throw new EOFException("expecting prefix of enumeration");
        }
        if ((first & 0x80) == 128) {
            int l = first & 0x7F;
            if (l == 0) {
                return BigInteger.ZERO;
            }
            byte[] buf = new byte[l];
            int i = Streams.readFully(this, buf);
            if (i != buf.length) {
                throw new EOFException("unable to fully read integer component of enumeration");
            }
            return new BigInteger(1, buf);
        }
        return BigInteger.valueOf(first);
    }

    public Sequence sequence(int expectedOptional, boolean hasOptionalChildren, boolean hasExtension) throws Exception {
        return new Sequence(this, expectedOptional, hasOptionalChildren, hasExtension);
    }

    public Choice choice() throws Exception {
        return new Choice(this);
    }

    protected void debugPrint(String what) {
        if (this.debugOutput != null) {
            StackTraceElement[] callStack = Thread.currentThread().getStackTrace();
            int level = -1;
            for (int i = 0; i != callStack.length; ++i) {
                StackTraceElement ste = callStack[i];
                if (ste.getMethodName().equals("debugPrint")) {
                    level = 0;
                    continue;
                }
                if (!ste.getClassName().contains("OERInput")) continue;
                ++level;
            }
            while (level > 0) {
                this.debugOutput.append("    ");
                --level;
            }
            this.debugOutput.append(what).append("\n");
            this.debugOutput.flush();
        }
    }

    public static class Sequence
    extends OERInputStream {
        final int preamble;
        private final boolean[] optionalPresent;
        private final boolean extensionFlagSet;

        public Sequence(InputStream src, int expectedOptional, boolean hasDefaults, boolean extension) throws IOException {
            super(src);
            if (expectedOptional == 0 && !extension && !hasDefaults) {
                this.preamble = 0;
                this.optionalPresent = new boolean[0];
                this.extensionFlagSet = false;
                return;
            }
            this.preamble = src.read();
            if (this.preamble < 0) {
                throw new EOFException("expecting preamble byte of sequence");
            }
            this.extensionFlagSet = extension && (this.preamble & 0x80) == 128;
            int j = extension ? 6 : 7;
            this.optionalPresent = new boolean[expectedOptional];
            int mask = this.preamble;
            for (int t = 0; t < this.optionalPresent.length; ++t) {
                if (j < 0) {
                    mask = src.read();
                    if (mask < 0) {
                        throw new EOFException("expecting mask byte sequence");
                    }
                    j = 7;
                }
                this.optionalPresent[t] = (mask & bits[j]) > 0;
                --j;
            }
        }

        public boolean hasOptional(int index) {
            return this.optionalPresent[index];
        }

        public boolean hasExtension() {
            return this.extensionFlagSet;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("SEQ(");
            sb.append(this.hasExtension() ? "Ext " : "");
            for (int t = 0; t < this.optionalPresent.length; ++t) {
                if (this.optionalPresent[t]) {
                    sb.append("1");
                    continue;
                }
                sb.append("0");
            }
            sb.append(")");
            return sb.toString();
        }
    }

    public static class Choice
    extends OERInputStream {
        final int preamble = this.read();
        final int tag;
        final int tagClass;

        public Choice(InputStream src) throws Exception {
            super(src);
            if (this.preamble < 0) {
                throw new EOFException("expecting preamble byte of choice");
            }
            this.tagClass = this.preamble & 0xC0;
            int tag = this.preamble & 0x3F;
            if (tag >= 63) {
                tag = 0;
                int part = 0;
                do {
                    if ((part = src.read()) < 0) {
                        throw new EOFException("expecting further tag bytes");
                    }
                    tag <<= 7;
                    tag |= part & 0x7F;
                } while ((part & 0x80) != 0);
            }
            this.tag = tag;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("CHOICE(");
            switch (this.tagClass) {
                case 0: {
                    sb.append("Universal ");
                    break;
                }
                case 64: {
                    sb.append("Application ");
                    break;
                }
                case 192: {
                    sb.append("Private ");
                    break;
                }
                case 128: {
                    sb.append("ContextSpecific ");
                }
            }
            sb.append("Tag = " + this.tag);
            sb.append(")");
            return sb.toString();
        }

        public int getTagClass() {
            return this.tagClass;
        }

        public int getTag() {
            return this.tag;
        }

        public boolean isContextSpecific() {
            return this.tagClass == 128;
        }

        public boolean isUniversalTagClass() {
            return this.tagClass == 0;
        }

        public boolean isApplicationTagClass() {
            return this.tagClass == 64;
        }

        public boolean isPrivateTagClass() {
            return this.tagClass == 192;
        }
    }

    private final class LengthInfo {
        private final BigInteger length;
        private final boolean shortForm;

        public LengthInfo(BigInteger length, boolean shortForm) {
            this.length = length;
            this.shortForm = shortForm;
        }

        private int intLength() {
            return this.length.intValue();
        }

        static /* synthetic */ int access$000(LengthInfo x0) {
            return x0.intLength();
        }
    }
}

