/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.oer;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.util.Enumeration;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1ApplicationSpecific;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Boolean;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Encodable;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Enumerated;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Integer;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1OctetString;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Primitive;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Sequence;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Set;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1TaggedObject;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1UTF8String;
import net.savignano.thirdparty.org.bouncycastle.asn1.DERBitString;
import net.savignano.thirdparty.org.bouncycastle.oer.BitBuilder;
import net.savignano.thirdparty.org.bouncycastle.oer.OERDefinition;
import net.savignano.thirdparty.org.bouncycastle.oer.OEROptional;
import net.savignano.thirdparty.org.bouncycastle.util.BigIntegers;
import net.savignano.thirdparty.org.bouncycastle.util.Pack;
import net.savignano.thirdparty.org.bouncycastle.util.Strings;
import net.savignano.thirdparty.org.bouncycastle.util.encoders.Hex;

public class OEROutputStream {
    private final OutputStream out;
    private static final int[] bits = new int[]{1, 2, 4, 8, 16, 32, 64, 128};
    protected PrintWriter debugOutput = null;

    public static OEROutputStream create(OutputStream out) {
        return new OEROutputStream(out);
    }

    OEROutputStream(OutputStream out) {
        this.out = out;
    }

    public void write(ASN1Encodable encodable, OERDefinition.Element oerElement) throws IOException {
        if (encodable == OEROptional.ABSENT) {
            return;
        }
        if (encodable instanceof OEROptional) {
            this.write(((OEROptional)encodable).get(), oerElement);
            return;
        }
        encodable = encodable.toASN1Primitive();
        switch (oerElement.baseType) {
            case SEQ: {
                int t;
                ASN1Sequence seq = ASN1Sequence.getInstance(encodable);
                int j = 7;
                int mask = 0;
                if (oerElement.extensionsInDefinition) {
                    if (oerElement.hasPopulatedExtension()) {
                        mask |= bits[j];
                    }
                    --j;
                }
                for (t = 0; t < oerElement.children.size(); ++t) {
                    OERDefinition.Element childOERDescription = oerElement.children.get(t);
                    if (j < 0) {
                        this.out.write(mask);
                        j = 7;
                        mask = 0;
                    }
                    ASN1Encodable asn1EncodableChild = seq.getObjectAt(t);
                    if (childOERDescription.explicit && asn1EncodableChild instanceof OEROptional) {
                        throw new IllegalStateException("absent sequence element that is required by oer definition");
                    }
                    if (childOERDescription.explicit) continue;
                    ASN1Encodable obj = seq.getObjectAt(t);
                    if (childOERDescription.getDefaultValue() != null) {
                        if (obj instanceof OEROptional) {
                            if (((OEROptional)obj).isDefined() && !((OEROptional)obj).get().equals(childOERDescription.defaultValue)) {
                                mask |= bits[j];
                            }
                        } else if (!childOERDescription.getDefaultValue().equals(obj)) {
                            mask |= bits[j];
                        }
                    } else if (asn1EncodableChild != OEROptional.ABSENT) {
                        mask |= bits[j];
                    }
                    --j;
                }
                if (j != 7) {
                    this.out.write(mask);
                }
                for (t = 0; t < oerElement.children.size(); ++t) {
                    ASN1Encodable child = seq.getObjectAt(t);
                    OERDefinition.Element childOERElement = oerElement.children.get(t);
                    if (childOERElement.getDefaultValue() != null && childOERElement.getDefaultValue().equals(child)) continue;
                    this.write(child, childOERElement);
                }
                this.out.flush();
                this.debugPrint(oerElement.appendLabel(""));
                break;
            }
            case SEQ_OF: {
                Enumeration e;
                if (encodable instanceof ASN1Set) {
                    e = ((ASN1Set)encodable).getObjects();
                    this.encodeQuantity(((ASN1Set)encodable).size());
                } else if (encodable instanceof ASN1Sequence) {
                    e = ((ASN1Sequence)encodable).getObjects();
                    this.encodeQuantity(((ASN1Sequence)encodable).size());
                } else {
                    throw new IllegalStateException("encodable at for SEQ_OF is not a container");
                }
                while (e.hasMoreElements()) {
                    Object o = e.nextElement();
                    this.write((ASN1Encodable)o, oerElement.getFirstChid());
                }
                this.out.flush();
                this.debugPrint(oerElement.appendLabel(""));
                break;
            }
            case CHOICE: {
                int tag;
                ASN1Primitive item = encodable.toASN1Primitive();
                BitBuilder bb = new BitBuilder();
                if (item instanceof ASN1ApplicationSpecific) {
                    tag = ((ASN1ApplicationSpecific)item).getApplicationTag();
                    bb.writeBit(0).writeBit(1);
                    item = ((ASN1ApplicationSpecific)item).getEnclosedObject();
                } else if (item instanceof ASN1TaggedObject) {
                    ASN1TaggedObject taggedObject = (ASN1TaggedObject)item;
                    int tagClass = taggedObject.getTagClass();
                    bb.writeBit(tagClass & 0x80).writeBit(tagClass & 0x40);
                    tag = taggedObject.getTagNo();
                    item = taggedObject.getBaseObject().toASN1Primitive();
                } else {
                    throw new IllegalStateException("only support tagged objects");
                }
                if (tag <= 63) {
                    bb.writeBits(tag, 6);
                } else {
                    bb.writeBits(255L, 6);
                    bb.write7BitBytes(tag);
                }
                if (this.debugOutput != null) {
                    if (item instanceof ASN1ApplicationSpecific) {
                        this.debugPrint(oerElement.appendLabel("AS"));
                    } else if (item instanceof ASN1TaggedObject) {
                        this.debugPrint(oerElement.appendLabel("CS"));
                    }
                }
                bb.writeAndClear(this.out);
                this.write(item, oerElement.children.get(tag));
                this.out.flush();
                break;
            }
            case ENUM: {
                BigInteger ordinal = encodable instanceof ASN1Integer ? ASN1Integer.getInstance(encodable).getValue() : ASN1Enumerated.getInstance(encodable).getValue();
                for (OERDefinition.Element child : oerElement.children) {
                    if (!child.enumValue.equals(ordinal)) continue;
                    if (ordinal.compareTo(BigInteger.valueOf(127L)) > 0) {
                        byte[] val = ordinal.toByteArray();
                        int l = 0x80 | val.length & 0xFF;
                        this.out.write(l);
                        this.out.write(val);
                    } else {
                        this.out.write(ordinal.intValue() & 0x7F);
                    }
                    this.out.flush();
                    this.debugPrint(oerElement.appendLabel(oerElement.rangeExpression()));
                    return;
                }
                throw new IllegalArgumentException("enum value " + ordinal + " " + Hex.toHexString(ordinal.toByteArray()) + " no in defined child list");
            }
            case INT: {
                ASN1Integer integer = ASN1Integer.getInstance(encodable);
                int intBytesForRange = oerElement.intBytesForRange();
                if (intBytesForRange > 0) {
                    byte[] encoded = BigIntegers.asUnsignedByteArray(intBytesForRange, integer.getValue());
                    switch (intBytesForRange) {
                        case 1: 
                        case 2: 
                        case 4: 
                        case 8: {
                            this.out.write(encoded);
                            break;
                        }
                        default: {
                            throw new IllegalStateException("unknown uint length " + intBytesForRange);
                        }
                    }
                } else if (intBytesForRange < 0) {
                    byte[] encoded;
                    BigInteger number = integer.getValue();
                    switch (intBytesForRange) {
                        case -1: {
                            encoded = new byte[]{BigIntegers.byteValueExact(number)};
                            break;
                        }
                        case -2: {
                            encoded = Pack.shortToBigEndian(BigIntegers.shortValueExact(number));
                            break;
                        }
                        case -4: {
                            encoded = Pack.intToBigEndian(BigIntegers.intValueExact(number));
                            break;
                        }
                        case -8: {
                            encoded = Pack.longToBigEndian(BigIntegers.longValueExact(number));
                            break;
                        }
                        default: {
                            throw new IllegalStateException("unknown twos compliment length");
                        }
                    }
                    this.out.write(encoded);
                } else {
                    byte[] encoded = oerElement.isLowerRangeZero() ? BigIntegers.asUnsignedByteArray(integer.getValue()) : integer.getValue().toByteArray();
                    this.encodeLength(encoded.length);
                    this.out.write(encoded);
                }
                this.debugPrint(oerElement.appendLabel(oerElement.rangeExpression()));
                this.out.flush();
                break;
            }
            case OCTET_STRING: {
                ASN1OctetString octets = ASN1OctetString.getInstance(encodable);
                byte[] bytes = octets.getOctets();
                if (oerElement.isFixedLength()) {
                    this.out.write(bytes);
                } else {
                    this.encodeLength(bytes.length);
                    this.out.write(bytes);
                }
                this.debugPrint(oerElement.appendLabel(oerElement.rangeExpression()));
                this.out.flush();
                break;
            }
            case UTF8_STRING: {
                ASN1UTF8String utf8 = ASN1UTF8String.getInstance(encodable);
                byte[] encoded = Strings.toUTF8ByteArray(utf8.getString());
                this.encodeLength(encoded.length);
                this.out.write(encoded);
                this.debugPrint(oerElement.appendLabel(""));
                this.out.flush();
                break;
            }
            case BIT_STRING: {
                DERBitString bitString = DERBitString.getInstance(encodable);
                byte[] bytes = bitString.getBytes();
                if (oerElement.isFixedLength()) {
                    this.out.write(bytes);
                    this.debugPrint(oerElement.appendLabel(oerElement.rangeExpression()));
                } else {
                    int padBits = bitString.getPadBits();
                    this.encodeLength(bytes.length + 1);
                    this.out.write(padBits);
                    this.out.write(bytes);
                    this.debugPrint(oerElement.appendLabel(oerElement.rangeExpression()));
                }
                this.out.flush();
                break;
            }
            case NULL: {
                break;
            }
            case EXTENSION: {
                ASN1OctetString octets = ASN1OctetString.getInstance(encodable);
                byte[] bytes = octets.getOctets();
                if (oerElement.isFixedLength()) {
                    this.out.write(bytes);
                } else {
                    this.encodeLength(bytes.length);
                    this.out.write(bytes);
                }
                this.debugPrint(oerElement.appendLabel(oerElement.rangeExpression()));
                this.out.flush();
                break;
            }
            case ENUM_ITEM: {
                break;
            }
            case BOOLEAN: {
                this.debugPrint(oerElement.label);
                ASN1Boolean asn1Boolean = ASN1Boolean.getInstance(encodable);
                if (asn1Boolean.isTrue()) {
                    this.out.write(255);
                } else {
                    this.out.write(0);
                }
                this.out.flush();
            }
        }
    }

    protected void debugPrint(String what) {
        if (this.debugOutput != null) {
            StackTraceElement[] callStack = Thread.currentThread().getStackTrace();
            int level = -1;
            for (int i = 0; i != callStack.length; ++i) {
                StackTraceElement ste = callStack[i];
                if (ste.getMethodName().equals("debugPrint")) {
                    level = 0;
                    continue;
                }
                if (!ste.getClassName().contains("OERInput")) continue;
                ++level;
            }
            while (level > 0) {
                this.debugOutput.append("    ");
                --level;
            }
            this.debugOutput.append(what).append("\n");
            this.debugOutput.flush();
        }
    }

    private void encodeLength(long len) throws IOException {
        if (len <= 127L) {
            this.out.write((int)len);
        } else {
            byte[] value = BigIntegers.asUnsignedByteArray(BigInteger.valueOf(len));
            this.out.write(value.length | 0x80);
            this.out.write(value);
        }
    }

    private void encodeQuantity(long quantity) throws IOException {
        byte[] quantityEncoded = BigIntegers.asUnsignedByteArray(BigInteger.valueOf(quantity));
        this.out.write(quantityEncoded.length);
        this.out.write(quantityEncoded);
    }

    public static int byteLength(long value) {
        int j;
        long m = -72057594037927936L;
        for (j = 8; j > 0 && (value & m) == 0L; --j) {
            value <<= 8;
        }
        return j;
    }
}

