/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.oer.its;

import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Choice;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Encodable;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Object;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Primitive;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1TaggedObject;
import net.savignano.thirdparty.org.bouncycastle.asn1.DEROctetString;
import net.savignano.thirdparty.org.bouncycastle.asn1.DERTaggedObject;
import net.savignano.thirdparty.org.bouncycastle.oer.its.CountryAndRegions;
import net.savignano.thirdparty.org.bouncycastle.oer.its.CountryOnly;
import net.savignano.thirdparty.org.bouncycastle.oer.its.RegionAndSubregions;
import net.savignano.thirdparty.org.bouncycastle.oer.its.RegionInterface;

public class IdentifiedRegion
extends ASN1Object
implements ASN1Choice,
RegionInterface {
    public static final int countryOnly = 0;
    public static final int countryAndRegions = 1;
    public static final int countAndSubregions = 2;
    public static final int extension = 3;
    private int choice;
    private ASN1Encodable region;

    public IdentifiedRegion(int choice, ASN1Encodable region) {
        this.choice = choice;
        this.region = region;
    }

    public static IdentifiedRegion getInstance(Object o) {
        if (o instanceof IdentifiedRegion) {
            return (IdentifiedRegion)o;
        }
        ASN1TaggedObject asn1TaggedObject = ASN1TaggedObject.getInstance(o);
        int choice = asn1TaggedObject.getTagNo();
        o = asn1TaggedObject.getObject();
        switch (choice) {
            case 0: {
                return new IdentifiedRegion(choice, CountryOnly.getInstance(o));
            }
            case 1: {
                return new IdentifiedRegion(choice, CountryAndRegions.getInstance(o));
            }
            case 2: {
                return new IdentifiedRegion(choice, RegionAndSubregions.getInstance(o));
            }
            case 3: {
                return new IdentifiedRegion(choice, DEROctetString.getInstance(o));
            }
        }
        throw new IllegalArgumentException("unknown choice " + choice);
    }

    public ASN1Primitive toASN1Primitive() {
        return new DERTaggedObject(this.choice, (ASN1Object)this.region).toASN1Primitive();
    }
}

