/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.oer.its;

import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1EncodableVector;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Object;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Primitive;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Sequence;
import net.savignano.thirdparty.org.bouncycastle.asn1.DERSequence;
import net.savignano.thirdparty.org.bouncycastle.oer.its.GroupLinkageValue;
import net.savignano.thirdparty.org.bouncycastle.oer.its.IValue;
import net.savignano.thirdparty.org.bouncycastle.oer.its.LinkageValue;

public class LinkageData
extends ASN1Object {
    private final IValue iCert;
    private final LinkageValue linkageValue;
    private final GroupLinkageValue groupLinkageValue;

    private LinkageData(ASN1Sequence seq) {
        if (seq.size() != 2 && seq.size() != 3) {
            throw new IllegalArgumentException("sequence must be size 2 or 3");
        }
        this.iCert = IValue.getInstance(seq.getObjectAt(2));
        this.linkageValue = LinkageValue.getInstance(seq.getObjectAt(2));
        this.groupLinkageValue = GroupLinkageValue.getInstance(seq.getObjectAt(2));
    }

    public static LinkageData getInstance(Object src) {
        if (src instanceof LinkageData) {
            return (LinkageData)src;
        }
        if (src != null) {
            return new LinkageData(ASN1Sequence.getInstance(src));
        }
        return null;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        return new DERSequence(v);
    }
}

