/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.oer.its;

import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Choice;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Encodable;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Object;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Primitive;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1TaggedObject;
import net.savignano.thirdparty.org.bouncycastle.asn1.DEROctetString;
import net.savignano.thirdparty.org.bouncycastle.asn1.DERTaggedObject;
import net.savignano.thirdparty.org.bouncycastle.oer.its.EcdsaP256Signature;
import net.savignano.thirdparty.org.bouncycastle.oer.its.EcdsaP384Signature;

public class Signature
extends ASN1Object
implements ASN1Choice {
    public static final int ecdsaNistP256Signature = 0;
    public static final int ecdsaBrainpoolP256r1Signature = 1;
    public static final int ecdsaBrainpoolP384r1Signature = 3;
    private static final int extension = 2;
    private final int choice;
    private final ASN1Encodable value;

    public Signature(int choice, ASN1Encodable value) {
        this.choice = choice;
        this.value = value;
    }

    public static Signature getInstance(Object objectAt) {
        ASN1Object value;
        if (objectAt instanceof Signature) {
            return (Signature)objectAt;
        }
        ASN1TaggedObject ato = ASN1TaggedObject.getInstance(objectAt);
        switch (ato.getTagNo()) {
            case 0: 
            case 1: {
                value = EcdsaP256Signature.getInstance(ato.getObject());
                break;
            }
            case 2: {
                value = DEROctetString.getInstance(ato.getObject());
                break;
            }
            case 3: {
                value = EcdsaP384Signature.getInstance(ato.getObject());
                break;
            }
            default: {
                throw new IllegalStateException("unknown choice " + ato.getTagNo());
            }
        }
        return new Signature(ato.getTagNo(), value);
    }

    public static Builder builder() {
        return new Builder();
    }

    public int getChoice() {
        return this.choice;
    }

    public ASN1Encodable getValue() {
        return this.value;
    }

    public ASN1Primitive toASN1Primitive() {
        return new DERTaggedObject(this.choice, this.value);
    }

    public static class Builder {
        private int choice;
        private ASN1Encodable value;

        public Builder ecdsaNistP256Signature(EcdsaP256Signature signature) {
            this.choice = 0;
            this.value = signature;
            return this;
        }

        public Builder ecdsaBrainpoolP256r1Signature(EcdsaP256Signature signature) {
            this.choice = 1;
            this.value = signature;
            return this;
        }

        public Builder ecdsaBrainpoolP384r1Signature(EcdsaP384Signature signature) {
            this.choice = 3;
            this.value = signature;
            return this;
        }

        public Signature createSignature() {
            return new Signature(this.choice, this.value);
        }
    }
}

