/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.oer.its;

import java.io.IOException;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Choice;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Encodable;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Object;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1OctetString;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Primitive;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1TaggedObject;
import net.savignano.thirdparty.org.bouncycastle.asn1.DERNull;
import net.savignano.thirdparty.org.bouncycastle.asn1.DEROctetString;
import net.savignano.thirdparty.org.bouncycastle.asn1.DERTaggedObject;
import net.savignano.thirdparty.org.bouncycastle.oer.its.SequenceOfPsidSspRange;

public class SubjectPermissions
extends ASN1Object
implements ASN1Choice {
    public static final int explicit = 0;
    public static final int all = 1;
    public static final int extension = 3;
    private final ASN1Encodable value;
    private final int choice;

    SubjectPermissions(int choice, ASN1Encodable value) {
        this.value = value;
        this.choice = choice;
    }

    public static SubjectPermissions getInstance(Object src) {
        if (src instanceof SubjectPermissions) {
            return (SubjectPermissions)src;
        }
        ASN1TaggedObject taggedObject = ASN1TaggedObject.getInstance(src);
        int item = taggedObject.getTagNo();
        switch (item) {
            case 0: {
                return new SubjectPermissions(0, SequenceOfPsidSspRange.getInstance(taggedObject.getObject()));
            }
            case 1: {
                return new SubjectPermissions(1, DERNull.INSTANCE);
            }
            case 3: {
                try {
                    return new SubjectPermissions(3, new DEROctetString(taggedObject.getObject().getEncoded()));
                }
                catch (IOException ioException) {
                    throw new RuntimeException(ioException.getMessage(), ioException);
                }
            }
        }
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public ASN1Primitive toASN1Primitive() {
        return new DERTaggedObject(this.choice, this.value);
    }

    public static class Builder {
        int choice;
        ASN1Encodable value;

        public Builder choice(int choice) {
            this.choice = choice;
            return this;
        }

        public Builder value(ASN1Encodable value) {
            this.value = value;
            return this;
        }

        public Builder explicit(SequenceOfPsidSspRange value) {
            this.choice = 0;
            this.value = value;
            return this;
        }

        public Builder all() {
            this.choice = 1;
            this.value = DERNull.INSTANCE;
            return this;
        }

        public Builder extension(ASN1Encodable encodable) {
            this.choice = 3;
            if (encodable instanceof ASN1OctetString) {
                this.value = encodable;
            } else {
                try {
                    this.value = new DEROctetString(encodable.toASN1Primitive().getEncoded());
                }
                catch (IOException ioException) {
                    throw new RuntimeException(ioException.getMessage(), ioException);
                }
            }
            return this;
        }

        public SubjectPermissions createSubjectPermissions() {
            return new SubjectPermissions(this.choice, this.value);
        }
    }
}

