/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.tls;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.savignano.thirdparty.org.bouncycastle.tls.OCSPStatusRequest;
import net.savignano.thirdparty.org.bouncycastle.tls.TlsFatalAlert;
import net.savignano.thirdparty.org.bouncycastle.tls.TlsProtocol;
import net.savignano.thirdparty.org.bouncycastle.tls.TlsUtils;

public class CertificateStatusRequestItemV2 {
    protected short statusType;
    protected Object request;

    public CertificateStatusRequestItemV2(short statusType, Object request) {
        if (!CertificateStatusRequestItemV2.isCorrectType(statusType, request)) {
            throw new IllegalArgumentException("'request' is not an instance of the correct type");
        }
        this.statusType = statusType;
        this.request = request;
    }

    public short getStatusType() {
        return this.statusType;
    }

    public Object getRequest() {
        return this.request;
    }

    public OCSPStatusRequest getOCSPStatusRequest() {
        if (!(this.request instanceof OCSPStatusRequest)) {
            throw new IllegalStateException("'request' is not an OCSPStatusRequest");
        }
        return (OCSPStatusRequest)this.request;
    }

    public void encode(OutputStream output) throws IOException {
        TlsUtils.writeUint8(this.statusType, output);
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        switch (this.statusType) {
            case 1: 
            case 2: {
                ((OCSPStatusRequest)this.request).encode(buf);
                break;
            }
            default: {
                throw new TlsFatalAlert(80);
            }
        }
        byte[] requestBytes = buf.toByteArray();
        TlsUtils.writeOpaque16(requestBytes, output);
    }

    public static CertificateStatusRequestItemV2 parse(InputStream input) throws IOException {
        OCSPStatusRequest request;
        short status_type = TlsUtils.readUint8(input);
        byte[] requestBytes = TlsUtils.readOpaque16(input);
        ByteArrayInputStream buf = new ByteArrayInputStream(requestBytes);
        switch (status_type) {
            case 1: 
            case 2: {
                request = OCSPStatusRequest.parse(buf);
                break;
            }
            default: {
                throw new TlsFatalAlert(50);
            }
        }
        TlsProtocol.assertEmpty(buf);
        return new CertificateStatusRequestItemV2(status_type, request);
    }

    protected static boolean isCorrectType(short statusType, Object request) {
        switch (statusType) {
            case 1: 
            case 2: {
                return request instanceof OCSPStatusRequest;
            }
        }
        throw new IllegalArgumentException("'statusType' is an unsupported CertificateStatusType");
    }
}

