/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.tls.crypto.impl.bc;

import net.savignano.thirdparty.org.bouncycastle.crypto.DSA;
import net.savignano.thirdparty.org.bouncycastle.crypto.digests.NullDigest;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import net.savignano.thirdparty.org.bouncycastle.crypto.signers.DSADigestSigner;
import net.savignano.thirdparty.org.bouncycastle.tls.DigitallySigned;
import net.savignano.thirdparty.org.bouncycastle.tls.SignatureAndHashAlgorithm;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.TlsCryptoUtils;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.impl.bc.BcTlsVerifier;

public abstract class BcTlsDSSVerifier
extends BcTlsVerifier {
    protected BcTlsDSSVerifier(BcTlsCrypto crypto, AsymmetricKeyParameter publicKey) {
        super(crypto, publicKey);
    }

    protected abstract DSA createDSAImpl(int var1);

    protected abstract short getSignatureAlgorithm();

    public boolean verifyRawSignature(DigitallySigned signedParams, byte[] hash) {
        SignatureAndHashAlgorithm algorithm = signedParams.getAlgorithm();
        if (algorithm != null && algorithm.getSignature() != this.getSignatureAlgorithm()) {
            throw new IllegalStateException("Invalid algorithm: " + algorithm);
        }
        int cryptoHashAlgorithm = null == algorithm ? 2 : TlsCryptoUtils.getHash(algorithm.getHash());
        DSADigestSigner signer = new DSADigestSigner(this.createDSAImpl(cryptoHashAlgorithm), new NullDigest());
        signer.init(false, this.publicKey);
        if (algorithm == null) {
            signer.update(hash, 16, 20);
        } else {
            signer.update(hash, 0, hash.length);
        }
        return signer.verifySignature(signedParams.getSignature());
    }
}

