/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.tls.crypto.impl.jcajce;

import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPublicKeySpec;
import net.savignano.thirdparty.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import net.savignano.thirdparty.org.bouncycastle.jce.interfaces.ECPublicKey;
import net.savignano.thirdparty.org.bouncycastle.math.ec.ECCurve;
import net.savignano.thirdparty.org.bouncycastle.math.ec.ECPoint;
import net.savignano.thirdparty.org.bouncycastle.tls.NamedGroup;
import net.savignano.thirdparty.org.bouncycastle.tls.TlsFatalAlert;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.TlsAgreement;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.TlsCryptoException;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.TlsECConfig;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.TlsECDomain;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.impl.jcajce.ECUtil;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.impl.jcajce.Exceptions;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.impl.jcajce.JceTlsECDH;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.impl.jcajce.JceTlsSecret;

public class JceTlsECDomain
implements TlsECDomain {
    protected final JcaTlsCrypto crypto;
    protected final TlsECConfig ecConfig;
    protected final ECParameterSpec ecSpec;
    protected final ECCurve ecCurve;

    public JceTlsECDomain(JcaTlsCrypto crypto, TlsECConfig ecConfig) {
        ECParameterSpec spec;
        int namedGroup = ecConfig.getNamedGroup();
        if (NamedGroup.refersToAnECDSACurve(namedGroup) && null != (spec = ECUtil.getECParameterSpec(crypto, NamedGroup.getCurveName(namedGroup)))) {
            this.crypto = crypto;
            this.ecConfig = ecConfig;
            this.ecSpec = spec;
            this.ecCurve = ECUtil.convertCurve(spec.getCurve(), spec.getOrder(), spec.getCofactor());
            return;
        }
        throw new IllegalArgumentException("NamedGroup not supported: " + NamedGroup.getText(namedGroup));
    }

    public JceTlsSecret calculateECDHAgreement(PrivateKey privateKey, PublicKey publicKey) throws IOException {
        try {
            byte[] secret = this.crypto.calculateKeyAgreement("ECDH", privateKey, publicKey, "TlsPremasterSecret");
            return this.crypto.adoptLocalSecret(secret);
        }
        catch (GeneralSecurityException e) {
            throw new TlsCryptoException("cannot calculate secret", e);
        }
    }

    public TlsAgreement createECDH() {
        return new JceTlsECDH(this);
    }

    public ECPoint decodePoint(byte[] encoding) throws IOException {
        return this.ecCurve.decodePoint(encoding);
    }

    public PublicKey decodePublicKey(byte[] encoding) throws IOException {
        try {
            ECPoint point = this.decodePoint(encoding).normalize();
            BigInteger x = point.getAffineXCoord().toBigInteger();
            BigInteger y = point.getAffineYCoord().toBigInteger();
            ECPublicKeySpec keySpec = new ECPublicKeySpec(new java.security.spec.ECPoint(x, y), this.ecSpec);
            KeyFactory keyFact = this.crypto.getHelper().createKeyFactory("EC");
            return keyFact.generatePublic(keySpec);
        }
        catch (Exception e) {
            throw new TlsFatalAlert(47, (Throwable)e);
        }
    }

    public byte[] encodePoint(ECPoint point) throws IOException {
        return point.getEncoded(false);
    }

    public byte[] encodePublicKey(PublicKey publicKey) throws IOException {
        if (publicKey instanceof ECPublicKey) {
            return this.encodePoint(((ECPublicKey)publicKey).getQ());
        }
        if (publicKey instanceof java.security.interfaces.ECPublicKey) {
            java.security.spec.ECPoint w = ((java.security.interfaces.ECPublicKey)publicKey).getW();
            return this.encodePoint(this.ecCurve.createPoint(w.getAffineX(), w.getAffineY()));
        }
        SubjectPublicKeyInfo spki = SubjectPublicKeyInfo.getInstance(publicKey.getEncoded());
        return spki.getPublicKeyData().getOctets();
    }

    public KeyPair generateKeyPair() {
        try {
            KeyPairGenerator keyPairGenerator = this.crypto.getHelper().createKeyPairGenerator("EC");
            keyPairGenerator.initialize(this.ecSpec, this.crypto.getSecureRandom());
            return keyPairGenerator.generateKeyPair();
        }
        catch (GeneralSecurityException e) {
            throw Exceptions.illegalStateException("unable to create key pair: " + e.getMessage(), e);
        }
    }
}

