/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.tsp.ers;

import java.io.IOException;
import java.util.Date;
import net.savignano.thirdparty.org.bouncycastle.asn1.tsp.ArchiveTimeStamp;
import net.savignano.thirdparty.org.bouncycastle.asn1.tsp.ArchiveTimeStampChain;
import net.savignano.thirdparty.org.bouncycastle.asn1.tsp.ArchiveTimeStampSequence;
import net.savignano.thirdparty.org.bouncycastle.asn1.tsp.EvidenceRecord;
import net.savignano.thirdparty.org.bouncycastle.cert.X509CertificateHolder;
import net.savignano.thirdparty.org.bouncycastle.cms.SignerInformationVerifier;
import net.savignano.thirdparty.org.bouncycastle.operator.DigestCalculatorProvider;
import net.savignano.thirdparty.org.bouncycastle.operator.OperatorCreationException;
import net.savignano.thirdparty.org.bouncycastle.tsp.TSPException;
import net.savignano.thirdparty.org.bouncycastle.tsp.ers.ERSArchiveTimeStamp;
import net.savignano.thirdparty.org.bouncycastle.tsp.ers.ERSData;
import net.savignano.thirdparty.org.bouncycastle.tsp.ers.ERSException;

public class ERSEvidenceRecord {
    private final EvidenceRecord evidenceRecord;
    private final DigestCalculatorProvider digestCalculatorProvider;
    private final ERSArchiveTimeStamp lastArchiveTimeStamp;

    public ERSEvidenceRecord(byte[] evidenceRecord, DigestCalculatorProvider digestCalculatorProvider) throws TSPException, ERSException {
        this(EvidenceRecord.getInstance(evidenceRecord), digestCalculatorProvider);
    }

    public ERSEvidenceRecord(EvidenceRecord evidenceRecord, DigestCalculatorProvider digestCalculatorProvider) throws TSPException, ERSException {
        this.evidenceRecord = evidenceRecord;
        this.digestCalculatorProvider = digestCalculatorProvider;
        ArchiveTimeStampSequence sequence = evidenceRecord.getArchiveTimeStampSequence();
        ArchiveTimeStampChain[] chains = sequence.getArchiveTimeStampChains();
        ArchiveTimeStampChain chain = chains[chains.length - 1];
        ArchiveTimeStamp[] archiveTimestamps = chain.getArchiveTimestamps();
        this.lastArchiveTimeStamp = new ERSArchiveTimeStamp(archiveTimestamps[archiveTimestamps.length - 1], digestCalculatorProvider);
    }

    public ERSArchiveTimeStamp getLastArchiveTimeStamp() {
        return this.lastArchiveTimeStamp;
    }

    public void validatePresent(ERSData data, Date atDate) throws ERSException, OperatorCreationException {
        this.lastArchiveTimeStamp.validatePresent(data, atDate);
    }

    public void validatePresent(byte[] hash, Date atDate) throws ERSException, OperatorCreationException {
        this.lastArchiveTimeStamp.validatePresent(hash, atDate);
    }

    public X509CertificateHolder getSigningCertificate() {
        return this.lastArchiveTimeStamp.getSigningCertificate();
    }

    public void validate(SignerInformationVerifier verifier) throws TSPException {
        this.lastArchiveTimeStamp.validate(verifier);
    }

    public byte[] getEncoded() throws IOException {
        return this.evidenceRecord.getEncoded();
    }
}

