/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.cryptography.key.loader;

import java.util.Comparator;
import java.util.Optional;
import net.savignano.cryptography.enums.EKeySource;
import net.savignano.cryptography.enums.EKeyValidity;
import net.savignano.cryptography.info.InfoData;
import net.savignano.cryptography.key.IPublicCryptographyKey;
import net.savignano.cryptography.key.loader.AKeyLoader;
import net.savignano.thirdparty.org.bouncycastle.gpg.keybox.BlobType;
import net.savignano.thirdparty.org.bouncycastle.gpg.keybox.KeyBlob;
import net.savignano.thirdparty.org.bouncycastle.gpg.keybox.KeyBox;

public abstract class AKeyBoxLoader<T extends IPublicCryptographyKey<?>, B extends KeyBlob>
extends AKeyLoader<T, String>
implements Comparator<T> {
    public static final int INFO_NO_KEY_STORE = 200;
    public static final int INFO_NO_EMAIL = 201;
    public static final int INFO_EMAIL_FOUND = 202;
    public static final int INFO_EMAIL_NOT_FOUND = 203;
    private final KeyBox keyBox;
    private final BlobType blobType;

    protected AKeyBoxLoader(KeyBox keyBox, BlobType type) {
        this.keyBox = keyBox;
        this.blobType = type;
        if (type == null) {
            throw new IllegalArgumentException("Blob Type must not be null.");
        }
    }

    @Override
    public EKeySource getKeySource() {
        return EKeySource.KEYSTORE;
    }

    @Override
    protected T loadInternalKey(String email) throws Exception {
        if (this.keyBox == null) {
            this.getInfoDataManager().send(new InfoData(200, new Object[0]));
            throw new IllegalArgumentException("Key Box must not be null.");
        }
        if (email == null) {
            this.getInfoDataManager().send(new InfoData(201, new Object[0]));
            throw new IllegalArgumentException("Email must not be null.");
        }
        Optional<IPublicCryptographyKey> key = this.keyBox.getKeyBlobs().stream().filter(b -> b.getType() == this.blobType).map(this::blobToKey).filter(k -> this.isKeyForEmail(k, email)).sorted(this).findFirst();
        if (key.isPresent() && key.get().isValid()) {
            this.getLog().info("Found valid public key ({}) for email <{}> in key box.", (Object)this.getCryptography(), (Object)email);
            this.getInfoDataManager().send(new InfoData(202, email));
        } else {
            this.getLog().info("Found no valid public key ({}) for email <{}> in key box.", (Object)this.getCryptography(), (Object)email);
            this.getInfoDataManager().send(new InfoData(203, email));
        }
        return (T)key.orElse((IPublicCryptographyKey)this.getValidityKey(EKeyValidity.NOT_FOUND));
    }

    @Override
    public int compare(T o1, T o2) {
        return Integer.compare(o1.getKeyValidity().ordinal(), o2.getKeyValidity().ordinal());
    }

    private T blobToKey(KeyBlob blob) {
        try {
            T key = this.loadKeyFromBlob(blob);
            return (T)(key == null ? (IPublicCryptographyKey)this.getValidityKey(EKeyValidity.NOT_FOUND) : key);
        }
        catch (Exception e) {
            this.getLog().error("Could not load key from blob. Error message: " + e.getMessage(), (Throwable)e);
            return (T)((IPublicCryptographyKey)this.getValidityKey(EKeyValidity.ERROR));
        }
    }

    protected abstract T loadKeyFromBlob(B var1) throws Exception;

    protected abstract boolean isKeyForEmail(T var1, String var2);
}

