/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.cryptography.mail.encrypt;

import java.io.IOException;
import java.util.Optional;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.key.IPublicCryptographyKey;
import net.savignano.cryptography.mail.BaseMailCryptography;
import net.savignano.cryptography.mail.encrypt.IMailEncryptor;
import net.savignano.cryptography.util.MessageUtil;
import org.slf4j.Logger;

public abstract class AMailEncryptor<T extends IPublicCryptographyKey<?>>
extends BaseMailCryptography<T>
implements IMailEncryptor<T> {
    private static final String MAIL_HEADER_ENCRYPTED_PATTERN = "by {0} using {3} encryption";
    private static final String MAIL_HEADER_ENCRYPTED_DEBUG_PATTERN = "by {0} {1} at {2} using {3} encryption with {4}";
    private T senderKey;

    protected AMailEncryptor(Session session, ECryptographyType cryptography) {
        super(session, cryptography);
    }

    @Override
    public void encryptMessage(MimeMessage msg, T key) throws IOException, MessagingException {
        if (msg == null) {
            return;
        }
        if (key == null) {
            throw new MessagingException("Cannot encrypt message because no key was provided.");
        }
        if (!key.isValid()) {
            throw new MessagingException("Cannot encrypt message because of key having validity: " + (Object)((Object)key.getKeyValidity()));
        }
        Logger log = this.getLog();
        String msgId = MessageUtil.getMessageId(msg);
        log.info("Encrypting message for {} with msg ID: {}", (Object)this.getCryptography(), (Object)msgId);
        this.traceMessage(msg, "Original email:\n{}\n");
        try {
            this.encrypt(msg, key);
        }
        catch (IOException | MessagingException e) {
            throw e;
        }
        catch (Exception e) {
            String errMsg = "Could not encrypt message with msg ID " + msgId + ". Error message: " + e.getMessage();
            log.error(errMsg, (Throwable)e);
            throw new MessagingException(errMsg, e);
        }
        log.info("Successfully encrypted message for {} with msg ID: {}", (Object)this.getCryptography(), (Object)msgId);
        this.traceMessage(msg, "Final email:\n{}\n");
    }

    protected abstract void encrypt(MimeMessage var1, T var2) throws Exception;

    protected void includeEncryptionHeader(MimeMessage msg, String encryptionAlgorithm) throws MessagingException {
        String headerPattern = this.isVerboseHeader() ? MAIL_HEADER_ENCRYPTED_DEBUG_PATTERN : MAIL_HEADER_ENCRYPTED_PATTERN;
        this.includeCryptographyHeader(msg, "X-Encrypted", headerPattern, new Object[]{this.getCryptography(), encryptionAlgorithm});
    }

    protected boolean isVerboseHeader() {
        return this.getLog().isDebugEnabled();
    }

    public Optional<T> getSenderKey() {
        return Optional.ofNullable(this.senderKey);
    }

    public void setSenderPublicKey(T senderKey) {
        this.senderKey = senderKey;
    }
}

