/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.gui.keysource.verification;

import java.util.function.Function;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.enums.EKeySource;
import net.savignano.cryptography.enums.EKeyValidity;
import net.savignano.cryptography.info.InfoData;
import net.savignano.cryptography.key.ICryptographyKey;
import net.savignano.cryptography.key.ValidityKey;
import net.savignano.snotify.atlassian.common.ISnotifyI18n;
import net.savignano.snotify.atlassian.common.properties.ISnotifyUserProperties;
import net.savignano.snotify.atlassian.common.security.access.AUserKeyLoader;
import net.savignano.snotify.atlassian.common.security.access.pgp.PgpUserKeyLoader;
import net.savignano.snotify.atlassian.common.security.access.smime.SmimeUserKeyLoader;
import net.savignano.snotify.atlassian.common.user.IUser;
import net.savignano.snotify.atlassian.gui.keysource.verification.AKeySourceVerification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserKeySourceVerification
extends AKeySourceVerification {
    private static final Logger log = LoggerFactory.getLogger(UserKeySourceVerification.class);
    private final ISnotifyUserProperties userProps;
    private final ECryptographyType cryptography;
    private String email;
    private Function<String, IUser<?>> emailToUser;
    private IUser<?> user;

    public UserKeySourceVerification(ECryptographyType cryptography, ISnotifyUserProperties userProps, ISnotifyI18n i18n) {
        super(i18n);
        if (userProps == null) {
            throw new IllegalArgumentException("User Properties must not be null.");
        }
        this.userProps = userProps;
        this.cryptography = cryptography != null ? cryptography : ECryptographyType.NONE;
        this.getBuilder().title("net.savignano.snotify.user-verification.title", new Object[]{this.cryptography});
        this.setReportKey(false);
    }

    public void useEmail(String email, Function<String, IUser<?>> emailToUser) {
        this.email = email;
        this.emailToUser = emailToUser;
    }

    public void useUser(IUser<?> user) {
        this.user = user;
    }

    @Override
    protected void doVerify() throws Exception {
        this.checkUser();
        if (this.user != null) {
            this.setReportKey(true);
            this.loadKey();
        }
    }

    private void checkUser() {
        this.getBuilder().subTitle("net.savignano.snotify.user-verification.checkUser.title", new Object[0]);
        if (this.user == null) {
            if (this.email != null && this.emailToUser != null) {
                this.user = this.emailToUser.apply(this.email);
                if (this.user == null) {
                    this.getBuilder().warning();
                    this.getBuilder().message("net.savignano.snotify.user-verification.checkUser.notFound", this.email);
                } else {
                    this.getBuilder().info();
                    this.getBuilder().message("net.savignano.snotify.user-verification.checkUser.found", this.email, this.user.getDisplayName());
                }
            } else {
                this.getBuilder().error();
                this.getBuilder().message("net.savignano.snotify.user-verification.checkUser.notGiven", new Object[0]);
            }
        } else {
            this.getBuilder().info();
            this.getBuilder().message("net.savignano.snotify.user-verification.checkUser.given", this.user.getDisplayName());
        }
        log.debug("Used user: {}", this.user);
        this.build();
    }

    private void loadKey() {
        AUserKeyLoader loader;
        switch (this.cryptography) {
            case PGP: {
                loader = new PgpUserKeyLoader(this.userProps);
                break;
            }
            case SMIME: {
                loader = new SmimeUserKeyLoader(this.userProps);
                break;
            }
            default: {
                log.error("Cannot handle user key verification for cryptography: {}", (Object)this.cryptography);
                this.getBuilder().error();
                this.getBuilder().subTitle("net.savignano.snotify.user-verification.unknownCryptography.title", new Object[0]);
                this.getBuilder().message("net.savignano.snotify.user-verification.unknownCryptography.message", new Object[]{this.cryptography});
                this.build();
                return;
            }
        }
        loader.getInfoDataManager().register(this::handleInfoData);
        loader.loadKey(this.user);
        loader.getInfoDataManager().unregister(this::handleInfoData);
    }

    private void handleInfoData(InfoData data) {
        switch (data.infoType) {
            case 102: {
                this.handleError((Exception)data.additionalData[0]);
                break;
            }
            case 100: {
                if (((ICryptographyKey)data.additionalData[0]).getKeySource() == EKeySource.USER) {
                    this.verifyKey((ICryptographyKey)data.additionalData[0]);
                    break;
                }
                this.verifyKey(ValidityKey.key(EKeyValidity.NOT_FOUND, this.cryptography));
                break;
            }
            default: {
                log.debug("Unhandled info data of type: {}", (Object)data.infoType);
            }
        }
    }
}

