/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.gui.keysource.verification.pgp;

import java.net.URI;
import java.util.function.Consumer;
import net.savignano.cryptography.info.InfoData;
import net.savignano.cryptography.key.ICryptographyKey;
import net.savignano.cryptography.key.loader.pgp.PgpKeyServerLoader;
import net.savignano.snotify.atlassian.common.ISnotifyI18n;
import net.savignano.snotify.atlassian.gui.keysource.verification.AKeySourceVerification;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PgpKeyServerVerification
extends AKeySourceVerification {
    private static final Logger log = LoggerFactory.getLogger(PgpKeyServerVerification.class);
    private final PgpKeyServerLoader loader;
    private final String email;

    public PgpKeyServerVerification(PgpKeyServerLoader loader, String email, ISnotifyI18n i18n) {
        super(i18n);
        this.loader = loader;
        this.email = email;
        if (loader == null) {
            throw new IllegalArgumentException("Loader must not be null.");
        }
        if (i18n == null) {
            throw new IllegalArgumentException("I18n must not be null.");
        }
        this.getBuilder().title("net.savignano.snotify.key-management.verification.pgp.keyserver.title", new Object[0]);
        this.setReportKey(false);
    }

    @Override
    protected void doVerify() throws Exception {
        if (!this.validateKeyServerUrl(this.loader.getKeyServerUrl())) {
            return;
        }
        Consumer<InfoData> consumer = this::handleInfoData;
        this.loader.getInfoDataManager().register(consumer);
        this.loader.loadKey(this.email);
        this.loader.getInfoDataManager().unregister(consumer);
    }

    private void handleInfoData(InfoData data) {
        switch (data.infoType) {
            case 102: {
                this.handleError((Exception)data.additionalData[0]);
                break;
            }
            case 100: {
                this.verifyKey((ICryptographyKey)data.additionalData[0]);
                break;
            }
            case 200: {
                this.locationNotPresent();
                break;
            }
            case 201: {
                this.emailNotPresent();
                break;
            }
            case 205: {
                this.checkConnection((String)data.additionalData[0], (Integer)data.additionalData[1], (String)data.additionalData[2]);
                break;
            }
            case 204: {
                this.connectionError((String)data.additionalData[0], (Exception)data.additionalData[1]);
                break;
            }
            case 206: {
                this.emailFound((String)data.additionalData[0]);
                break;
            }
            case 207: {
                this.emailNotFound((String)data.additionalData[0]);
                break;
            }
            case 208: {
                this.wrongContentType((String)data.additionalData[0]);
                break;
            }
            case 209: {
                this.wrongContent();
                break;
            }
            default: {
                log.debug("Unhandled info data of type: {}", (Object)data.infoType);
            }
        }
    }

    private void locationNotPresent() {
        this.setReportError(false);
        this.getBuilder().warning();
        this.getBuilder().subTitle("net.savignano.snotify.key-management.verification.pgp.keyserver.locationlPresent.failure.title", new Object[0]);
        this.getBuilder().message("net.savignano.snotify.key-management.verification.pgp.keyserver.locationPresent.failure.message", new Object[0]);
        this.build();
    }

    private void emailNotPresent() {
        this.setReportError(false);
        this.getBuilder().warning();
        this.getBuilder().subTitle("net.savignano.snotify.key-management.verification.pgp.keyserver.emailPresent.failure.title", new Object[0]);
        this.getBuilder().message("net.savignano.snotify.key-management.verification.pgp.keyserver.emailPresent.failure.message", new Object[0]);
        this.build();
    }

    private boolean validateKeyServerUrl(String location) {
        log.debug("Verifying PGP key server location: {}", (Object)location);
        boolean success = false;
        try {
            URI uri = new URI(location);
            if (StringUtils.isEmpty((String)uri.getScheme())) {
                this.getBuilder().error();
                this.getBuilder().subTitle("net.savignano.snotify.key-management.verification.pgp.keyserver.validUrl.missingScheme.title", new Object[0]);
                this.getBuilder().message("net.savignano.snotify.key-management.verification.pgp.keyserver.validUrl.missingScheme.message", location);
                this.build();
            } else if (StringUtils.isEmpty((String)uri.getHost())) {
                this.getBuilder().error();
                this.getBuilder().subTitle("net.savignano.snotify.key-management.verification.pgp.keyserver.validUrl.missingHost.title", new Object[0]);
                this.getBuilder().message("net.savignano.snotify.key-management.verification.pgp.keyserver.validUrl.missingHost.message", location);
                this.build();
            } else {
                this.getBuilder().success();
                this.getBuilder().subTitle("net.savignano.snotify.key-management.verification.pgp.keyserver.validUrl.success.title", new Object[0]);
                this.getBuilder().message("net.savignano.snotify.key-management.verification.pgp.keyserver.validUrl.success.message", location);
                this.build();
                success = true;
            }
        }
        catch (Exception e) {
            log.debug("Key server location is not a valid URL: " + location, (Throwable)e);
            this.getBuilder().error();
            this.getBuilder().subTitle("net.savignano.snotify.key-management.verification.pgp.keyserver.validUrl.exception.title", new Object[0]);
            this.getBuilder().message("net.savignano.snotify.key-management.verification.pgp.keyserver.validUrl.exception.message", location, e.getClass().getSimpleName(), e.getLocalizedMessage());
            this.build();
        }
        return success;
    }

    private void checkConnection(String location, int responseCode, String responseMessage) {
        if (responseCode == 200 || responseCode == 404) {
            this.getBuilder().success();
            this.getBuilder().subTitle("net.savignano.snotify.key-management.verification.pgp.keyserver.connect.success.title", new Object[0]);
            this.getBuilder().message("net.savignano.snotify.key-management.verification.pgp.keyserver.connect.success.message", location);
            this.build();
        } else if (responseCode >= 300 && responseCode < 400) {
            this.getBuilder().info();
            this.getBuilder().subTitle("net.savignano.snotify.key-management.verification.pgp.keyserver.connect.redirect.title", new Object[0]);
            this.getBuilder().message("net.savignano.snotify.key-management.verification.pgp.keyserver.connect.redirect.message", location);
            this.build();
        } else {
            this.getBuilder().error();
            this.getBuilder().subTitle("net.savignano.snotify.key-management.verification.pgp.keyserver.connect.failure.title", new Object[0]);
            this.getBuilder().message("net.savignano.snotify.key-management.verification.pgp.keyserver.connect.failure.message", location, responseCode, responseMessage);
            this.build();
        }
    }

    private void connectionError(String location, Exception e) {
        this.getBuilder().error();
        this.getBuilder().subTitle("net.savignano.snotify.key-management.verification.pgp.keyserver.connect.exception.title", new Object[0]);
        this.getBuilder().message("net.savignano.snotify.key-management.verification.pgp.keyserver.connect.exception.message", location, e.getClass().getSimpleName(), e.getLocalizedMessage());
        this.build();
    }

    private void emailFound(String email) {
        this.setReportKey(true);
        this.getBuilder().success();
        this.getBuilder().subTitle("net.savignano.snotify.key-management.verification.pgp.keyserver.checkEmail.success.title", new Object[0]);
        this.getBuilder().message("net.savignano.snotify.key-management.verification.pgp.keyserver.checkEmail.success.message", email);
    }

    private void emailNotFound(String email) {
        this.getBuilder().warning();
        this.getBuilder().subTitle("net.savignano.snotify.key-management.verification.pgp.keyserver.checkEmail.failure.title", new Object[0]);
        this.getBuilder().message("net.savignano.snotify.key-management.verification.pgp.keyserver.checkEmail.failure.message", email);
        this.build();
    }

    private void wrongContentType(String contentType) {
        this.getBuilder().error();
        this.getBuilder().subTitle("net.savignano.snotify.key-management.verification.pgp.keyserver.checkEmail.wrongContentType.title", new Object[0]);
        this.getBuilder().message("net.savignano.snotify.key-management.verification.pgp.keyserver.checkEmail.wrongContentType.message", contentType);
        this.build();
    }

    private void wrongContent() {
        this.getBuilder().error();
        this.getBuilder().subTitle("net.savignano.snotify.key-management.verification.pgp.keyserver.checkEmail.wrongContent.title", new Object[0]);
        this.getBuilder().message("net.savignano.snotify.key-management.verification.pgp.keyserver.checkEmail.wrongContent.message", new Object[0]);
        this.build();
    }
}

