/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.gui.templates.handler.impl.provider;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import net.savignano.snotify.atlassian.gui.templates.handler.IValueHandler;
import net.savignano.snotify.atlassian.gui.templates.handler.IValueHandlerProvider;

public class BaseValueHandlerProvider
implements IValueHandlerProvider {
    private final Map<String, IValueHandler<?>> handlers = new HashMap();

    protected void register(IValueHandler<?> handler) {
        if (handler != null) {
            this.handlers.put(handler.getId(), handler);
        }
    }

    protected void unregister(IValueHandler<?> handler) {
        if (handler != null) {
            this.handlers.remove(handler.getId());
        }
    }

    public void read() {
        for (IValueHandler<?> handler : this.handlers.values()) {
            handler.read();
        }
    }

    public void store() {
        for (IValueHandler<?> handler : this.handlers.values()) {
            handler.store();
        }
    }

    public void receive(HttpServletRequest request) {
        for (IValueHandler<?> handler : this.handlers.values()) {
            handler.receive(request);
        }
    }

    public Set<String> getIds() {
        return Collections.unmodifiableSet(this.handlers.keySet());
    }

    @Override
    public <T> IValueHandler<T> getValueHandler(String id) {
        return this.handlers.get(id);
    }
}

