/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.gui.templates.handler.impl.provider;

import java.util.ArrayList;
import java.util.List;
import net.savignano.cryptography.connector.LdapConnector;
import net.savignano.cryptography.util.SecurityUtil;
import net.savignano.snotify.atlassian.common.EProperty;
import net.savignano.snotify.atlassian.common.properties.ASnotifyAppProperties;
import net.savignano.snotify.atlassian.common.properties.ISnotifyAppProperties;
import net.savignano.snotify.atlassian.gui.templates.handler.IValueHandler;
import net.savignano.snotify.atlassian.gui.templates.handler.impl.CheckBoxHandler;
import net.savignano.snotify.atlassian.gui.templates.handler.impl.InputHandler;
import net.savignano.snotify.atlassian.gui.templates.handler.impl.PasswordHandler;
import net.savignano.snotify.atlassian.gui.templates.handler.impl.provider.BaseValueHandlerProvider;
import net.savignano.snotify.atlassian.gui.templates.handler.impl.wrapper.BooleanInputToStringWrapperHandler;
import net.savignano.snotify.atlassian.gui.templates.handler.impl.wrapper.StringInputToLongWrapperHandler;
import org.apache.commons.lang3.StringUtils;

public class ExternalLdapHandlerProvider
extends BaseValueHandlerProvider {
    public static final String SMIME_PUBLIC_LDAP_HOST_ID = "smimePublicLdapHost";
    public static final String SMIME_PUBLIC_LDAP_PORT_ID = "smimePublicLdapPort";
    public static final String SMIME_PUBLIC_LDAP_SSL_ID = "smimePublicLdapSsl";
    public static final String SMIME_PUBLIC_LDAP_DN_ID = "smimePublicLdapDn";
    public static final String SMIME_PUBLIC_LDAP_FILTER_ID = "smimePublicLdapFilter";
    public static final String SMIME_PUBLIC_LDAP_MAILATTR_ID = "smimePublicLdapMailAttr";
    public static final String SMIME_PUBLIC_LDAP_USER_ID = "smimePublicLdapUser";
    public static final String SMIME_PUBLIC_LDAP_PASSWORD_ID = "smimePublicLdapPassword";
    public static final String SMIME_PUBLIC_LDAP_REFERRAL_ID = "smimePublicLdapReferral";

    public static final List<IValueHandler<?>> createValueHandlers(ISnotifyAppProperties appProps) {
        ArrayList handlers = new ArrayList();
        handlers.add(new InputHandler(SMIME_PUBLIC_LDAP_HOST_ID, appProps, EProperty.PUBLIC_LDAP_HOST_SMIME));
        handlers.add(new StringInputToLongWrapperHandler(SMIME_PUBLIC_LDAP_PORT_ID, appProps, EProperty.PUBLIC_LDAP_PORT_SMIME));
        handlers.add(new CheckBoxHandler(SMIME_PUBLIC_LDAP_SSL_ID, appProps, EProperty.PUBLIC_LDAP_SSL_SMIME));
        handlers.add(new InputHandler(SMIME_PUBLIC_LDAP_DN_ID, appProps, EProperty.PUBLIC_LDAP_DN_SMIME));
        handlers.add(new InputHandler(SMIME_PUBLIC_LDAP_FILTER_ID, appProps, EProperty.PUBLIC_LDAP_FILTER_SMIME));
        handlers.add(new InputHandler(SMIME_PUBLIC_LDAP_MAILATTR_ID, appProps, EProperty.PUBLIC_LDAP_MAILATTR_SMIME));
        handlers.add(new InputHandler(SMIME_PUBLIC_LDAP_USER_ID, appProps, EProperty.PUBLIC_LDAP_LOGIN_USER_SMIME));
        handlers.add(new PasswordHandler(SMIME_PUBLIC_LDAP_PASSWORD_ID, (ASnotifyAppProperties)appProps, EProperty.PUBLIC_LDAP_LOGIN_PASSWORD_SMIME));
        handlers.add(new BooleanInputToStringWrapperHandler(SMIME_PUBLIC_LDAP_REFERRAL_ID, appProps, EProperty.PUBLIC_LDAP_REFERRAL_SMIME, "ignore", "follow"));
        return handlers;
    }

    public ExternalLdapHandlerProvider(ISnotifyAppProperties appProps) {
        if (appProps == null) {
            throw new IllegalArgumentException("App Props must not be null.");
        }
        this.init(appProps);
    }

    private void init(ISnotifyAppProperties appProps) {
        for (IValueHandler<?> handler : ExternalLdapHandlerProvider.createValueHandlers(appProps)) {
            this.register(handler);
        }
    }

    public boolean isValid() {
        return !StringUtils.isBlank((CharSequence)((CharSequence)this.getValue(SMIME_PUBLIC_LDAP_HOST_ID))) && !StringUtils.isBlank((CharSequence)((CharSequence)this.getValue(SMIME_PUBLIC_LDAP_DN_ID)));
    }

    public LdapConnector buildConnector() {
        LdapConnector connector = new LdapConnector();
        connector.setHost((String)this.getValue(SMIME_PUBLIC_LDAP_HOST_ID));
        IValueHandler portHandler = this.getValueHandler(SMIME_PUBLIC_LDAP_PORT_ID);
        if (portHandler.getValue() != null) {
            connector.setPort(((StringInputToLongWrapperHandler)portHandler).asLong().intValue());
        }
        connector.setSsl((Boolean)this.getValue(SMIME_PUBLIC_LDAP_SSL_ID));
        connector.setLoginUser((String)this.getValue(SMIME_PUBLIC_LDAP_USER_ID));
        connector.setLoginPassword((char[])this.getValue(SMIME_PUBLIC_LDAP_PASSWORD_ID));
        connector.setDn((String)this.getValue(SMIME_PUBLIC_LDAP_DN_ID));
        connector.setFilter((String)this.getValue(SMIME_PUBLIC_LDAP_FILTER_ID));
        IValueHandler referralHandler = this.getValueHandler(SMIME_PUBLIC_LDAP_REFERRAL_ID);
        connector.setReferral(((BooleanInputToStringWrapperHandler)referralHandler).asString());
        return connector;
    }

    public void readConnector(LdapConnector connector) {
        if (connector == null) {
            return;
        }
        this.setValue(SMIME_PUBLIC_LDAP_HOST_ID, connector.getHost());
        this.setValue(SMIME_PUBLIC_LDAP_PORT_ID, String.valueOf(connector.getPort()));
        this.setValue(SMIME_PUBLIC_LDAP_SSL_ID, connector.isSsl());
        this.setValue(SMIME_PUBLIC_LDAP_USER_ID, connector.getLoginUser());
        this.setValue(SMIME_PUBLIC_LDAP_PASSWORD_ID, SecurityUtil.copyPassword(connector.getLoginPassword()));
        this.setValue(SMIME_PUBLIC_LDAP_DN_ID, connector.getDn());
        this.setValue(SMIME_PUBLIC_LDAP_FILTER_ID, connector.getFilter());
        this.setValue(SMIME_PUBLIC_LDAP_REFERRAL_ID, "follow".equals(connector.getReferral()));
    }
}

